$(document).ready(function() {
    let visible={};
    $(".menu-toggler").trigger("click");
    $("#aplicar").click(function(event) {
        //(myTable) ? myTable.clear().draw() : "";
        visible={};
        $('#tfooter th').show();
        table();
    });

    table();
    var info=new Array();
    var myTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');
    function table(){
        var importe=0;
        var extras=0;
        var prestamos=0;
        var amortizaciones=0;
        var retenciones=0;
        var fg=0;
        var total=0;
        info =
        {
            ano : $("#ano").val(),
            semana : $("#semana").val(),
            constructor : $("#constructor").val(),
            fecha_inicio : $("#fecha_inicio").val(),
            fecha_fin : $("#fecha_fin").val(),
        };
        $('#sample_3').DataTable().destroy();
        // datatable
        myTable = $("#sample_3").dataTable({
            "fixedHeader": {
                header: true,
            },
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            //lengthMenu: [[-1],["Todo"]],
            scrollX: true,
            ordering:true,
            // Initial no order.
            order: [],
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Reporte de Ordenes de Pago"),
            //Termina docs y languaje
            "bProcessing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "rordenes/listado/",
                "type": "POST",
                "data": {
                    "info": info
                }
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                //Realizar operaciones
                if(aData["tipo"]=="footer"){
                    importe+=toNumber(aData["importe"]);
                    extras+=toNumber(aData["extras"]);
                    prestamos+=toNumber(aData["prestamos"]);
                    amortizaciones+=toNumber(aData["amortizaciones"]);
                    retenciones+=toNumber(aData["retenciones"]);
                    fg+=toNumber(aData["fg"]);
                    total+=toNumber(aData["total"]);
                }
            },
            "initComplete": function () {
                var tableBody = document.querySelector ('.dataTables_scrollBody');
                var headerTable = document.querySelector ('.dataTables_scrollHead');
                var curDown = false;
                var oldScrollLeft = 0;
                var oldScrollTop = 0;
                var curXPos = 0;
                var curYPos = 0;
                
                if (tableBody) {
                  tableBody.addEventListener ("mousemove", function (e) {
                    if (curDown === true) {
                      tableBody.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      headerTable.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      tableBody.scrollTop = oldScrollTop + (curYPos - e.pageY);
                    }
                  });
                  
                  tableBody.addEventListener ("mousedown", function (e) {
                    curDown = true;
                    curYPos = e.pageY;
                    curXPos = e.pageX;
                    oldScrollLeft = tableBody.scrollLeft;
                    oldScrollTop = tableBody.scrollTop;
                  });
                  
                  tableBody.addEventListener ("mouseup", function (e) {
                    curDown = false;
                  });
                  
                  tableBody.addEventListener ("scroll", function (e) {
                    headerTable.scrollLeft = tableBody.scrollLeft;
                  });
                }
                //Resultado de operaciones
                $("#importe").text(importe);
                $("#extras").text(extras);
                $("#prestamos").text(prestamos);
                $("#amortizaciones").text(amortizaciones);
                $("#retenciones").text(retenciones);
                $("#fg").text(fg);
                $("#total").text(total);
                $(".moneda").formatCurrency();

                //reinicializacion
                importe=0;
                extras=0;
                prestamos=0;
                amortizaciones=0;
                retenciones=0;
                fg=0;
                total=0;
            },
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "constructor" },
                { "mData": "nActividades" },
                { "mData": "nLotes" },
                { "mData": "nPaquetes" },
                { "mData": "importe" },
                { "mData": "extras" },
                { "mData": "prestamos" },
                { "mData": "amortizaciones" },
                { "mData": "retenciones" },
                { "mData": "fg" },
                { "mData": "total" },
            ],
            "aaSorting": [],
            //scrollY: 300,
        });
    }

    //hide footer columns
    $(document).on("click", ".dt-button", function(e){
        let index = $(this).parent().children();
        index = index.index(this);
        if (visible.hasOwnProperty(index)) {
            let value=visible[index];
            if(value){
                $("#tfooter").find('th').eq(index).hide();
                visible[index]=false;
            }else{
                $("#tfooter").find('th').eq(index).show();
                visible[index]=true;
            }
        }else{
            visible[index]=false;
            $("#tfooter").find('th').eq(index).hide();
        }
        myTable.fnAdjustColumnSizing();
    });

    function toNumber(number){
        //let res=parseFloat(number.substring(1, number.length - 1));
        let res=number.toString().slice(1, -1);
        res=res.replaceAll(/,/g,"");
        return parseFloat(res);
    }

    $(".select2").change(function(event) {
        var idSelect = $(this).attr('id');
        if($(this).val() != 0){
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'yellow' );
        }else{
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'white' );
        }
    });
    $("#moneda").trigger('change');
});
