$(document).ready(function() {
    var tipo_promotor=$("#tipo_promotor").val();
    var promotor=$("#promotor").val();
    var fecha_inicio=$("#fecha_inicio").val();
    var fecha_fin=$("#fecha_fin").val();
    table();
    $("#aplicar").click(function(event) {
        tipo_promotor=$("#tipo_promotor").val();
        promotor=$("#promotor").val();
        fecha_inicio=$("#fecha_inicio").val().split('/');
        fecha_fin=$("#fecha_fin").val().split('/');
        fecha_inicio=(fecha_inicio != "") ? fecha_inicio[2] +"-"+fecha_inicio[1] +"-"+fecha_inicio[0] : "";
        fecha_fin=(fecha_fin != "") ? fecha_fin[2] +"-"+fecha_fin[1] +"-"+fecha_fin[0] : "";
        table();
    });
    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    $("#export_csv").click(function(event) {
        /* Act on the event */
        window.location.href="rcomisiones/export_csv/"+tipo_promotor+"_"+promotor+"_"+fecha_inicio+"_"+fecha_fin;
    });

    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');
    function table(){
        costo(tipo_promotor+"_"+promotor+"_"+fecha_inicio+"_"+fecha_fin);
        var filtros="Filtros";
        filtros+= ($("#tipo_promotor option:selected").text() != "" && $("#tipo_promotor option:selected").text() != "Seleccione") ? " > Tipo Promotor: "+$("#tipo_promotor option:selected").text() : "";
        filtros+= ($("#promotor option:selected").text() != "" && $("#promotor option:selected").text() != "Seleccione") ? " > Promotor: "+$("#promotor option:selected").text() : "";
        filtros+= (fecha_inicio != "" && fecha_fin != "") ? " > Fecha inicio: "+fecha_inicio+" - Fecha fin: "+fecha_fin : "";
        $("#filtros").text(filtros);

        // datatable
        $('[data-ride="datatables"]').DataTable().destroy();
        $('[data-ride="datatables"]').each(function() {
            var oTable = $(this).dataTable( {
                fixedHeader: {
                    header: true,
                    footer: false
                },
                "bProcessing": true,
                "sAjaxSource": "rcomisiones/listado/"+tipo_promotor+"_"+promotor+"_"+fecha_inicio+"_"+fecha_fin,
                "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
                "sPaginationType": "full_numbers",
                "aoColumns": [
                    { "mData": "fraccionamiento" },
                    { "mData": "idPromotor" },
                    { "mData": "lote" },
                    { "mData": "manzana" },
                    { "mData": "calle" },
                    { "mData": "nOficial" },
                    { "mData": "fechaVenta" },
                    { "mData": "tipoPromotor" },
                    { "mData": "cierre" },
                    { "mData": "comision" },
                    { "mData": "importeComision" }
                ],
                "aaSorting": []
            } );
        });

    }

    function costo(info){
        $.ajax({
                url: "rcomisiones/getTotal/"+info,
                type: 'GET',
                dataType: 'JSON'
                ,success: function(total){
                    $("#total").text(total);
                }
            });
    }

});

