$(document).ready(function() {
    // datatable
    table();
    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});
    
});

function table(){
    $('[data-ride="detalle"]').DataTable().destroy();
    $('[data-ride="detalle"]').each(function() {
        var oTable = $(this).dataTable({
            "lengthMenu": [[-1], ["Todo"]],
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                if(aData["tipo"] ==  'C'){

                    $(nRow.cells[0]).css('background-color', '#D9D9D9');
                    $(nRow.cells[0]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[1]).css('background-color', '#D9D9D9');
                    $(nRow.cells[1]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[2]).css('background-color', '#595959');
                    $(nRow.cells[2]).css('color', '#FFFFFF');
                    $(nRow.cells[2]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[3]).css('background-color', '#595959');
                    $(nRow.cells[3]).css('color', '#FFFFFF');
                    $(nRow.cells[3]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[4]).css('background-color', '#595959');
                    $(nRow.cells[4]).css('color', '#FFFFFF');
                    $(nRow.cells[4]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[5]).css('background-color', '#262626');
                    $(nRow.cells[5]).css('color', '#FFFFFF');
                    $(nRow.cells[5]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[6]).css('background-color', '#262626');
                    $(nRow.cells[6]).css('color', '#FFFFFF');
                    $(nRow.cells[6]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[7]).css('background-color', '#262626');
                    $(nRow.cells[7]).css('color', '#FFFFFF');
                    $(nRow.cells[7]).css('font-weight', 'bold');
                }
            },
            "fnInitComplete": function (oSettings, json) {
                getTotal();
            },
            "bProcessing": true,
            "sAjaxSource": "pmo/listadoDetallepmo/" + $("#idManoObra").val(),
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "clave" },
                { "mData": "descripcion" },
                { "mData": "unidad" },
                { "mData": "cantidad" },
                { "mData": "precioUnitario" },
                { "mData": "importe" },
                { "mData": "semana" },
                { "mData": "acciones" }
            ],
            "columnDefs": [{
                width: '30%',
                targets: 1,
                width: '17%',
                targets: 4
            }],
            "aaSorting": [],
            "paging": false,
            "ordering": false,
            "info": false
        });
    });
}

function getTotal(){
    var total=0;
    $(".importeCategoria").each(function( index ) {
        total+=parseFloat($(this).attr("title"));
    });
    $("#total").html(total);
    $(".moneda").formatCurrency();
}

function habilitarInput(element){
    var idPresupuesto = $(element).data('id');
    $("#" + idPresupuesto).css("background-color", "#fff");
    $("#" + idPresupuesto).prop('disabled', false);
}

function updatePrecio(element){
    var idPresupuesto = $(element).data('id');
    var idManoObra = $("#idManoObra").val();
    var idCategoria = $(element).data('categoria');
    var cantidad = $("#cantidadPresupuesto_"+idPresupuesto).text();
    var precioUnitario = $("#"+idPresupuesto).val();
    var length = $("#"+idPresupuesto).val().length;

    App.blockUI();

    if (!isNaN(precioUnitario) && length != 0) {
        $("#" + idPresupuesto).css("background-color", "#eef1f5");
        $("#" + idPresupuesto).prop('disabled', true);
        $.ajax({
            type: "POST",
            url: "pmo/updatePrecio",
            data: {
                idPresupuesto: idPresupuesto,
                idManoObra: idManoObra,
                idCategoria: idCategoria,
                cantidad: cantidad,
                precioUnitario: precioUnitario
            },
            dataType: "json",
            success: function (response) {
                if (!jQuery.isEmptyObject(response)){
                    $('#importePresupuesto_' + idPresupuesto).text(response.importe);
                    $('#precioUnitarioCategoria_' + idCategoria).text(response.totalUnitario);
                    $('#importeCategoria_' + idCategoria).text(response.totalImporte);
                    $('#importeCategoria_' + idCategoria).attr({"title" : response._importe});
                    getTotal();
                }
            }
        });
    } else if (length != 0) {
        $("#"+idPresupuesto).css("background-color", "red");
    }
    setTimeout(function () {
        App.unblockUI();
    }, 800);
}

function accionBorrar(element)
{
    var idPresupuesto = $(element).data('id');


    $.ajax({
        type: "POST",
        url: "pmo/borrarMOPresupuesto",
        data: {
            idPresupuesto: idPresupuesto
        },
        dataType: "json",
        beforeSend: function () {
            App.blockUI();
        },
        success: function (response) {
            App.unblockUI();
            if (!jQuery.isEmptyObject(response)) {
                if(response.status == 1){
                    //$("#aplicar").trigger("click");
                    $(element).closest('tr').remove();
                    $('#precioUnitarioCategoria_'+response.idCategoria).text(format(parseFloat(response.preCat)));
                    $('#importeCategoria_'+response.idCategoria).text(format(parseFloat(response.impCat)));
                    $('#impTotal').text(format(parseFloat(response.impTotal)));
                    $('#importe').text(format(parseFloat(response.impTotal)));
                }else{
                    ConfirmDialog('NO SE PUEDE ELIMINAR PORQUE YA EXISTE EN UNA OC', 'ALERTA');
                }
            }
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}

function addDetalle() {
    var items = $('#total_items').val();
    items = parseInt(items) + 1;
    $('#total_items').val(items);
    var html = $('#detalle').html();
    $('#content-detalle').append(html);
    $('#content-detalle').show();
    $("#item-detalle").attr("id", "item-detalle-" + items);
    $('#item-detalle-' + items).find('#categorias').attr('id', 'categorias-' + items);
    $('#item-detalle-' + items).find('#categorias-' + items).addClass("select2");
    $('#item-detalle-' + items).find('#categorias-' + items).select2();
    $('#item-detalle-' + items).find('#actividades').attr('id', 'actividades-' + items);
    $('#item-detalle-' + items).find('#actividades-' + items).addClass("select2");
    $('#item-detalle-' + items).find('#actividades-' + items).select2();
    $('#item-detalle-' + items).find('#cantidad').attr('id', 'cantidad-' + items);
    $('#item-detalle-' + items).find('#precioUnitario').attr('id', 'precioUnitario-' + items);
    $('#add').show('slow');
}

function borrar()
{
    var items = $('#total_items').val();
    if(items > 0){
        var newItems = parseInt(items) - 1;
        $('#total_items').val(newItems);
        $('#item-detalle-' + items).remove();
        if(newItems == 0){
            $('#add').hide('slow');
        }
    }else{
        $('#add').hide('slow');
    }
}

function add()
{
    $(function () {
        var items = $('#total_items').val();
        var array = new Object();
        for (var i = 1; i <= items; i++) 
        {
            var data = new Object();
            var idCate = $('#item-detalle-' + i).find('#categorias-'+i).val();
            var idActi = $('#item-detalle-' + i).find('#actividades-'+i).val();
            var cantidad = $('#item-detalle-' + i).find('#cantidad-'+i).val();
            var precioUnitario = $('#item-detalle-' + i).find('#precioUnitario-'+i).val();
            if (idCate != '' && idActi != '' && cantidad != '' && precioUnitario != ''){
                data['idCategoria'] = idCate;
                data['idActividad'] = idActi;
                data['cantidad'] = cantidad;
                data['precioUnitario'] = precioUnitario;
                array[i] = data;
            }

        }

        if(Object.keys(array).length != 0){
            var idMO = $("#idManoObra").val();

            $.ajax({
                type: "POST",
                url: "pmo/addActividad",
                data: {
                    arrayActividad: array,
                    idManoObra: idMO
                },
                dataType: "json",
                beforeSend: function () {
                    App.blockUI();
                },
                success: function (response) {
                    if (!jQuery.isEmptyObject(response)) {
                        if (response.status == 1) {
                            table();
                            /*var tbody = $('[data-ride="detalle"] tbody');
                            var data = response.rows;
                            $.each(data, function (key, value) {
                                tbody.append(data[key]); 
                            });*/
                            $('#content-detalle').empty();
                            $('#content-detalle').hide();
                            $('#total_items').val(0);
                            $('#add').hide('slow');
                            $('#impTotal').html(format(parseFloat(response.importe).toFixed(2)));
                        } else {
                            table();
                            $('#content-detalle').empty();
                            $('#content-detalle').hide();
                            $('#total_items').val(0);
                            $('#add').hide('slow');
                            //ConfirmDialog('LOS SIGUIENTES PRESUPUESTOS NO SE PUDIERON AGREGAR PORQUE YA EXISTE LA ACTIVIDAD EN ESA CATEGORIA <br><br><br> ' + response.error, 'ALERTA');
                            ConfirmDialog(response.error, 'ALERTA');
                        }
                        App.unblockUI();
                    }
                },
                error : function(jqXHR, textStatus, errorThrown) {
                    App.unblockUI();
                    if (jqXHR.status === 0) {
                        alert('Not connect: Verify Network.');
                    } else if (jqXHR.status == 404) {
                        alert('Requested page not found [404]');
                    } else if (jqXHR.status == 500) {
                        alert('Internal Server Error [500].');
                    } else if (textStatus === 'parsererror') {
                        alert('Requested JSON parse failed.');
                    } else if (textStatus === 'timeout') {
                        alert('Time out error.');
                    } else if (textStatus === 'abort') {
                        alert('Ajax request aborted.');
                    } else {
                        alert('Uncaught Error: ' + jqXHR.responseText);
                    }
                }
            });
        }
    });
}

function cargarActividad(id){
    var idSelect = id.attr('id');
    $.ajax({
        data: {
            select : idSelect,
            idCat : id.val()
        },
        url: "pmo/getActividadesByCategoriaPost",
        type: "post",
        dataType: "JSON",
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            if( response['valor'] == 1){
                var text = '<option value="">Seleccione</option>';
                for(var i = 0; i < response['actividades'].length; i++){
                    text = text + '<option value="' + response['actividades'][i]['id'] + '">' + response['actividades'][i]['text'] + '</option>';
                }
                $("#actividades-"+response['select']).val("").change();
                $("#actividades-"+response['select']).html(text);
            }
            else{
                validation('Ocurrio un error.');
            }
            App.unblockUI();
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}

function updateSemana(element)
{
    var idPresupuesto = $(element).data('id');
    var idManoObra = $("#idManoObra").val();
    var semana = $("#semana_" + idPresupuesto).val();
    var length = $("#semana_" + idPresupuesto).val().length;
    
    App.blockUI();

    if (!isNaN(semana) && length != 0) {
        $("#semana_" + idPresupuesto).css("background-color", "#eef1f5");
        $("#semana_" + idPresupuesto).prop('disabled', true);

        $.ajax({
            type: "POST",
            url: "pmo/updateSemana",
            data: {
                idPresupuesto: idPresupuesto,
                idManoObra: idManoObra,
                semana: semana
            },
            dataType: "json",
            success: function (response) {
                if (!jQuery.isEmptyObject(response)) {
                    if(response.status){
                        $("#semana_" + idPresupuesto).css("background-color", "white");
                        $("#semana_" + idPresupuesto).prop('disabled', false);
                    }else{
                        $("#semana_" + idPresupuesto).css("background-color", "red");
                        $("#semana_" + idPresupuesto).prop('disabled', false);
                    }
                }
            }
        });

    } else if (length === 0) {
        $("#semana_" + idPresupuesto).css("background-color", "red");
    }

    setTimeout(function () {
        App.unblockUI();
    }, 800);
}