$(document).ready(function() {

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    $("#filtroSemana").change(function (event) {
        var idSelect = $(this).attr('id');
        if ($(this).val() != 0) {
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css('background-color', 'yellow');
        } else {
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css('background-color', 'white');
        }
    });
});

async function actualizar(){
    let idEmpresa=$("#idEmpresa").val();
    let data=new Array();
    await $('.precioUnitario').each(function() {
        data.push({
            id:$(this).attr('id'),
            idProveedor:$(this).data('idproveedor'),
            idMaterial:$(this).data('idmaterial'),
            precioUnitario:$(this).val(),
        });
    }); 
    App.blockUI();
    let res=await ajax("pptomat/sync",{idEmpresa:idEmpresa,data:data});
    res.forEach(elem => {
        console.log();
        $("#"+elem.id).prop("disabled", false);
        $("#"+elem.id).val(elem.precioUnitario);
    });
    App.unblockUI();
}

table();
$("#aplicar").click(function (event) {
    table();
});
// datatable
function table() {
    var filtroSemana = $("#filtroSemana").val();
    $('[data-ride="detalle"]').DataTable().destroy();
    $('[data-ride="detalle"]').each(function() {
        var oTable = $(this).dataTable({
            "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
            "bProcessing": true,
            "sAjaxSource": "pptomat/listadoDetallepmat/" + $("#idMaterial").val() + "/" + filtroSemana,
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "tipo" },
                { "mData": "clave" },
                { "mData": "categoria" },
                { "mData": "proveedor" },
                { "mData": "semana" },
                { "mData": "descripcion" },
                { "mData": "unidad" },
                { "mData": "cantidad" },
                { "mData": "ajustes" },
                { "mData": "precioUnitario" },
                { "mData": "importe" },
                { "mData": "acciones" }
            ],
            "aaSorting": []
        });
    });
}

function habilitarInput(element){
    var idPresupuesto = $(element).data('id');
    $("#" + idPresupuesto).css("background-color", "#fff");
    $("#" + idPresupuesto).prop('disabled', false);
    $("#cantidadPresupuesto_" + idPresupuesto).css("background-color", "#fff");
    $("#cantidadPresupuesto_" + idPresupuesto).prop('disabled', false);
    
}

function updatePrecio(element){
    var idPresupuesto = $(element).data('id');
    var idMaterial = $("#idMaterial").val();
    var cantidad = $("#cantidadPresupuesto_"+idPresupuesto).val();
    var precioUnitario = $("#"+idPresupuesto).val();
    var length = $("#"+idPresupuesto).val().length;

    App.blockUI();

    if (!isNaN(precioUnitario) && length != 0) {
        $("#" + idPresupuesto).css("background-color", "#eef1f5");
        $("#" + idPresupuesto).prop('disabled', true);
        $("#cantidadPresupuesto_" + idPresupuesto).css("background-color", "#eef1f5");
        $("#cantidadPresupuesto_" + idPresupuesto).prop('disabled', true);
        $.ajax({
            type: "POST",
            url: "pptomat/updatePrecio",
            data: {
                idPresupuesto: idPresupuesto,
                idMaterial: idMaterial,
                cantidad: cantidad,
                precioUnitario: precioUnitario
            },
            dataType: "json",
            success: function (response) {
                if (!jQuery.isEmptyObject(response)){
                    $('#importePresupuesto_' + idPresupuesto).text(response.importe);
                    $('#tipo_' + idPresupuesto).html(response.tipo);
                    $('#ajuste_' + idPresupuesto).html(response.ajuste);
                    if(response.ajuste != ''){
                        $('#ajuste_' + idPresupuesto).show();
                    }else{
                        $('#ajuste_' + idPresupuesto).hide();
                    }
                }
            }
        });
        //sum += parseFloat(this.value);
    } else if (length != 0) {
        $("#"+idPresupuesto).css("background-color", "red");
    }
    setTimeout(function () {
        App.unblockUI()
    }, 800);
}

function accionBorrar(element)
{
    var idPresupuesto = $(element).data('id');
    var idMaterial = $("#idMaterial").val();

    App.blockUI();

    $.ajax({
        type: "POST",
        url: "pptomat/borrarMatPresupuesto",
        data: {
            idPresupuesto: idPresupuesto,
            idMaterial: idMaterial
        },
        dataType: "json",
        success: function (response) {
            table();
            if (!jQuery.isEmptyObject(response)) {
                if(response.status == 1){
                    //$("#aplicar").trigger("click");
                }else{
                    ConfirmDialog('NO SE PUEDE ELIMINAR PORQUE YA EXISTE EN UNA OC', 'ALERTA');
                }
            }
        }
    });

    setTimeout(function () {
        App.unblockUI()
    }, 800);
}

function addDetalle() {
    //$('#content-detalle').empty();
    var items = $('#total_items').val();
    items = parseInt(items) + 1;
    $('#total_items').val(items);
    var html = $('#detalle').html();
    $('#content-detalle').append(html);
    $('#content-detalle').show();
    $("#item-detalle").attr("id", "item-detalle-" + items);
    $('#item-detalle-' + items).find('#clave').attr('id', 'clave-' + items);
    $('#item-detalle-' + items).find('#clave-' + items).addClass("select2");
    $('#item-detalle-' + items).find('#clave-' + items).select2();
    $('#item-detalle-' + items).find('#proveedor').attr('id', 'proveedor-' + items);
    $('#item-detalle-' + items).find('#proveedor-' + items).addClass("select2");
    $('#item-detalle-' + items).find('#proveedor-' + items).select2();
    $('#item-detalle-' + items).find('#cantidad').attr('id', 'cantidad-' + items);
    $('#item-detalle-' + items).find('#precioUnitario').attr('id', 'precioUnitario-' + items);
    $('#item-detalle-' + items).find('#semana').attr('id', 'semana-' + items);
    //$('#item-detalle-' + items).find('#semana-' + items).addClass("select2");
    //$('#item-detalle-' + items).find('#semana-' + items).select2();
    /*$('#item-detalle-' + items).find('#btnAgregar').attr('id', 'btnAgregar-' + items);
    $('#item-detalle-' + items).find('#btnAgregar-'+items).attr('onclick', 'add($(this), '+items+');');
    $('#item-detalle-' + items).find('#btnBorrar').attr('id', 'btnBorrar-' + items);
    $('#item-detalle-' + items).find('#btnBorrar-'+items).attr('onclick', 'borrar($(this), '+items+');');*/
    $('#add').show('slow');
}

function borrar()
{
    var items = $('#total_items').val();
    if(items > 0){
        var newItems = parseInt(items) - 1;
        $('#total_items').val(newItems);
        $('#item-detalle-' + items).remove();
        if(newItems == 0){
            $('#add').hide('slow');
        }
    }else{
        $('#add').hide('slow');
    }
}

function add()
{
    $(function () {
        var items = $('#total_items').val();
        var array = new Object();
        for (var i = 1; i <= items; i++) 
        {
            var data = new Object();
            var clave = $('#item-detalle-' + i).find('#clave-'+i).val();
            var proveedor = $('#item-detalle-' + i).find('#proveedor-'+i).val();
            var cantidad = $('#item-detalle-' + i).find('#cantidad-'+i).val();
            var precioUnitario = $('#item-detalle-' + i).find('#precioUnitario-'+i).val();
            var semana = $('#item-detalle-' + i).find('#semana-'+i).val();
            if (clave != '' && proveedor != '' && cantidad != '' && precioUnitario != '' && semana != ''){
                data['clave'] = clave;
                data['proveedor'] = proveedor;
                data['cantidad'] = cantidad;
                data['precioUnitario'] = precioUnitario;
                data['semana'] = semana;
                array[i] = data;
            }

        }

        if(Object.keys(array).length != 0){
            var idMaterial = $("#idMaterial").val();

            App.blockUI();

            $.ajax({
                type: "POST",
                url: "pptomat/addMatPresupuesto",
                data: {
                    arrayMateriales: array,
                    idMaterial: idMaterial
                },
                dataType: "json",
                success: function (response) {
                    if (!jQuery.isEmptyObject(response)) {
                        if (response.status == 1) {
                            var tbody = $('[data-ride="detalle"] tbody');
                            var data = response.rows;
                            $.each(data, function (key, value) {
                                tbody.append(data[key]); 
                            });
                            $('#content-detalle').empty();
                            $('#content-detalle').hide();
                            $('#total_items').val(0);
                            $('#add').hide('slow');

                            //$('#pptoUnitario').text('PPTO. UNITARIO: ' + response.cabecera.presupuestoViv);
                        } else {
                            $('#content-detalle').empty();
                            $('#content-detalle').hide();
                            $('#total_items').val(0);
                            $('#add').hide('slow');
                            ConfirmDialog('LOS SIGUIENTES MATERIALES NO SE PUDIERON AGREGAR PORQUE <br><br> YA EXISTE CON EL PROVEEDOR ASIGNADO <br><br><br> ' + response.list, 'ALERTA');
                        }
                    }
                }
            });

            setTimeout(function () {
                App.unblockUI()
                $("#aplicar").trigger("click");
            }, 800);
        }
    });
}
