$(document).ready(function() {
    $("#export_csv").click(function(event) {
        /* Act on the event */
        window.location.href="pmo/exportarEjemplo";
    });

    var mostrarModal = $('#mostrarModal').val();
    if(mostrarModal == 'SI'){
        $('#modalActualizar').modal({backdrop: 'static', keyboard: false})
        $('#modalActualizar').modal('show');
    }else{
        $('#modalActualizar').modal('hide');
    }

    table();
    var myTable;
    function table(){

        $('#sample_3').DataTable().destroy();
        myTable = $('#sample_3').DataTable({
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            // Initial no order.
            order: [],
            //Set column definition initialisation properties
            columnDefs: [{
                targets: [0],
                orderable: false
            }],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Ppto. Obra"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "pmo/listado/",
                "type": "POST",
            },
            // DataTables server-side processing mode
            "serverSide": true,
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "titulo" },
                { "mData": "prototipo" },
                { "mData": "totalUnitario" },
                { "mData": "inputFile" }
            ]
        });
    }

    $(".blockui-save").click(function () { App.blockUI(), window.setTimeout(function () { App.unblockUI(".blockui-content") }, 2e3) });

    $("#idFraccionamiento").change(function (event) {
        App.blockUI();
        var idFraccionamiento = $(this).val();
        $("#idPrototipo").empty();
        $("#idPresupuesto").empty().trigger('change');
        $.post('pmo/getPrototiposByFracc/' + idFraccionamiento, {}, function (data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '';
            if (response2 != 0) {
                for (i in response2) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPrototipo").html(html);
            $("#idPrototipo").val(0).trigger('change');
        });
        setTimeout(function () {
            App.unblockUI()
        }, 700);
    });

    $("#idPrototipo").change(async function (event) {
        App.blockUI();
        var idEmpresa = $("#idEmpresa").val();
        var idFraccionamiento = $("#idFraccionamiento").val();
        var idPrototipo = $(this).val();
        $("#idPresupuesto").empty().trigger('change');

        let response=await ajax('presupuestos/getAll',{
            idFraccionamiento:idFraccionamiento,
            idPrototipo:idPrototipo,
            idEmpresa:idEmpresa}
        );
        console.log(response);
        if(!$.isNumeric(response)){
            var html = '';
            if (response != 0) {
                for (i in response) {
                    html += '<option value="' + response[i].id + '">' + response[i].titulo + '</option>';
                }
            }
            $("#idPresupuesto").html(html);
            $("#idPresupuesto").val(0).trigger('change');
        }   
        App.unblockUI()
    });
   
});

function editar(id){
    $("#"+id).submit();
    App.blockUI(), window.setTimeout(function () {
        App.unblockUI(".blockui-content")
    }, 2e3);
}

function redirect(){
    window.location.href="pmo";
}

var checkbox1 = document.getElementById("statusArchivo_check");
var divArchivoObra = document.getElementById("divArchivoObra");

checkbox1.addEventListener("change", function() {
    if (this.checked) {
        divArchivoObra.classList.remove("hidden"); // Si se selecciona el checkbox1, mostrar el texto
        $('#statusArchivo').val(1);
    } else {
        divArchivoObra.classList.add("hidden"); // Si se deselecciona el checkbox1, ocultar el texto
        $('#statusArchivo').val(0);
    }
});

