$(document).ready(function() {
    $("#export_csv").click(function(event) {
        /* Act on the event */
        window.location.href="pmat/exportarEjemplo";
    });

    var mostrarModal = $('#mostrarModal').val();
    if(mostrarModal == 'SI'){
        $('#modalActualizar').modal({backdrop: 'static', keyboard: false})
        $('#modalActualizar').modal('show');
    }else{
        $('#modalActualizar').modal('hide');
    }

    table();
    var myTable;
    function table(){
        $('#sample_3').DataTable().destroy();
        myTable = $('#sample_3').DataTable({
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            // Initial no order.
            order: [],
            //Set column definition initialisation properties
            columnDefs: [{
                targets: [0],
                orderable: false
            }],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Ppto. materiales"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "pmat/listado/",
                "type": "POST",
            },
            // DataTables server-side processing mode
            "serverSide": true,
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "paquete" },
                { "mData": "prototipo" },
                { "mData": "totalUnitario" },
                { "mData": "totalPaquete" },
                { "mData": "inputFile" },
            ]
        });
    }

    $(".blockui-save").click(function () { App.blockUI(), window.setTimeout(function () { App.unblockUI(".blockui-content") }, 2e3) });

    $("#idFraccionamiento").change(function (event) {
        App.blockUI();
        var idFraccionamiento = $(this).val();
        $("#idPrototipo").html('<option value="" selected="selected">Seleccione Prototipo</option>');
        $.post('pmat/getPrototiposByFracc/' + idFraccionamiento, {}, function (data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Prototipo</option>';
            if (response2 != 0) {
                for (i in response2) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPrototipo").html(html);
            $("#idPrototipo").val(0).trigger('change');
        });
        setTimeout(function () {
            App.unblockUI()
        }, 700);
    });

    $("#idPrototipo").change(async function (event) {
        App.blockUI();
        var idFraccionamiento = $("#idFraccionamiento").val();
        var idPrototipo = $(this).val();
        $("#idPaquete").html('<option value="" selected="selected">Seleccione Paquete</option>');
        $.post('pmat/getPaqueteByFraccProto/' + idFraccionamiento + '/' + idPrototipo, {}, function (data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Presupuesto MO</option>';
            if (response2 != 0) {
                for (i in response2) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPaquete").html(html);
            $("#idPaquete").val(0).trigger('change');
        });
        App.unblockUI();
    });

    $("#idPaquete").change(async function (event) {
        var idEmpresa = $("#idEmpresa").val();
        var idFraccionamiento = $("#idFraccionamiento").val();
        var idPrototipo = $("#idPrototipo").val();
        $("#idPresupuesto").empty().trigger('change');

        let response=await ajax('presupuestos/getAll',{
            idEmpresa:idEmpresa,
            idFraccionamiento:idFraccionamiento,
            idPrototipo:idPrototipo}
        );
        console.log(response);
        if(!$.isNumeric(response)){
            var html = '';
            if (response != 0) {
                for (i in response) {
                    html += '<option value="' + response[i].id + '">' + response[i].titulo + '</option>';
                }
            }
            $("#idPresupuesto").html(html);
            $("#idPresupuesto").val(0).trigger('change');
        }  
    });
});

function editar(id){
    $("#"+id).submit();
    App.blockUI(), window.setTimeout(function () {
        App.unblockUI(".blockui-content")
    }, 2e3);
}

function redirect(){
    window.location.href="pmat";
}

var checkbox1 = document.getElementById("statusArchivo_check");
var divArchivo = document.getElementById("divArchivo");

checkbox1.addEventListener("change", function() {
    if (this.checked) {
        divArchivo.classList.remove("hidden"); // Si se selecciona el checkbox1, mostrar el texto
        $('#statusArchivo').val(1);
    } else {
        divArchivo.classList.add("hidden"); // Si se deselecciona el checkbox1, ocultar el texto
        $('#statusArchivo').val(0);
    }
});