$(document).ready(function() {
    table();
    var myTable;
    function table(){
        $('#sample_3').DataTable().destroy();
        myTable = $('#sample_3').DataTable({
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            // Initial no order.
            order: [],
            //Set column definition initialisation properties
            columnDefs: [{
                targets: [0],
                orderable: false
            }],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Paquetes"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "paquetes/listado/",
                "type": "POST",
            },
            // DataTables server-side processing mode
            "serverSide": true,
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "statusPaquete" },
                { "mData": "tipoLote" },
                { "mData": "titulo" },
                { "mData": "fraccionamiento" },
                { "mData": "prototipo" },
                { "mData": "constructor" },
                { "mData": "totalUnitario" },
                { "mData": "totalPaquete" },
                { "mData": "paqueteViviendas" },          
                { "mData": "fecha_inicio" },
                { "mData": "fecha_fin" }
            ]
        });
    }

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});
    $("#idFraccionamiento").change(function(event) {
        App.blockUI();
        var idFraccionamiento = $(this).val();
        $("#idPrototipo").html('<option value="" selected="selected">Seleccione Prototipo</option>');
        $.post('paquetes/getPrototiposByFracc/'+idFraccionamiento, {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Prototipo</option>';
            if ( response2 != 0 ) {
                for ( i in response2 ) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPrototipo").html(html);
            $("#idPrototipo").val(0).trigger('change');
        });
        setTimeout(function(){ App.unblockUI() }, 700);
    });

    $("#idPrototipo").change(function (event) {
        App.blockUI();
        var idFraccionamiento = $("#idFraccionamiento").val();
        var idPrototipo = $(this).val();
        $("#idManoObra").html('<option value="" selected="selected">Seleccione Prespuesto MO</option>');
        $.post('paquetes/getManoObraByFraccProto/' + idFraccionamiento + '/' + idPrototipo, {}, function (data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="" selected="selected">Seleccione Presupuesto MO</option>';
            if (response2 != 0) {
                for (i in response2) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idManoObra").html(html);
            $("#idManoObra").val('').trigger('change');
        });
        $.post('paquetes/getLotesByFraccProto/'+idFraccionamiento + '/' + idPrototipo, {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html;
            console.log(response2);
            if ( response2 != 0 ) {
                for ( i in response2 ) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#lotes").html(html);
        });
        setTimeout(function () {
            App.unblockUI()
        }, 700);
    });


    $("#idManoObra").change(function(event) {
        App.blockUI();
        var idManoObra = $(this).val();
        $.post('paquetes/getLotesByManoObra/'+idManoObra, {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html;
            console.log(response2);
            if ( response2 != 0 ) {
                for ( i in response2 ) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#lotes").html(html);
        });
        setTimeout(function () {
            App.unblockUI()
        }, 700);
    });


    $('#lotes').attr('name', 'lotes[]');
    $('#idDetalle').attr('name', 'idDetalle[]');
});

function modalResidente(){ // al hacer click a agregar nuevo residente
    $('#modalResidente').modal('show');
}

/*function agregarResidente(id,accionEliminar=0){ // onclick en boton agregar del modal, accionEliminar = 1 indica que eliminaremos un registro
    var validacion = '';
    if(accionEliminar!=1){
        validacion += ($('#rango').val() != "") ? clear_error("#content-rango") : error("#content-rango","Es necesario ingresar un rango");
        validacion += ($('#idResidente').val() != 0) ? clear_error("#content-idResidente") : error("#content-idResidente","Es necesario elegir un residente");
        if(validacion==''){ // validamos que los lotes no excedan el maximo permitido en el paquete
            $(".modal").css("z-index", "10049");
            $.ajax({
                url: 'paquetes/checkLotes',
                type: 'POST',
                dataType: 'json',
                data: {
                    id: id,
                    rango:$('#rango').val(),
                    accionR: $('#accionR').val()
                },beforeSend: function() {
                    App.blockUI();
                    validacion += 'error';
                },success: function(data){
                    if(data.valor=="false"){
                        App.unblockUI();
                        $(".modal").css("z-index", "10050");
                        validacion += error("#content-rango","Con este rango se excede el máximo permitido");
                    }
                    if(data.valor=="true"){
                        validacion = '';
                        ////aplicar mejora////
                        if(accionEliminar==1){
                            var idResidente = $('#idR').val();
                        }else{
                            var idResidente = $('#idResidente').val();
                        }
                        $(".modal").css("z-index", "10049");
                        $.ajax({
                            url: 'paquetes/guardarResidente',
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                id: id,
                                rango:$('#rango').val(),
                                rangoOld:$('#rangoOld').val(),
                                residente:idResidente,//$('#idResidente').val(),
                                residenteOld:$('#idR').val(),
                                accionR: $('#accionR').val()
                            },beforeSend: function() {
                                App.blockUI();
                                $('.loading-message img').attr('src','/assets/global/img/loading-spinner-grey.gif');
                            },success: function(data){
                                //$(".modal").css("z-index", "10050");
                                App.unblockUI();
                                if(data.valor="true"){
                                    window.location.reload();
                                }

                            }
                        });
                        //fin mejora//

                    }
                }
            });
        }            
    }

    if(validacion == ''){
    	if(accionEliminar==1){
    		var idResidente = $('#idR').val();
    	}else{
    		var idResidente = $('#idResidente').val();
    	}
    	$(".modal").css("z-index", "10049");
    	$.ajax({
            url: 'paquetes/guardarResidente',
            type: 'POST',
            dataType: 'json',
            data: {
                id: id,
                rango:$('#rango').val(),
                rangoOld:$('#rangoOld').val(),
                residente:idResidente,//$('#idResidente').val(),
                residenteOld:$('#idR').val(),
                accionR: $('#accionR').val()
            },beforeSend: function() {
                App.blockUI();
                $('.loading-message img').attr('src','/assets/global/img/loading-spinner-grey.gif');
            },success: function(data){
            	//$(".modal").css("z-index", "10050");
                App.unblockUI();
                if(data.valor="true"){
                	window.location.reload();
                }

          	}
        });
    }
}*/

function agregarResidente(id){
    var validacion = '';
        validacion += ($('#rango').val() != "") ? clear_error("#content-rango") : error("#content-rango","Es necesario ingresar un rango");
        validacion += ($('#idDetalle').val() != "") ? clear_error("#content-lote") : error("#content-lote","Es necesario elegir un lote");
        validacion += ($('#idResidente').val() != 0) ? clear_error("#content-idResidente") : error("#content-idResidente","Es necesario elegir un residente");
        if(validacion==''){ // validamos que los lotes no excedan el maximo permitido en el paquete
            $(".modal").css("z-index", "10049");
            App.blockUI();
            $('.loading-message img').attr('src','/assets/global/img/loading-spinner-grey.gif');
            $('#formLotes').submit();
        }            
}

function accionR(idP, idR, nR, nL, accionR=0){ //nR=nombre residente, nL=numero lotes, accionR -> 0=nuevo, 1=Editar, 2=eliminar
	$('#idR').val(idR);
	$('#rango').val(nL);
	$('#rangoOld').val(nL);
    $('#accionR').val(accionR);
    $('#idPaquete').val();

	if(accionR!=2){
		$('#modalResidente').modal({
		    backdrop: 'static',
		    keyboard: false
		});
		var data = {
	    	id: idR,
	    	text: nR
		};
		var newOption = new Option(data.text, data.id, false, false);
		$('#idResidente').append(newOption);
        $('#idResidente').val(data.id).trigger('change');
        //$('#idDetalle').val(nL);
        
        $.post('paquetes/getByIdResidente/'+$('#idPaquete').val() + '/' + $('#idR').val(), {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            arrayDetalle = response2;
            console.log(response2);
            if ( response2 != 0 ) {
                for ( i in response2 ) {
                    //html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                    var dataN = {
                        id: response2[i].id,
                        text: response2[i].titulo
                    };
                    var newOption = new Option(dataN.text, dataN.id, false, false);
                    $('#idDetalle').append(newOption);
                    $("#idDetalle option[value="+response2[i].id+"]").prop("selected",true);
                    //$('#idDetalle').val(dataN.id).trigger('change');
                }
            }
            $('#idDetalle').trigger('change');
            //$("#lotes").html(html);
        });
	}
	if(accionR==2){
		$('#modalEliminarR').modal({
		    backdrop: 'static',
		    keyboard: false
        });
        
        $('#idRes').val(idR);
	}
}

function eliminarR(idP){
    var idResidente = $('#idRes').val();
    $.post('paquetes/updateAsignado/'+ idP + '/' + idResidente, {}, function(data, textStatus, xhr) {
        var response2 = $.parseJSON(data);
        if ( response2.success) {
            location.reload();
        }
    });
	//agregarResidente(idP,1); // 1 indica que eliminaremos
}

function cancelR(){
    var idR = $('#idR').val();
	$("#idResidente option[value='"+idR+"']").remove();
    console.log(arrayDetalle);
    if ( arrayDetalle != 0 ) {
        for ( i in arrayDetalle ) {
            //html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
            $("#idDetalle option[value='"+arrayDetalle[i].id+"']").remove();
        }
    }

    $("#rango").val("");
    $("#content-rango").find('.help-block-error').text("");
    $("#idDetalle").val('').trigger('change');
    $("#content-lote").find('.help-block-error').text("");
    $('#idResidente').val("0").trigger("change");
    $("#content-idResidente").find('.help-block-error').text("");
}

//Funciones de validación
function clear(){
    $("#rango").val("");
    $("#rango").find('.help-block-error').text("");
}

function error(div, msj){
        $(div).find('.help-block-error').text(msj);
        $(div).find('.help-block-error').css({
            color: 'red'
        });
        return "error";
}

function clear_error(div){
  $(div).find('.help-block-error').text("");
  return '';
}

function modalOrdenPago(id){
    var parametros = {
        "id" : id
    };
    $.ajax({
        data:  parametros,
        url:   'paquetes/getEstimacionesByPaquete',
        type:  'post',
        dataType: "JSON",
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            App.unblockUI();
            var html = '<option value="" selected="selected">Seleccione</option>';
            for (i = 0; i < response["id"].length; i++) {
                html += '<option value="' + response["id"][i] + '">' + response["semana"][i] + '</option>';
            }
            $("#idEstimaciones").html(html);
            $('#idEstimaciones').val('').trigger("change");
            $('#status').val('').trigger("change");
            $('#respuesta').modal('show');
        }
    });
}

function guardarOP(){
    if($('#idEstimaciones').val() != ''){
        var parametros = {
            "idEstimaciones" : $('#idEstimaciones').val()
        };
        $.ajax({
            data:  parametros,
            url:   'paquetes/guardarOP',
            type:  'post',
            dataType: "JSON",
            beforeSend: function () {
                App.blockUI();
                $(':input[type="button"]').prop('disabled', true);
            },
            success:  function (response) {
                if(response['msg'] == ''){
                    location.reload(true);
                }
                else{
                    $(':input[type="button"]').prop('disabled', false);
                    App.unblockUI();
                    validation(response['msg']);
                }

            }
        });
    }
    else{
        validation('Seleccione la semana');
        App.unblockUI();
    }
}

function verOrdenesPago(id){
    $('#ordenes').DataTable().destroy();
    // datatable
    $("#ordenes").dataTable({
        //Inicia docs y languaje
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
        },
        //Termina docs y languaje
        "bProcessing": true,
        "sAjaxSource": "paquetes/listarOrdenes/"+id,
        "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
        "sPaginationType": "full_numbers",
        "aoColumns": [
        { "mData": "semana" },
        { "mData": "monto" },
        { "mData": "statusPago" },
        { "mData": "acciones" }
        ],
        "aaSorting": []
    });
    $("#modalVerOrdenesP").modal('show');
}

function cambiarPagado(id){
    var parametros = {
        "id" : id
    };
    $.ajax({
        data:  parametros,
        url:   'paquetes/actualizarPagado',
        type:  'post',
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            location.reload(true);
            App.unblockUI();
        }
    });
}

function cancelarOrden(id){
    var html=   '<div class="modal fade" id="modal'+id+'" tabindex="-1" role="basic" aria-hidden="true">' +
                    '<div class="modal-dialog">' +
                        '<div class="modal-content">' +
                            '<div class="modal-header">' +
                                '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                                '<h4 class="modal-title">Alerta</h4>' +
                            '</div>' +
                            '<div class="modal-body"> ¿Desea cancelar esta orden? </div>' +
                            '<div class="modal-footer">' +
                                '<button type="button" class="btn dark btn-outline" data-dismiss="modal">No</button>' +
                                '<button type="button" id="btn_cancelar" class="btn green blockui-save">Si</button>' +
                            '</div>' +
                        '</div>' +
                    '</div>' +
                '</div>';
    $('.modal-confirm').html(html);
    $('#modal'+id).modal("show");
    $("#modalVerOrdenesP").modal('hide');
    $('#btn_cancelar').click(function(event) { cambiarCancelado(id) });
}

function cambiarCancelado(id){
    var parametros = {
        "id" : id
    };
    $.ajax({
        data:  parametros,
        url:   'paquetes/actualizarCancelado',
        type:  'post',
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            location.reload(true);
            App.unblockUI();
        }
    });
}