var array = new Object();
$(document).ready(function() {
    table();
    $('#btnGuardar').show('slow');
});

function table(){
    var idOrdenCompra = $('#idOrdenCompra').val();
    let precioU=0;
    let importe=0;
    // datatable  
    $('[data-ride="ordenE"]').DataTable().destroy();
    $('[data-ride="ordenE"]').each(function() {
        var oTable = $(this).dataTable({
            "lengthMenu": [[-1], ["Todo"]],
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                if(aData["clave"] ==  ''){
                    $(nRow.cells[0]).css('background-color', '#595959');
                    //
                    $(nRow.cells[1]).css('background-color', '#595959');
                    $(nRow.cells[1]).css('color', '#FFFFFF');
                    $(nRow.cells[1]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[2]).css('background-color', '#595959');
                    //
                    $(nRow.cells[3]).css('background-color', '#595959');
                    //
                    $(nRow.cells[4]).css('background-color', '#595959');
                    //
                    $(nRow.cells[5]).css('background-color', '#595959');
                    //
                    $(nRow.cells[6]).css('background-color', '#595959');
                    //
                    $(nRow.cells[7]).css('background-color', '#595959');
                    $(nRow.cells[7]).css('color', '#FFFFFF');
                    $(nRow.cells[7]).css('font-weight', 'bold');
                    //
                    $(nRow.cells[8]).css('background-color', '#595959');
                }
                else{
                    $(nRow.cells[4]).addClass('cantidad-' + aData["id"]);
                    $(nRow.cells[5]).addClass('precio-' + aData["id"]);
                    precioU+=parseFloat(aData["precioUnitario_"]);
                    importe+=parseFloat(aData["importe_"]);
                }
            },
            "fnDrawCallback": function() {
                //Resultado de operaciones
                $("#precioU").html(format(parseFloat(precioU).toFixed(2)));
                $("#importe").html(format(parseFloat(importe).toFixed(2)));
                precioU=0;
                importe=0;
            },
            "bProcessing": true,
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            'ajax': {
                'url': 'orden_compra/listadoEditar/',
                'type': 'POST',
                'data': {
                    'idOrdenCompra': parseInt(idOrdenCompra),
                },
            },
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "clave" },
                { "mData": "descripcion" },
                { "mData": "unidad" },
                { "mData": "cantidadViv" },
                { "mData": "cantidadPaq" },
                { "mData": "precioUnitario" },
                { "mData": "importe" },
                //{ "mData": "acciones" }
            ],
            "columnDefs": [{
                width: '25%',
                targets: 1
            }],
            "aaSorting": []
        });
    });
}

function actualizar(id, campo){
    var parametros = {
        "id" : id,
        "campo" : campo,
        "cantidad" : $("#unidades_"+id).val(),
        "precio" : $("#precio_unitario_"+id).val()
    };
    $.ajax({
        data: parametros,
        url: "orden_compra/actualizarDetalle",
        type: "post",
        dataType: "JSON",
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            App.unblockUI();
            switch(response["valor"]){
                case 'error':
                // Marcado de actualizacion
                    $('.'+campo+'-'+id).css("background","red");
                    $('.'+campo+'-'+id).find(':input').css("background","red");
                    $('.'+campo+'-'+id).find(':input').css("color","white");
                    $("#"+response["in"]+'_'+id).val(response["anterior"]);
                //Llenado del modal
                    validation(response["texto"]);
                    break;
                case 'correcto':
                    array[id] = id;
                // Marcado de actualizacion
                    $('.'+campo+'-'+id).css("background","green");
                    $('.'+campo+'-'+id).find(':input').css("background","green");
                    $('.'+campo+'-'+id).find(':input').css("color","white");
                // Llenado del dellate cambiado
                    $("#importe_"+id).html(format(parseFloat(response["importe"]).toFixed(2)));
                //Llenado del footer
                    $("#precioU").html(format(parseFloat(response["precioU"]).toFixed(2)));
                    $("#importe").html(format(parseFloat(response["importeT"]).toFixed(2)));
                    //$("#impTotal").text(format(parseFloat(response["importeT"]).toFixed(2)));
                //Llenado del modal
                    success(response["texto"]);
                    break;
                default:
                break;
            }
            setTimeout(function (){
                $('.'+campo+'-'+id).css("background","");
                $('.'+campo+'-'+id).find(':input').css("background","");
                $('.'+campo+'-'+id).find(':input').css("color","black");
            }, 5000);
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}

function guardarAlmacen(){
    var parametros = {
        "idOC" : $('#idOrdenCompra').val(),
        "idAlmacen" : $("#idAlmacen").val()
    };
    $.ajax({
        data: parametros,
        url: "orden_compra/actualizarAlmacen",
        type: "post",
        dataType: "JSON",
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            App.unblockUI();
            switch(response["valor"]){
                case 'error':
                // Marcado de actualizacion
                    $('#idAlmacen').css("background","red");
                    $('#idAlmacen').css("color","white");
                //Llenado del modal
                    validation(response["texto"]);
                    break;
                case 'correcto':
                // Marcado de actualizacion
                    $('#idAlmacen').css("background","green");
                    $('idAlmacen').css("color","white");
                //Llenado del modal
                    success(response["texto"]);
                    break;
                case 'nulo':
                // Marcado de actualizacion
                    $('#idAlmacen').css("background","yellow");
                    $('idAlmacen').css("color","white");
                //Llenado del modal
                    success(response["texto"]);
                    break;
                default:
                break;
            }
            setTimeout(function (){
                $('#idAlmacen').css("background","");
                $('#idAlmacen').find(':input').css("color","black");
            }, 5000);
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}

function accionBorrar(element){
    var idDetalle = $(element).data('id');

    $.ajax({
        type: "POST",
        url: "orden_compra/borrarDetalle",
        data: {
            idDetalle: idDetalle
        },
        dataType: "json",
        beforeSend: function () {
            App.blockUI();
        },
        success: function (response) {
            App.unblockUI();
            if (!jQuery.isEmptyObject(response)) {
                if(response.valor == 'correcto'){
                    $(element).closest('tr').remove();
                    $("#precioU").html(format(parseFloat(response["precioU"]).toFixed(2)));
                    $("#importe").html(format(parseFloat(response["importeT"]).toFixed(2)));
                    $("#impTotal").text(format(parseFloat(response["importeT"]).toFixed(2)));
                    success('SE ELIMINO EL ARTÍCULO');
                }else{
                    validation('NO SE PUEDE ELIMINAR EL ARTÍCULO');
                }
            }
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}

function addDetalle() {
    var items = $('#total_items').val();
    items = parseInt(items) + 1;
    $('#total_items').val(items);
    var html = $('#detalle').html();
    $('#content-detalle').append(html);
    $('#content-detalle').show();
    $("#item-detalle").attr("id", "item-detalle-" + items);
    $('#item-detalle-' + items).find('#clave').attr('id', 'clave-' + items);
    $('#item-detalle-' + items).find('#clave-' + items).addClass("select2");
    $('#item-detalle-' + items).find('#clave-' + items).select2();
    $('#item-detalle-' + items).find('#cantidad').attr('id', 'cantidad-' + items);
    $('#item-detalle-' + items).find('#precioUnitario').attr('id', 'precioUnitario-' + items);
    $('#add').show('slow');
}

function borrar(){
    var items = $('#total_items').val();
    if(items > 0){
        var newItems = parseInt(items) - 1;
        $('#total_items').val(newItems);
        $('#item-detalle-' + items).remove();
        if(newItems == 0){
            $('#add').hide('slow');
        }
    }else{
        $('#add').hide('slow');
    }
}

function add(){
    $(function () {
        var items = $('#total_items').val();
        var array = new Object();
        for (var i = 1; i <= items; i++) 
        {
            var data = new Object();
            var id = $('#item-detalle-' + i).find('#clave-'+i).val();
            var cantidad = $('#item-detalle-' + i).find('#cantidad-'+i).val();
            var precioUnitario = $('#item-detalle-' + i).find('#precioUnitario-'+i).val();
            if (clave != '' && cantidad != '' && precioUnitario != ''){
                data['id'] = id;
                data['cantidad'] = cantidad;
                data['precioUnitario'] = precioUnitario;
                array[i] = data;
            }
        }

        if(Object.keys(array).length != 0){
            var idOC = $("#idOrdenCompra").val();
            App.blockUI();
            $.ajax({
                type: "POST",
                url: "orden_compra/addMaterial",
                data: {
                    arrayMateriales: array,
                    idOC: idOC
                },
                dataType: "json",
                beforeSend: function () {
                    App.blockUI();
                },
                success: function (response) {
                    App.unblockUI()
                    if (!jQuery.isEmptyObject(response)) {
                        if (response.status == 1) {
                            var tableRef = document.getElementById('listado').getElementsByTagName('tbody')[0];
                            //var tbody = $('[data-ride="ordenE"] tbody');
                            //var tfooter = $('[data-ride="ordenE"] tfooter');
                            var data = response.rows;
                            $.each(data, function (key, value) {
                                var newRow = tableRef.insertRow();
                                newRow.innerHTML = data[key];
                                //tbody.append(data[key]); 
                            });
                            $('#content-detalle').empty();
                            $('#content-detalle').hide();
                            $('#total_items').val(0);
                            $('#add').hide('slow');
                            $("#precioU").html(format(parseFloat(response.precioU).toFixed(2)));
                            $("#importe").html(format(parseFloat(response.importe).toFixed(2)));
                            $("#impTotal").text(format(parseFloat(response.importe).toFixed(2)));
                        } else {
                            $('#content-detalle').empty();
                            $('#content-detalle').hide();
                            $('#total_items').val(0);
                            $('#add').hide('slow');
                            validation('ALGUNOS MATERIALES NO SE PUDIERON GUARDAR');
                        }
                    }
                },
                error : function(jqXHR, textStatus, errorThrown) {
                    App.unblockUI();
                    if (jqXHR.status === 0) {
                        alert('Not connect: Verify Network.');
                    } else if (jqXHR.status == 404) {
                        alert('Requested page not found [404]');
                    } else if (jqXHR.status == 500) {
                        alert('Internal Server Error [500].');
                    } else if (textStatus === 'parsererror') {
                        alert('Requested JSON parse failed.');
                    } else if (textStatus === 'timeout') {
                        alert('Time out error.');
                    } else if (textStatus === 'abort') {
                        alert('Ajax request aborted.');
                    } else {
                        alert('Uncaught Error: ' + jqXHR.responseText);
                    }
                }
            });
        }
    });
}

function enviarForm2()
{
    if(Object.keys(array).length != 0){
        var idOC = $("#idOrdenCompra").val();
        App.blockUI();
        $.ajax({
            type: "POST",
            url: "orden_compra/editCompra",
            data: {
                arrayMateriales: array,
                idOC: idOC
            },
            dataType: "json",
            beforeSend: function () {
                App.blockUI();
            },
            success: function (response) {
                App.unblockUI()
                if (!jQuery.isEmptyObject(response)) {
                    if (response.status == 1) {
                        success(response.msg);
                    } else {
                        validation(response.msg);
                    }
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                App.unblockUI();
                if (jqXHR.status === 0) {
                    alert('Not connect: Verify Network.');
                } else if (jqXHR.status == 404) {
                    alert('Requested page not found [404]');
                } else if (jqXHR.status == 500) {
                    alert('Internal Server Error [500].');
                } else if (textStatus === 'parsererror') {
                    alert('Requested JSON parse failed.');
                } else if (textStatus === 'timeout') {
                    alert('Time out error.');
                } else if (textStatus === 'abort') {
                    alert('Ajax request aborted.');
                } else {
                    alert('Uncaught Error: ' + jqXHR.responseText);
                }
            }
        });
    }else{
        validation('NO HAY NINGUN DATO EDITADO');
    }
}