$(document).ready(function() {
    $('#btnGuardar').hide('slow');
    $("#aplicar").click(function (event) {
        var validation = '';
        var idAlmacen = $('#idAlmacen').val();
        var semana = ($('#semana').val() != '' && $('#semana').val() != -1) ? $('#semana').val() : -1;
        validation += (idAlmacen != '' && idAlmacen != 0) ? clear_error("#content-idAlmacen") : error("#content-idAlmacen", "Campo obligatorio");

        $('#btnGuardar').hide('slow');
        if(validation == ''){
            table(idAlmacen, semana);

            $('.input-number').on('input', function () {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
        }
    });

    $("#ceros").click(function (event) {
        let state=false;
        $(".input-number").each(function( index ) {
            state=true;
            $(this).val(0);
            $(this).trigger("keyup");
        });
        (state) ? toastr.success('Se han puesto en ceros todas las cantidades') : '';
    });

    // datatable
    function table(idAlmacen, semana = -1) {
        $('[data-ride="orden"]').DataTable().destroy();
        $('[data-ride="orden"]').each(function() {
            var oTable = $(this).dataTable({
                "lengthMenu": [[-1], ["Todo"]],
                "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                    if(aData["clave"] ==  ''){
                        $(nRow.cells[0]).css('background-color', '#595959');
                        $(nRow.cells[1]).css('background-color', '#595959');
                        if (aData["proveedor"] !==  '') {
                            $(nRow.cells[1]).css('color', '#FFFFFF');
                            $(nRow.cells[1]).css('font-weight', 'bold');
                        }
                        $(nRow.cells[2]).css('background-color', '#595959');
                        if (aData["categoria"] !==  '') {
                            $(nRow.cells[2]).css('color', '#FFFFFF');
                            $(nRow.cells[2]).css('font-weight', 'bold');
                        }
                        $(nRow.cells[3]).css('background-color', '#595959');
                        $(nRow.cells[4]).css('background-color', '#595959');
                        $(nRow.cells[5]).css('background-color', '#595959');
                        $(nRow.cells[6]).css('background-color', '#595959');
                        $(nRow.cells[7]).css('background-color', '#595959');
                        $(nRow.cells[8]).css('background-color', '#595959');
                        $(nRow.cells[9]).css('background-color', '#595959');
                        $(nRow.cells[10]).css('background-color', '#595959');
                        $(nRow.cells[11]).css('background-color', '#595959');
                        $(nRow.cells[11]).css('color', '#FFFFFF');
                        $(nRow.cells[11]).css('font-weight', 'bold');
                        $(nRow.cells[12]).css('background-color', '#595959');
                    }
                },
                //"lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
                "bProcessing": true,
                //"sAjaxSource": "pmat/listadoDetallepmat/" + $("#idMaterial").val() + "/" + filtroSemana,
                "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
                'ajax': {
                    'url': 'orden_compra/getPresupuestoMaterial/',
                    'type': 'POST',
                    'data': {
                        //'idFraccionamiento': parseInt(idFraccionamiento),
                        //'idPrototipo': parseInt(idPrototipo),
                        'idAlmacen': parseInt(idAlmacen),
                        'semana': parseInt(semana)
                    },
                },
                "sPaginationType": "full_numbers",
                "aoColumns": [
                    { "mData": "clave" },
                    { "mData": "proveedor" },
                    { "mData": "categoria" },
                    { "mData": "articulo" },
                    { "mData": "unidad" },
                    { "mData": "unidades_paq" },
                    { "mData": "comprado" },
                    { "mData": "pendiente" },
                    { "mData": "cantidad" },
                    { "mData": "precio_unitario" },
                    { "mData": "importe" },
                    { "mData": "semana" }
                ],
                "columnDefs": [{
                    width: '25%',
                    targets: 6
                }],
                "aaSorting": []
            });
        });
        $('#btnGuardar').show('slow');
        setTimeout(() => {
            $(".input-number").each(function( index ) {
                $(this).trigger("keyup");
            });
        }, 8000);
    }

    if($('#vista').val() == 'nuevo'){
        if($('#msgRegistro').val() != ''){
            ConfirmDialog($('#msgRegistro').val(), 'ORDEN DE COMPRA SEMANA '+$('#semanaOc').val()).then(function (res) {
                if (res == "true") {
                    //window.location.href = 'orden_compra/nuevo';
                    $('#modalDetallado').modal('show');
                }
            });
        }
    }

    $("#idAlmacen").change(function (event) {
        App.blockUI();
        var idAlmacen = $(this).val();
        $.post('orden_compra/getSemanasByPaquete/' + idAlmacen, {}, function (data, textStatus, xhr) {
            var response = [];
            var option = {
                'id': '-1',
                'text': 'Seleccione Semana'
            };
            response[0] = option;
            if (data != 0) {
                var response2 = $.parseJSON(data);
                for (i in response2["weeks"]) {
                    response[parseInt(i) + 1] = {
                        'id': response2["weeks"][i].id,
                        'text': response2["weeks"][i].text
                    };
                }
                //(response2["repeats"]) ? $("#repeats").show() : $("#repeats").hide();
            }
            $("#semana").empty();
            $("#semana").select2({
                data: response
            });
            $('#semana').val(0);
            setTimeout(function () {
                App.unblockUI()
            }, 1000);
        });
        $.post('orden_compra/getInfo/' + idAlmacen, {}, function (dataResponse, textStatus, xhr) {
            var response = $.parseJSON(dataResponse);
            $(".datosAlmacen").html(response);
        });
    });

    $("#semana, #idAlmacen").change(function (event) {
        var idSelect = $(this).attr('id');
        if ($(this).val() != 0) {
            clear_error('#div'+idSelect);
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css('background-color', 'yellow');
        } else {
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css('background-color', 'white');
        }
    });
});

function clear() {
    $("#nombre, #telefono, #email").val("");
    $("#nombre, #telefono, #email").find('.help-block-error').text("");
}

function error(div, msj) {
    var label = $(div).find('.input-group-addon').text();
    $(div).find('.help-block-error').text(msj+' '+label);
    $(div).find('.help-block-error').css({
        color: '#d60000'
    });
    return "error";
}

function clear_error(div) {
    $(div).find('.help-block-error').text("");
    return '';
}

function enviarForm(){
    $('#validarCantidad').val('');
    var validation = '';
    var idFraccionamiento = $('#idFraccionamiento').val();
    var idPrototipo = $('#idPrototipo').val();
    var idPaquete = $('#idPaquete').val();
    var semana = $('#semana').val();
    var idAlmacen = $('#idAlmacen').val();
    var idManzana = $('#idManzana').val();

    validation += (idFraccionamiento != '' && idFraccionamiento != 0) ? clear_error("#content-idFraccionamiento") : error("#content-idFraccionamiento", "Campo obligatorio");
    validation += (idPrototipo != '' && idPrototipo != 0) ? clear_error("#content-idPrototipo") : error("#content-idPrototipo", "Campo obligatorio");
    validation += (idPaquete != '' && idPaquete != 0) ? clear_error("#content-idPaquete") : error("#content-idPaquete", "Campo obligatorio");
    validation += (semana != '' && semana != -1) ? clear_error("#content-semana") : error("#content-semana", "Campo obligatorio");
    validation += (idAlmacen != '' && idAlmacen != 0) ? clear_error("#content-idAlmacen") : error("#content-idAlmacen", "Campo obligatorio");
    validation += (idManzana != '' && idManzana != 0) ? clear_error("#content-idManzana") : error("#content-idManzana", "Campo obligatorio");

    if (validation == '') {
        $('#idAlmacen').prop('disabled', false);
        var countTrue = 0;
        var countFalse = 0;
        var arrayCantidad = new Object();
        var arrayClaves = new Object();
        var array = new Object();
        $('#listado td').each(function () {
            var data = new Object();
            var id = $(this).find('input').attr('id');
            var cantidad = ($.isNumeric($(this).find('input').val())) ? $(this).find('input').val() : 0 ;
            var clave = $(this).find('input').data("clave");
            if (cantidad != undefined && id != undefined){
                arrayCantidad[id] = cantidad;
                arrayClaves[id] = clave;
                var cantidadPresupuesto = $('#'+id).data('cantidad');
                if(parseFloat(cantidad) <= parseFloat(cantidadPresupuesto)){
                    countTrue++;
                }else{
                    countFalse++;
                    data['clave'] = $('#'+id).data('clave');
                    data['presupuesto'] = cantidadPresupuesto;
                    data['ordenCompra'] = cantidad;
                    data['excedente'] = cantidad - cantidadPresupuesto;
                    array[id] = data;
                }
            }
        });
        console.warn(arrayCantidad);

        $('#arrayCantidad').val(JSON.stringify(arrayCantidad));
        $('#arrayClaves').val(JSON.stringify(arrayClaves));
        $('#array').val(JSON.stringify(array));
        /*if(parseInt(countTrue) > 0 && parseInt(countFalse) == 0){*/
            $('#validarCantidad').val(1);
            $("#formOrden").submit();
            App.blockUI(), window.setTimeout(function () {
                App.unblockUI(".blockui-content")
            }, 2e3);
        /*}else{
            var usuario = $("#usuario").val();
            $('#validarCantidad').val(0);
            ConfirmDialogInput('¿ESTAS SEGURO DE AGREGAR LA ORDEN DE COMPRA?', true).then(function (res) {
                if (res == "true") {
                    $("#formOrden").submit();
                    App.blockUI(), window.setTimeout(function () {
                        App.unblockUI(".blockui-content")
                    }, 2e3);
                }else{
                    ConfirmDialog('EL USUARIO NO PUEDE AUTORIZAR LOS EXCEDENTES', 'ALERTA').then(function (res) {
                    });
                }
            });
        }*/
    }
}

function getTotal(element)
{
    var id = $(element).attr('id');
    var idProveedor = $(element).data('proveedor');
    var claveCat = $(element).data('clave_cat');
    var maxima = $(element).data('cantidad');
    var cantidad = $(element).val();
    var precioUnitario = $('#precioUnitario_'+id).data('precio');

    if($.isNumeric(cantidad)){
        if(parseFloat(cantidad) <= parseFloat(maxima)){
            if ($.isNumeric(cantidad)){
                $('#importe_'+id).text('$'+parseFloat(cantidad * precioUnitario).toFixed(2));
                var importeTotal = 0.00
                var importeTotalCat = 0.00
                $('#listado td').each(function () {
                    var id = $(this).find('input').attr('id');
                    var cant = $(this).find('input').val();
                    var proveedor = $(this).find('input').data('proveedor');
                    var categoria = $(this).find('input').data('clave_cat');
                    if (idProveedor == proveedor) {
                        if ($.isNumeric(cant)) {
                            var importe = parseInt(cant) * parseFloat($('#precioUnitario_' + id).data('precio'));
                            importeTotal = importeTotal + importe;
                        }else{
                            var importe = 0.00;
                            importeTotal = importeTotal + importe;
                        }
                    }
                    if (claveCat == categoria) {
                        if ($.isNumeric(cant)) {
                            var importe = parseFloat(cant) * parseFloat($('#precioUnitario_' + id).data('precio'));
                            importeTotalCat = importeTotalCat + importe;
                        }else{
                            var importe = 0.00;
                            importeTotalCat = importeTotalCat + importe;
                        }
                    }
                });
                $('#proveedor_' + idProveedor).html(importeTotal);
                $('#cat_' + idProveedor + '_' + claveCat).html(importeTotalCat);
                $(".moneda").formatCurrency();
            } else {
                $('#importe_' + id).text('$' + parseFloat(0.00).toFixed(2));
                var importeTotal = 0.00
                var importeTotalCat = 0.00
                $('#listado td').each(function () {
                    var id = $(this).find('input').attr('id');
                    var cant = $(this).find('input').val();
                    var proveedor = $(this).find('input').data('proveedor');
                    var categoria = $(this).find('input').data('clave_cat');
                    if (idProveedor == proveedor) {
                        if ($.isNumeric(cant)) {
                            var importe = parseInt(cant) * parseFloat($('#precioUnitario_' + id).data('precio'));
                            importeTotal = importeTotal + importe;
                        } else {
                            var importe = 0.00;
                            importeTotal = importeTotal + importe;
                        }
                    }
                    if (claveCat == categoria) {
                        if ($.isNumeric(cant)) {
                            var importe = parseFloat(cant) * parseFloat($('#precioUnitario_' + id).data('precio'));
                            importeTotalCat = importeTotalCat + importe;
                        } else {
                            var importe = 0.00;
                            importeTotalCat = importeTotalCat + importe;
                        }
                    }
                });
                $('#proveedor_' + idProveedor).text('$' + parseFloat(importeTotal).toFixed(2));
                $('#cat_' + idProveedor + '_' + claveCat).text('$' + parseFloat(importeTotal).toFixed(2));
            }
        }else{
            toastr.error('Excediste la cantidad máxima disponible de este artículo')
            $(element).val(0);
        }
    }else{
        toastr.error('La cantidad debe de ser numérica')
        $(element).val(0);
    }

}