$(document).ready(function() {
// datatable
    $('[data-ride="datatables"]').each(function() {
        var oTable = $(this).dataTable( {
            "bProcessing": true,
            "sAjaxSource": "estimadoxdia/listado",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "idFraccionamiento" },
                { "mData": "idPrototipo" },
                { "mData": "estimaciones" },
                { "mData": "paquete" },
                { "mData": "acciones" }
            ],
            "aaSorting": []
        } );
    });

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

});

$("#idFraccionamiento").change(function(event) {
    App.blockUI();
    var idFraccionamiento = $(this).val();
    $("#idPrototipo").html('<option value="" selected="selected">Seleccione Prototipo</option>');
    $.post('estimaciones/getPrototiposByFracc/'+idFraccionamiento, {}, function(data, textStatus, xhr) {
        var response2 = $.parseJSON(data);
        var html = '<option value="0" selected="selected">Seleccione Prototipo</option>';
        if ( response2 != 0 ) {
            for ( i in response2 ) {
                html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
            }
        }
        $("#idPrototipo").html(html);
        $("#idPrototipo").val(0).trigger('change');
    });
    setTimeout(function(){ App.unblockUI() }, 900);
});

$("#idPrototipo").change(function(event) {
    App.blockUI();
    var idFraccionamiento = $('#idFraccionamiento').val();
    var idPrototipo = $(this).val();
    var estimaciones = '';
    $("#idPaquete").html('<option value="" selected="selected">Seleccione Paquete</option>');
    $.post('estimaciones/getPaquetesByFraccProt/'+idFraccionamiento+'/'+idPrototipo, {}, function(data, textStatus, xhr) {
        var response2 = $.parseJSON(data);
        var html = '<option value="0" selected="selected">Seleccione Paquete</option>';
        if ( response2 != 0 ) {
            for ( i in response2 ) {
                html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                estimaciones = response2[i].estimaciones;
            }
        }
        $("#estimaciones").val(estimaciones);
        $("#idPaquete").html(html);
        $("#idPaquete").val(0).trigger('change');
    });
    setTimeout(function(){ App.unblockUI() }, 900);
});

function actualizar(id){
    var parametros = {
        "id" : id,
        "valor" : $("#estimados_"+id).val()
    };
    $.ajax({
        data: parametros,
        url: "estimaciones/actualizar",
        type: "post",
        dataType: "JSON",
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            App.unblockUI();
            switch(response["valor"]){
                case 'error':
                //Llenado del modal
                    $("#titulo").html(response["titulo"]);
                    $("#texto").html(response["texto"]);
                    $('#respuesta').modal('show');
                    break;
                case 'correcto':
                // Llenado de la estimacion cambiada
                    $("#pagar_"+id).html(response["estimacion"]);
                //Llenado por actividad
                    for (i = 0; i < response["ids"].length; i++) {
                        $("#pendiPagar_"+response["ids"][i]).html(response["pendiPagar"]);
                        $("#acuPagar_"+response["ids"][i]).html(response["acuPagar"]);
                        $("#acuLotes_"+response["ids"][i]).html(response["acuLotes"]);
                        $("#pendiLotes_"+response["ids"][i]).html(response["pendiLotes"]);
                    }
                // Llenado por categoria
                    $("td[id*='pendiPagarC_"+response["categoria"]+"']").html(response["pendiPagarC"]);
                    $("td[id*='acuPagarC_"+response["categoria"]+"']").html(response["acuPagarC"]);
                //Llenado del modal
                    $("#titulo").html(response["titulo"]);
                    $("#texto").html(response["texto"]);
                    $('#respuesta').modal('show');
                    break
                default:
                break;
            }
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}