$(document).ready(function() {
    table();
    var myTable;
    function table(){

        $('#sample_3').DataTable().destroy();
        myTable = $('#sample_3').DataTable({
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            // Initial no order.
            order: [],
            //Set column definition initialisation properties
            columnDefs: [{
                targets: [0],
                orderable: false
            }],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Estimaciones"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "estimaciones_programa/listado/",
                "type": "POST",
            },
            // DataTables server-side processing mode
            "serverSide": true,
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "idFraccionamiento" },
                { "mData": "idPrototipo" },
                { "mData": "estimaciones" },
                { "mData": "paquete" },
                { "mData": "totalMO" },
                { "mData": "moPagado" },
                { "mData": "moPorPagar" },
            ]
        });
    }
    
    
        
        $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});
    
});
    
    /*
    $("#idFraccionamiento").change(function(event) {
        App.blockUI();
        var idFraccionamiento = $(this).val();
        $("#idPrototipo").html('<option value="" selected="selected">Seleccione Prototipo</option>');
        $.post('estimaciones_programa/getPrototiposByFracc/'+idFraccionamiento, {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Prototipo</option>';
            if ( response2 != 0 ) {
                for ( i in response2 ) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPrototipo").html(html);
            $("#idPrototipo").val(0).trigger('change');
        });
        setTimeout(function(){ App.unblockUI() }, 900);
    });
    
    $("#idPrototipo").change(function(event) {
        App.blockUI();
        var idFraccionamiento = $('#idFraccionamiento').val();
        var idPrototipo = $(this).val();
        var estimaciones = '';
        $("#idPaquete").html('<option value="" selected="selected">Seleccione Paquete</option>');
        $.post('estimaciones_programa/getPaquetesByFraccProt/'+idFraccionamiento+'/'+idPrototipo, {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Paquete</option>';
            if ( response2 != 0 ) {
                for ( i in response2 ) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                    estimaciones = response2[i].estimaciones;
                }
            }
            $("#estimaciones").val(estimaciones);
            $("#idPaquete").html(html);
            $("#idPaquete").val(0).trigger('change');
        });
        setTimeout(function(){ App.unblockUI() }, 900);
    });
    */
    
    $("#idPaquete").change(function(event) {
        App.blockUI();
        var idPaquete = $(this).val();
        var estimaciones = '';
        $.post('estimaciones_programa/getEstimacionesByPaquete/'+idPaquete, {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            if ( response2.length != 0 ) {
                estimaciones = response2.estimaciones;
            }
            $("#estimaciones").val(estimaciones);
        });
        setTimeout(function(){ App.unblockUI() }, 900);
    });
    
    // actualizar estimaciones
    function actualizarDias(id,dia,obj){
        var parametros = {
            "id" : id,
            "valor" : obj.value,
            "dia" : dia,
            "actividad": $('#actividad').val(),
            "prototipo": $('#prototipo').val(),
            "idPaquete": $('#idPaquete').val()
        };    
        $.ajax({
            data: parametros,
            url: "estimaciones_programa/actualizarDias",
            type: "post",
            dataType: "JSON",
            beforeSend: function () {
                App.blockUI();
            },
            success:  function (response) {
                App.unblockUI();
                switch(response["valor"]){
                    case 'error':
                    //Llenado del modal
    
                        /*$("#titulo").html(response["titulo"]);
                        $("#texto").html(response["texto"]);
                        $('#respuesta').modal('show');*/
    
    
                        //$('div[id = alrt-message]').html(response["alert"]);
                        obj.value = response['val'];
    
                        validation(response["texto"]);
                        //$("#pendiPagar_"+id).css("background","red");
                        $('.day-'+dia+"-"+id).css("background","red");
                        $('.day-'+dia+"-"+id).find(':input'),css("background","red");
                        $('.day-'+dia+"-"+id).find(':input'),css("color","white");                    
                        //$("#estimados_"+id).css("background","red");
                        //$("#estimados_"+id).css("color","white");
                        $('.day-'+dia+"-"+id).find(':input').val(0);                     
                        break;
                    case 'limite':
                    //Llenado del modal
                        //$("#titulo").html(response["titulo"]);
                        //$("#texto").html(response["texto"]);
                        //$("#pendiPagar_"+id).css("background","red");
                        $('.day-'+dia+"-"+id).css("background","red");
                        $('.day-'+dia+"-"+id).find(':input').css("background","red");
                        $('.day-'+dia+"-"+id).find(':input').css("color","white");
                        //$("#estimados_"+id).css("background","red");
                        //$("#estimados_"+id).css("color","white");
                        $('.day-'+dia+"-"+id).find(':input').val(0);
    
                        validation(response["texto"]);
                        //$('#respuesta').modal('show');
                        break;
                    case 'correcto':
                    //Llenado del modal
                        //$("#titulo").html(response["titulo"]);
                        //$("#texto").html(response["texto"]);
                        
                        //$("#pendiPagar_"+id).css("background","green");
                        $('.day-'+dia+"-"+id).css("background","green");
                        $('.day-'+dia+"-"+id).find(':input').css("background","green");
                        $('.day-'+dia+"-"+id).find(':input').css("color","white"); 
    
                        //$("#estimados_"+id).css("background","green");
                        //$("#estimados_"+id).css("color","white");
    
                        success(response["texto"]);
                        //$('#respuesta').modal('show');
                        break;
                    default:
                    break;
                }
                setTimeout(function (){
                    $('.day-'+dia+"-"+id).css("background","");
                    $('.day-'+dia+"-"+id).find(':input').css("background","");
                    $('.day-'+dia+"-"+id).find(':input').css("color","black");
                }, 5000);
            },
            error : function(jqXHR, textStatus, errorThrown) {
                App.unblockUI();
                if (jqXHR.status === 0) {
                    alert('Not connect: Verify Network.');
                } else if (jqXHR.status == 404) {
                    alert('Requested page not found [404]');
                } else if (jqXHR.status == 500) {
                    alert('Internal Server Error [500].');
                } else if (textStatus === 'parsererror') {
                    alert('Requested JSON parse failed.');
                } else if (textStatus === 'timeout') {
                    alert('Time out error.');
                } else if (textStatus === 'abort') {
                    alert('Ajax request aborted.');
                } else {
                    alert('Uncaught Error: ' + jqXHR.responseText);
                }
            }
        });
    }
    
    function actualizar(id){
        var parametros = {
            "id" : id,
            "valor" : $("#estimados_"+id).val()
        };
        $.ajax({
            data: parametros,
            url: "estimaciones_programa/actualizar",
            type: "post",
            dataType: "JSON",
            beforeSend: function () {
                App.blockUI();
            },
            success:  function (response) {
                App.unblockUI();
                switch(response["valor"]){
                    case 'error':
                    // Marcado de actualizacion
                        $('.estimados-'+id).css("background","red");
                        $('.estimados-'+id).find(':input').css("background","red");
                        $('.estimados-'+id).find(':input').css("color","white");
                        $("#estimados_"+id).val(response["anterior"]);
                    //Llenado del modal
                        //$("#titulo").html(response["titulo"]);
                        //$("#texto").html(response["texto"]);
                        //$('#respuesta').modal('show');
                        validation(response["texto"]);
                        break;
                    case 'correcto':
                    // Marcado de actualizacion
                        $('.estimados-'+id).css("background","green");
                        $('.estimados-'+id).find(':input').css("background","green");
                        $('.estimados-'+id).find(':input').css("color","white");
                    // Llenado de la estimacion cambiada
                        $("#pagar_"+id).html(format(parseFloat(response["estimacion"]).toFixed(2)));
                    //Llenado por actividad
                        for (i = 0; i < response["ids"].length; i++) {
                            if( $("#pendiPagar_"+response["ids"][i]).length ){
                                $("#pendiPagar_"+response["ids"][i]).html(format(parseFloat(response["pendiPagar"]).toFixed(2)));
                                $("#acuPagar_"+response["ids"][i]).html(format(parseFloat(response["acuPagar"]).toFixed(2)));
                                $("#acuLotes_"+response["ids"][i]).html(response["acuLotes"]);
                                $("#pendiLotes_"+response["ids"][i]).html(response["pendiLotes"]);
                            }
                        }
                    // Llenado por categoria
                        $("td[id*='pendiPagarC_"+response["categoria"]+"']").html(format(parseFloat(response["pendiPagarC"]).toFixed(2)));
                        $("td[id*='acuPagarC_"+response["categoria"]+"']").html(format(parseFloat(response["acuPagarC"]).toFixed(2)));
                    //Llenado del modal
                        //$("#titulo").html(response["titulo"]);
                        //$("#texto").html(response["texto"]);
                        //$('#respuesta').modal('show');
                        success(response["texto"]);
                        break
                    default:
                    break;
                }
                setTimeout(function (){
                    $('.estimados-'+id).css("background","");
                    $('.estimados-'+id).find(':input').css("background","");
                    $('.estimados-'+id).find(':input').css("color","black");
                }, 5000);
            },
            error : function(jqXHR, textStatus, errorThrown) {
                App.unblockUI();
                if (jqXHR.status === 0) {
                    alert('Not connect: Verify Network.');
                } else if (jqXHR.status == 404) {
                    alert('Requested page not found [404]');
                } else if (jqXHR.status == 500) {
                    alert('Internal Server Error [500].');
                } else if (textStatus === 'parsererror') {
                    alert('Requested JSON parse failed.');
                } else if (textStatus === 'timeout') {
                    alert('Time out error.');
                } else if (textStatus === 'abort') {
                    alert('Ajax request aborted.');
                } else {
                    alert('Uncaught Error: ' + jqXHR.responseText);
                }
            }
        });
    }

    const modalLotes="#modalLotes";
    function obtener_avance(id){
        $("#actualizarAvance").data("idEstimado",id);
        $('#lotesAvance').empty();
        $(modalLotes).find(".modal-title").html($("#descripcion_"+id).html());

        var parametros = {
            "idEstimado" : id,
            "idPaquete" : $("#idPaquete").val()
        };
        $.ajax({
            data: parametros,
            url: "estimaciones_programa/obtener_avance",
            type: "post",
            dataType: "JSON",
            beforeSend: function () {
                App.blockUI();
            },
            success:  function (response) {
                App.unblockUI();
                if(!$.isNumeric(response)){
                    response.forEach(element => {
                        console.log(element);
                        let selected=(element.estatus=='1') ? true : false;
                        addOption("#lotesAvance",element.id,element.titulo,selected);
                        $("#lotesAvance").trigger('change')
                    });
                    $(modalLotes).modal("show");
                }else{
                    validation('No hay lotes disponibles por estimar en este concepto');
                }
            },
            error : function(jqXHR, textStatus, errorThrown) {
                App.unblockUI();
                if (jqXHR.status === 0) {
                    alert('Not connect: Verify Network.');
                } else if (jqXHR.status == 404) {
                    alert('Requested page not found [404]');
                } else if (jqXHR.status == 500) {
                    alert('Internal Server Error [500].');
                } else if (textStatus === 'parsererror') {
                    alert('Requested JSON parse failed.');
                } else if (textStatus === 'timeout') {
                    alert('Time out error.');
                } else if (textStatus === 'abort') {
                    alert('Ajax request aborted.');
                } else {
                    alert('Uncaught Error: ' + jqXHR.responseText);
                }
            }
        });
    }

    $('#actualizarAvance').click(function(event) { 
        let self=this;
        $(self).prop( "disabled", true );
        let proyectos=$('#lotesAvance').val();
        let idEstimado=$(this).data("idEstimado");
        let parametros={
            proyectos:proyectos,
            idEstimado:idEstimado
        };
        $.ajax({
            data: parametros,
            url: "estimaciones_programa/actualizar_avance",
            type: "post",
            dataType: "JSON",
            beforeSend: function () {
                App.blockUI();
            },
            success:  function (response) {
                $(modalLotes).modal("hide");
                $(self).prop( "disabled", false );
                App.unblockUI();
                $("#estimados_"+idEstimado).val(response);
                $("#estimados_"+idEstimado).trigger("change");
            },
            error : function(jqXHR, textStatus, errorThrown) {
                App.unblockUI();
                if (jqXHR.status === 0) {
                    alert('Not connect: Verify Network.');
                } else if (jqXHR.status == 404) {
                    alert('Requested page not found [404]');
                } else if (jqXHR.status == 500) {
                    alert('Internal Server Error [500].');
                } else if (textStatus === 'parsererror') {
                    alert('Requested JSON parse failed.');
                } else if (textStatus === 'timeout') {
                    alert('Time out error.');
                } else if (textStatus === 'abort') {
                    alert('Ajax request aborted.');
                } else {
                    alert('Uncaught Error: ' + jqXHR.responseText);
                }
            }
        });
    });
    
    function addOption(name,id,titulo,selected=false){
        var o = $("<option/>", {
            value: id,
            text: titulo
        });
        $(name).append(o);
        $(name+' option[value="' + id + '"]').prop('selected',selected);
    }
    
    function cargarEstimacion(element="#cargarEstimacion", redirect=true){
        if($('#idEstimaciones').val() != ''){
            var parametros = {
                "idEstimaciones" : $('#idEstimaciones').val()
            };
            $(element).prop("disabled", true);
            $.ajax({
                data:  parametros,
                url:   'estimaciones_programa/cargarEstimacion',
                type:  'post',
                dataType: "JSON",
                beforeSend: function () {
                    $(element).text('GUARDANDO...');
                    $('#idEstimaciones').prop('disabled', true);
                    //$(':input[type="button"]').prop('disabled', true);
                    (redirect) ? App.blockUI() : '';
                    $('#cargarE').css({
                       'z-index' : 1000
                    });
                },
                success:  function (response) {
                    $(element).text('GUARDAR');
                    $(element).prop( "disabled", false );
                    if(response['msg'] == ''){
                        (redirect) ? document.location.href = 'estimaciones_programa/detalle/'+$("#id").val()+'/'+$('#idEstimaciones').val() : '';
                        //location.reload(true);
                    }
                    else{
                        (redirect)  ? App.unblockUI() : '';
                        validation(response['msg']);
                    }
                    $('#idEstimaciones').prop('disabled', false);
                    //$(':input[type="button"]').prop('disabled', false);
                }
            });
        }
        else{
            validation('Seleccione la semana');
            //App.unblockUI();
        }
    }
    
    function abrirNuevoME(){
        $('#nuevoE').modal('show');
    }
    
    function crearEstiAtrasada(idEsti){
        if($('#fecha_inicioN').val() != ''){
            var parametros = {
                "idEstis" : idEsti,
                "ultEsti" : $('#lastEstimaciones').val(),
                "fecha_inicioN" : $('#fecha_inicioN').val()
            };
            $.ajax({
                data:  parametros,
                url:   'estimaciones_programa/nuevaEstimacionAtrasada',
                type:  'post',
                dataType: "JSON",
                beforeSend: function () {
                    $(':input[type="button"]').prop('disabled', true);
                    App.blockUI();
                },
                success:  function (response) {
                    if(response['msg'] == ''){
                        success('Estimación creada.');
                        setTimeout(function(){ 
                            location.reload(true);
                        }, 5000);
                    }
                    else{
                        App.unblockUI();
                        $(':input[type="button"]').prop('disabled', false);
                        validation(response['msg']);
                    }
                }
            });
        }
        else{
            validation('Elija una fecha');
            App.unblockUI();
        }
    }

    function guardarOP(element){
        if($('#idEstimOP').val() != '' && $('#retencionV').val() != '' && $('#anticipo').val() != ''){
            var parametros = {
                "idEstimaciones" : $('#idEstimOP').val(),
                "retencionV" : $('#retencionV').val(),
                "anticipo" : $('#anticipo').val(),
                "formaPago" : $('#formaPago').val(),
                "nota" : $('#nota').val()
            };
            $(element).prop("disabled", true);
            $.ajax({
                data:  parametros,
                url:   'estimaciones_programa/guardarOP',
                type:  'post',
                dataType: "JSON",
                beforeSend: function () {
                    $(element).text('GUARDANDO...');
                    App.blockUI();
                    $('#respuesta').css({
                       'z-index' : 1000
                    });
                    $('#idEstimOP').prop('disabled', true);
                    $('#retencionV').prop('retencionV', true);
                    $('#idEstimOP').prop('disabled', true);
                    $('#formaPago').prop('disabled', true);
                    $('#nota').prop('disabled', true);
                    //$(':input[type="button"]').prop('disabled', true);
                },
                success:  function (response) {
                    $(element).text('GUARDAR');
                    $(element).prop( "disabled", false );
                    if(response['msg'] == ''){
                        setTimeout(function(){
                            location.reload(true);
                        }, 5000);
                    }
                    else{
                        validation(response['msg']);
                        App.unblockUI();
                        $('#idEstimOP').prop('disabled', false);
                        $('#retencionV').prop('retencionV', false);
                        $('#idEstimOP').prop('disabled', false);
                        $('#formaPago').prop('disabled', false);
                        $('#nota').prop('disabled', false);
                        //$(':input[type="button"]').prop('disabled', false);
                    }
    
                }
            });
        }
        else{
            if($('#idEstimOP').val() == ''){
                validation('Seleccione la semana');
            }
            if($('#retencionV').val() == ''){
                validation('Coloque una cantidad para Otros');
            }
            if($('#anticipo').val() == ''){
                validation('Coloque un anticipo');
            }
            //App.unblockUI();
        }
    }

    function verOrdenesPago(id){
        var monto=0;
        var retencion=0;
        var retencionV=0;
        var retencionA=0;
        var totalN=0;

        $('#ordenes').DataTable().destroy();
        // datatable
        $("#ordenes").dataTable({
            //"lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
            "lengthMenu": [[100, -1], [100, "Todo"]],
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Reporte de operaciones por dia"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "estimaciones_programa/listarOrdenes/"+id,
                "type": "POST",
                "data": { }
            },
            //Termina docs y languaje
            "fnDrawCallback": function() {
                //$("#monto_").text(monto);
                //$("#retenFG").text(retencion);
                //$("#retenOtro").text(retencionV);
                //$("#retenAnti").text(retencionA);
                //$("#totalNeto").text(totalN);
                //$(".moneda").formatCurrency();
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {//_devolucion
                if(aData["statusPago"]=="Pagado" || aData["statusPago"]=="Facturado"){
                    //Realizar operaciones
                    monto+=parseFloat(aData["_monto"]);
                    retencion+=parseFloat(aData["_retencion"]);
                    retencionV+=parseFloat(aData["_retencionV"]);
                    retencionA+=parseFloat(aData["_retencionA"]);
                    totalN+=parseFloat(aData["_totalN"]);
                    $(".moneda").formatCurrency();
                }
            },
            "fnInitComplete": function(oSettings, json) {
                //alert('totalN' + totalN);
                $("#monto_").text(monto);
                $("#retenFG").text(retencion);
                $("#retenOtro").text(retencionV);
                $("#retenAnti").text(retencionA);
                $("#totalNeto").text(totalN);
                $(".moneda").formatCurrency();

                monto = 0;
                retencion = 0;
                retencionV = 0;
                retencionA = 0;
                totalN = 0;
            },
            //"serverSide": true,
            "serverMethod": "post",
            // Initial no order.
            "order": [],
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "semana" },
                { "mData": "monto" },
                { "mData": "retencion" },
                { "mData": "retencionV" },
                { "mData": "retencionA" },
                { "mData": "totalN" },
                { "mData": "statusPago" },
                { "mData": "acciones" }
            ],
            "aaSorting": [],
            "columnDefs": [
                { "orderable": false, "className": "dt-right", "targets": 1 },
                { "orderable": false, "className": "dt-right", "targets": 2 },
                { "orderable": false, "className": "dt-right", "targets": 3 },
                { "orderable": false, "className": "dt-right", "targets": 4 },
                { "orderable": false, "className": "dt-right", "targets": 5 }
            ]
        });
        $("#modalVerOrdenesP").modal('show');
    }
    
    function cambiarPagado(id){
        var parametros = {
            "id" : id
        };

        $.ajax({
            data:  parametros,
            url:   'estimaciones_programa/actualizarPagado',
            type:  'post',
            beforeSend: function () {
                App.blockUI();
                $('#modalVerOrdenesP').css({
                       'z-index' : 1000
                });
            },
            success:  function (response) {
                location.reload(true);
                App.unblockUI();
            }
        });
    }

    function cancelarOrden(id){
        var html=   '<div class="modal fade modalCancelar" id="modal'+id+'" tabindex="-1" role="basic" aria-hidden="true">' +
                        '<div class="modal-dialog">' +
                            '<div class="modal-content">' +
                                '<div class="modal-header">' +
                                    '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                                    '<h4 class="modal-title">Alerta</h4>' +
                                '</div>' +
                                '<div class="modal-body"> ¿Desea cancelar esta orden? </div>' +
                                '<div class="modal-footer">' +
                                    '<button type="button" class="btn dark btn-outline" data-dismiss="modal">No</button>' +
                                    '<button type="button" id="btn_cancelar" class="btn green blockui-save">Si</button>' +
                                '</div>' +
                            '</div>' +
                        '</div>' +
                    '</div>';
        $('.modal-confirm').html(html);
        $('#modal'+id).modal("show");
        $("#modalVerOrdenesP").modal('hide');
        $('#btn_cancelar').click(function(event) { cambiarCancelado(id) });
    }

    function cambiarCancelado(id){
        var parametros = {
            "id" : id
        };
        $.ajax({
            data:  parametros,
            url:   'estimaciones_programa/actualizarCancelado',
            type:  'post',
            beforeSend: function () {
                App.blockUI();
                $('.modalCancelar').css({
                       'z-index' : 1000
                });
            },
            success:  function (response) {
                location.reload(true);
                App.unblockUI();
            }
        });
    }

    function generarEsti(estimacion){
        var cargar = $("#hacer_esti"+estimacion).val();
        if( !parseInt(cargar) ){
            $("#idEstimaciones").find('option[value="' + estimacion + '"]').prop('selected',true);
            $("#idEstimaciones").trigger('change');
            cargarEstimacion("#cargarEstimacion",false);
            $.ajax({
                data:  { "idEstimaciones": estimacion},
                url:   'estimaciones_programa/generarEstimacion',
                type:  'post',
                dataType: "JSON",
                beforeSend: function () {
                    App.blockUI();
                },
                success:  function (response) {
                    var activar = parseInt( $("#activar_esti"+estimacion).val() );
                    var readonly = ( activar )? 'readonly="readonly"' : 'readonly="readonly"';
                    if(response['categorias'].length > 0){
                        var html = '';
                        for (var i = 0; i < response['categorias'].length; i++) {
                            var actividad = response['categorias'][i]['actividades'];
                            html = html + '<div class="panel panel-default">' +
                            '<div class="panel-heading">' +
                                '<h4 class="panel-title">' +
                                    '<a class="accordion-toggle accordion-toggle-styled collapsed" data-toggle="collapse" data-parent="#accord' + estimacion + '" href="#esti_' + estimacion + '_cate_' + response['categorias'][i]['id'] + '"> ' + response['categorias'][i]['categoria'] + ' </a>' +
                                '</h4>' +
                            '</div>' +
                            '<div id="esti_' + estimacion + '_cate_' + response['categorias'][i]['id'] + '" class="panel-collapse collapse">' +
                                '<div class="panel-body">' +
                                    '<div class="col-md-12">' +
                                        '<div class="table-responsive">' +
                                            '<table class="table table-striped table-bordered table-hover">' +
                                                '<thead>' +
                                                    '<tr>' +
                                                        '<th scope="col"> Descripción </th>' +
                                                        '<th scope="col"> Pendiente por pagar</th>' +
                                                        '<th scope="col"> Acumulado </th>' +
                                                        '<th scope="col" width="75px"> Estim </th>' +
                                                        '<th scope="col"> Estimación ' + response['nEstimacion'] + ' </th>' +
                                                        '<th scope="col"> Acumulado </th>' +
                                                        '<th scope="col"> Acumulado Real</th>' +
                                                        '<th scope="col"> Pendiente por Ejecutar </th>' +
                                                    '</tr>' +
                                                '</thead>' +
                                                '<tbody>' +
                                                    '<tr style="color: #ffffff">' +
                                                        '<td style="background-color: #DCDCDC;"> ' + response['categorias'][i]['categoria'] + ' </td>' +
                                                        '<td id="pendiPagarC_' + response['categorias'][i]['id'] + 'esti_' + estimacion + '" style="background-color: #595959;"> ' + response['categorias'][i]['pendiPagar'] + ' </td>' +
                                                        '<td id="acuPagarC_' + response['categorias'][i]['id'] + 'esti_' + estimacion + '" style="background-color: #595959;"> ' + response['categorias'][i]['acuPagar'] + ' </td>' +
                                                        '<td style="background-color: #595959;"> </td>' +
                                                        '<td style="background-color: #262626;"> </td>' +
                                                        '<td style="background-color: #262626;"> </td>' +
                                                        '<td style="background-color: #262626;"> </td>' +
                                                        '<td style="background-color: #262626;"> </td>' +
                                                    '</tr>';
                            for (var a = 0; a < actividad.length; a++) {
                                var estimado = actividad[a]['estimados'];
                                var onBlr = (!activar) ? '' : 'onchange="actualizar('+"'" + estimado['id'] + "'" + ')" onclick="obtener_avance('+"'" + estimado['id'] + "'" + ')"';
                                var input = '<div id="div estimados_' + estimado['id'] + '" class="form-group form-md-line-input ">' +
                                    '<div class="col-md-12" style="margin-bottom:5px;">' +
                                        '<label class="control-label" for=estimados_' + estimado['id'] +'"> </label>' +
                                    '</div>' +
                                    '<div class="col-md-12">' +
                                        '<input id="estimados_' + estimado['id'] +'" name="estimados_' + estimado['id'] + '" value="' + estimado['lotes'] + '" type="text" class="form-control " placeholder="" ' + onBlr + ' ' + readonly + '>' +
                                        '<div class="form-control-focus"> </div>' +
                                        '<span class="help-block help-block-error"></span>' +
                                        '<span class="help-block"></span>' +
                                    '</div>' +
                                '</div>';
                                html = html +       '<tr>' +
                                                        '<td id="descripcion_'+estimado['id']+'"> ' + actividad[a]['descripcion'] + ' </td>' +
                                                        '<td id="pendiPagar_' + estimado['id'] + '"> ' + actividad[a]['pendiPagar'] + ' </td>' +
                                                        '<td id="acuPagar_' + estimado['id'] + '"> ' + actividad[a]['acuPagar'] + ' </td>' +
                                                        '<td class="estimados-' + estimado['id'] + '" data-input="' + estimado['id'] + '"> ' + input + ' </td>' +
                                                        '<td id="pagar_' + estimado['id'] + '"> ' + estimado['estimacion'] + ' </td>' +
                                                        '<td id="acuLotes_' + estimado['id'] + '"> ' + actividad[a]['acuLotes'] + ' </td>' +
                                                        '<td> ' + estimado['avanceLt'] + ' </td>' +
                                                        '<td id="pendiLotes_' + estimado['id'] + '"> ' + actividad[a]['pendiLotes'] + ' </td>' +
                                                    '</tr>';
                            }
                            html = html +       '</tbody>' +
                                            '</table>' +
                                        '</div>' +
                                    '</div>' +
                                '</div>' +
                            '</div>' +
                        '</div>';
                        }
                        $('#accord_' + estimacion).html(html);
                        $("#hacer_esti" + estimacion).val(1);
                    }
                    App.unblockUI();
                },
                error : function(jqXHR, textStatus, errorThrown) {
                    App.unblockUI();
                    if (jqXHR.status === 0) {
                        alert('Not connect: Verify Network.');
                    } else if (jqXHR.status == 404) {
                        alert('Requested page not found [404]');
                    } else if (jqXHR.status == 500) {
                        alert('Internal Server Error [500].');
                    } else if (textStatus === 'parsererror') {
                        alert('Requested JSON parse failed.');
                    } else if (textStatus === 'timeout') {
                        alert('Time out error.');
                    } else if (textStatus === 'abort') {
                        alert('Ajax request aborted.');
                    } else {
                        alert('Uncaught Error: ' + jqXHR.responseText);
                    }
                }
            });
        }
    }