let info = {
	tipo: 0,
	fracc: [],
	manzana: [],
	lote: [],
	categoria: [],
	actividad: [],
	estado: [],
	iniciado: [],
}
$(document).ready(function(){});
setTimeout(() => {
	$(".menu-toggler").trigger("click");	
}, 1500);


function setTipoLote(elem) {
	$("#div-tipo_lote button").removeClass('button-active').addClass('green');
	$("#div-fracc button").removeClass('button-active').addClass('green');
	info.tipo = $(elem).data("tipo");
	$("#div-info").css('display','none');
	$(".message-not-found").css('display','none');
	$("#div-manzana, #div-lote, #div-categoria").html(null);
	$(elem).removeClass('green').addClass('button-active');
}

function getManzana(elem, id_fracc) {
	$("#div-fracc button").removeClass('button-active').addClass('green');
	$(".message-not-found").css('display','none');
	$("#div-info").css('display','none');
	$("#div-manzana, #div-lote, #div-categoria").html(null);
	$("#div-manzana").fadeIn();
	$("#div-lote").fadeOut();
	info.fracc = $(elem).data();
	let manzana, html = '';
	$.ajax({ url:"estimacion/listado", method:"POST", data:{ action:'manzana', id_fracc:id_fracc, tipo_lote:info.tipo }, 
		statusCode: {
			404: function(responseObject, textStatus, jqXHR){
				$(".message-not-found").fadeIn();
			}
		} 
	}).done(function(data){
		manzana = JSON.parse(data)
		manzana.data.map(function(v){
			html += `<div class="btn-group">
					<button type="button" class="btn green" onclick="getLotes(this,${ id_fracc },'${ v.manzana }')">MZA ${ v.manzana }</button>
				</div>`;
		});
		$("#div-manzana").html(html);
	});
	$(elem).removeClass('green').addClass('button-active');
}

function getLotes(elem, id_fracc,manzana) {
	$("#div-manzana button").removeClass('button-active').addClass('green');
	$("#div-info").css('display','none');
	$("#div-lote, #div-categoria").html(null);
	$("#div-lote").fadeIn();
	info.manzana = manzana;
	let idCorte=$("#idCorte").val();
	let lote, html = '';
	$.ajax({ url:"estimacion/listado", method:"POST", data:{ action:'lote', id_fracc:id_fracc, manzana:manzana, tipo_lote:info.tipo,idCorte:idCorte } }).done(function(data){
		lote = JSON.parse(data)
		lote.data.map(function(v){
			html += `<button type="button" class="btn green" 
					data-fechaInicio="${ v.fechaInicio }"
					data-fechaFin="${ v.fechaFin }"
					data-prototipo="${ v.prototipo }"
					data-idProyecto="${ v.idProyecto }"
					data-idPaquete="${ v.idPaquete }"
					data-idEstimaciones="${ v.idEstimaciones }"
					data-lote="${ v.lote }"
					data-tipoEstimacion="${ v.tipoEstimacion }"
					data-tipoLote="${ v.tipoLote }"
					data-nom_constructor="${ v.nom_constructor }"
					data-nom_supervisor="${ v.nom_supervisor }"
					data-semActual="${ v.semActual }"
					data-semAnual="${ v.semAnual }"
					onclick="showAllData(this)"
					>
					LOTE ${ v.lote }
				</button>`;
		});
		$("#div-lote").html(html);
	});
	$(elem).removeClass('green').addClass('button-active');
}

function showAllData(elem) {
	$("#div-lote button").removeClass('button-active').addClass('green');
	info.lote = $(elem).data();
	$("#div-info").fadeIn();
	$("#name-lote").text(info.lote.lote);
	$("#name-manzana").text(info.manzana);
	$("#date-inicio").text(info.lote.fechainicio);
	$("#date-fin").text(info.lote.fechafin);
	$("#week-current").text(info.lote.semactual);
	$("#week-year").text(info.lote.semanual);
	$("#name-constructor").text(info.lote.nom_constructor);
	$("#name-prototipo").text(info.lote.prototipo);
	$(elem).removeClass('green').addClass('button-active');
	getActividades();
}

let l_actividades;
function getActividades() {
	var total=0;
	if (l_actividades !== undefined) {
		l_actividades.fnClearTable();
		l_actividades.fnDestroy();
		l_actividades = undefined;
	}
	l_actividades = $("#tbl-actividades").dataTable( {
		"bProcessing": true,
		"ajax": {
			"url": "estimacion/listado",
			"type": "POST",
			"data": { 
				"action": 'actividades',
				"idProyecto": info.lote.idproyecto,
				"idEstimacion": info.lote.idestimaciones,
				"manzana": info.manzana,
				"lote": info.lote.lote,
				"tipo_lote": info.lote.tipolote,
				"tipo_estimacion": info.lote.tipoestimacion,
			}
		},
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                //Realizar operaciones
                total+=aData["total"];
            },
            "initComplete": function () {
                //Resultado de operaciones
                $("#total").text(parseFloat(total,2));
                $(".moneda").formatCurrency();

                //reinicializacion
                total=0;
            },
		"sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
		"sPaginationType": "full_numbers",
		"aoColumns": [
			{ "mData": "clave" },
			{ "mData": "descripcion" },
			{ "mData": "categoria" },
			{ "mData": "abreviatura" },
			{ "mData": "cant_abrev" },
			{ "mData": "precioUnitario" },
			{ "mData": "importe" },
			{ "mData": "estado" },
			{ "mData": "cant_eje" },
			{ "mData": "cant_x_eje" },
			{ "mData": "iniciado" },
			{ "mData": "contratista" },
			{ "mData": "estatus" },
		],
		"aaSorting": []
	} );
}

function toNumber(number){
	//let res=parseFloat(number.substring(1, number.length - 1));
	let res=number.toString().slice(1, -1);
	res=res.replaceAll(/,/g,"");
	return parseFloat(res);
}

function clearForm() {
	$("#div-info span").text('');
}

function actionChecked(elem) {
	info.actividad = $(elem).data();
	console.log(info);
	let cantidad = ($("#act_estado_" + info.actividad.idavance).length > 0
		?$("#act_estado_" + info.actividad.idavance).val()
		:''
	);
	$.ajax({ url:"estimacion/checkComplementaria", method:"POST", data:{
		manzana: info.manzana,
		actividad: info.actividad,
		lote: info.lote,
		cantidad: cantidad
	}, statusCode: {
			200: function(responseObject, textStatus, jqXHR){
				success( JSON.parse(responseObject).message );
				$(elem).attr('checked',true);
			},
			400: function(responseObject, textStatus, jqXHR){
				validation( JSON.parse(responseObject.responseText).message );
				$(elem).attr('checked',false);
			},
			500: function(responseObject, textStatus, jqXHR){
				validation( JSON.parse(responseObject.responseText).message );
				$(elem).attr('checked',false);
			}
		} 
	}).done(function(response){
		response=JSON.parse(response);
		$("#cant_eje_"+info.actividad.idavance).html(response.updateData.cant_eje);
		$("#cant_x_eje_"+info.actividad.idavance).html(response.updateData.cant_x_eje);
	});
}

function actionCheck(elem){
	let checked = $(elem).prop('checked');
	let data=info.estado = $(elem).data();
	let importe=data.cantidad*data.preciounitario;
	let totalAnterior=parseFloat($("#total").html(),2);
	let totalActual=0;
	if(checked){
		totalActual=totalAnterior+importe;
	}else{
		totalActual=totalAnterior-importe;
	}
	$("#total").text(parseFloat(totalActual,2));
	actionEstado(elem,{
		id:data.idavance,
		lotes:data.lotes,
		tabla:"avanceobra",
		column:"lotes",
	});
	actionEstado(elem,{
		id:data.idpptopaq,
		lotes:data.lotesp,
		tabla:"paquete_presupuesto",
		column:"lotes",
	},true);
}

function actionInit(elem){
	let data=info.estado = $(elem).data();
	actionEstado(elem,{
		id:data.idavance,
		lotes:data.iniciado,
		tabla:"avanceobra",
		column:"iniciado",
	});
	actionEstado(elem,{
		id:data.idpptopaq,
		lotes:data.lotesi,
		tabla:"paquete_presupuesto",
		column:"lotesI",
	});
}

function actionEstado(elem,vars,show=false) {
	let checked = $(elem).prop('checked');
	$.ajax({ url:"estimacion/checkLote", method:"POST", data:{ 
		estado: checked,
		lote: info.lote.lote,
		manzana: info.manzana,
		//variables
		id: vars.id,
		lotes: vars.lotes,
		tabla: vars.tabla,
		column: vars.column,
	}, statusCode: {
			200: function(responseObject, textStatus, jqXHR){
				success( JSON.parse(responseObject).message );
				// $(elem).attr('checked',true);
			},
			400: function(responseObject, textStatus, jqXHR){
				validation( JSON.parse(responseObject.responseText).message );
				$(elem).attr('checked',!checked);
			},
			500: function(responseObject, textStatus, jqXHR){
				validation( JSON.parse(responseObject.responseText).message );
				$(elem).attr('checked',!checked);
			}
		} 
	}).done(function(response){
		response=JSON.parse(response);validation
		if(show){
			console.log(info.estado);
			if(checked){
				$("#cant_eje_"+info.estado.idavance).html(info.estado.cantidad);
				$("#cant_x_eje_"+info.estado.idavance).html(0);
			}else{
				$("#cant_eje_"+info.estado.idavance).html(0);
				$("#cant_x_eje_"+info.estado.idavance).html(info.estado.cantidad);
			}
		}
	});
}

function setContratista(elem) {
	const idcontratista = $(elem).val();
	const idavance = $(elem).data('idavance');
	$.ajax({ url:"estimacion/setContratista", method:"POST", data:{ 
		manzana: info.manzana,
		lote: info.lote,
		idcontratista: idcontratista,
		idavance: idavance,
	}, statusCode: {
			200: function(responseObject, textStatus, jqXHR){
				success( JSON.parse(responseObject).message );
				$(elem).attr('checked',true);
			},
			400: function(responseObject, textStatus, jqXHR){
				validation( JSON.parse(responseObject.responseText).message );
				$(elem).attr('checked',false);
			},
			500: function(responseObject, textStatus, jqXHR){
				validation( JSON.parse(responseObject.responseText).message );
				$(elem).attr('checked',false);
			}
		} 
	}).done(function(response){
		console.log(response);
	});
}

