function limpiar(){
    //datos clientes
    $('#fechaContrato').html('');
    $('#cliente').html('');
    $('#status').html('');
    //datos monetarios
    $('#saldoTexto').html('');
    $('#monto').html('');
    $('#tipo').val('');
    //datos de cancelacion
    $('#porcentaje').html('');
    $('#pendiente').html('');
    $('#penalizacionTexto').html('');
    //inputs generales
    $('#cuenta').val('');
    $('#saldo').val('');
    $('#descripcion').val('');
    $('#movimiento').val('');
    $('#minimo').val('');
    //inputs deposito
    $('#importe').val('');
    $('#formaPago').val('').change();
    $('#comprobante').val(null);
    $('#divStatusDetalle').show('slow');
    $('#divComprobante').show('slow');
    $('#divImporte').show('slow');
    $('#divFormaPago').show('slow');
    $('#divFechaPago').show('slow');
    //inputs cancelado
    $('#devolucion').val('');
    $('#penalizacion').val('');
    $('#divDevolucion').hide('slow');
    $('#divPenalizacion').hide('slow');
    $('#divCancelar').hide('slow');
}

function modalPago(id, tipo){
    limpiar();
    $('#idContado').val(id);
    $.ajax({
        url: 'contado/getDatosModal',
        type: 'POST',
        dataType: 'JSON',
        data: {
            idContado: id,
            tipo : tipo
        },
        beforeSend: function () {
            App.blockUI();
        },
        success:function(data){
            App.unblockUI();
            if(data.status==1){
                //datos cuenta
                $('#fechaContrato').html(data.fechaContrato);
                $('#cliente').html(data.cliente);
                $('#status').html(data.statusContrato);
                $('#statusCuenta').val(data.statusCuenta);
                $("#exampleModalLabel").html(  (tipo == 1)? ' PAGO DE DEPÓSITO ' : ' PAGO DE RETIRO ' );
                //datos monetarios
                $('#pagado').html(data.pagado);
                $("#pagado").formatCurrency();
                $('#saldoTexto').html(data.saldo);
                $("#saldoTexto").formatCurrency();
                $('#monto').html(data.monto);
                $('#montoT').val(data.monto);
                $("#monto").formatCurrency();
                //inputs generales
                $('#cuenta').val(data.cuenta);
                $('#saldo').val(data.pagado);
                $('#minimo').val(data.saldoDetalle);
                $('#tipo').val(tipo);
                switch( parseInt(tipo)){
                    case 2:
                        $("#exampleModalLabel").html( ' PAGO DE RETIRO ' );
                        $('#saldoDetalle').val(data.saldoDetalle);
                        $("#importe").removeClass( "sumar" ).addClass( "restar" );
                        $("#saldoDetalle").formatCurrency();
                        break;
                    case 3: 
                        //datos cancelar
                        $("#exampleModalLabel").html( ' CANCELACIÓN DE CONTADO ' );
                        $('#status').html("POR CANCELAR");
                        $('#porcentaje').html(data.porcentaje + '%');
                        $('#pendiente').html(data.porPendiente + '%');
                        $('#penalizacionTexto').html(data.penalizacionT);
                        $("#penalizacionTexto").formatCurrency();
                        $('#saldoPos').html( data.saldoTexto );
                        //inputs cancelar
                        $('#saldoDetalle').val(data.saldoTexto);
                        $('#minimo').val(data.penalizacionT);
                        $('#fechaPago').val(data.fechaPago);
                        $('#devolucion').val(data.devolucion);
                        $('#penalizacion').val(data.penalizacion);
                        $("#devolucion").formatCurrency();
                        $("#penalizacion").formatCurrency();
                        $('#divComprobante').hide('slow');
                        $('#divCancelar').show('slow');
                        $('#divImporte').hide('slow');
                        $('#divFormaPago').hide('slow');
                        $('#divFechaPago').hide('slow');
                        $('#divDevolucion').show('slow');
                        $('#divPenalizacion').show('slow');
                        $('#divStatusDetalle').hide('slow');
                        break;
                    default:
                        //datos monetarios
                        $('#statusDetalle').html( (data.statusDetalle == 1)? 'En tiempo' : 'Vencido' );
                        $("#exampleModalLabel").html( ' PAGO DE DEPÓSITO ' );
                        //inputs deposito
                        $('#saldoPos').html( parseFloat(data.monto) - (parseFloat(data.pagado) + data.importe) );
                        $("#saldoPos").formatCurrency();
                        $('#saldoDetalle').val( parseFloat(data.pagado) + data.importe);
                        $('#importe').val(data.importe);
                        $("#importe").formatCurrency();
                        $("#importe").removeClass( "restar" ).addClass( "sumar" );
                        $("#saldoDetalle").formatCurrency();
                        if( data.statusCuenta > 2){
                            $('#saldoPos').html("$" + (parseFloat(data.saldo) + data.importe).toFixed(2) );
                            $('#saldoDetalle').val( parseFloat(data.saldo) + data.importe);
                            $('#saldoTexto').html("$" + data.saldo);
                            $('#saldo').val(data.saldo);
                        }
                        break;
                }
                $('#pagarCuenta').modal('show');
            }
            else{
                validation(data.msg);
            }
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            erroresAjax(jqXHR, textStatus);
        }
    });
}

function calculate() {
    var sum = 0;
    var sum2 = 0;
    //iterate through each textboxes and add the values
    $(".sumar").each(function() {
        //add only if the value is number
        if (!isNaN(this.value.replace(/[^\d.-]/g, '')) && this.value.replace(/[^\d.-]/g, '').length != 0) {
            $(this).css("background-color", "transparent");
            sum += parseFloat(this.value.replace(/[^\d.-]/g, ''));
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.replace(/[^\d.-]/g, '').length != 0 || this.value.replace(/[^\d.-]/g, '')=='' ){
            $(this).css("background-color", "red");
        }
    });

    $(".restar").each(function() {
        if (!isNaN(this.value.replace(/[^\d.-]/g, '')) && this.value.replace(/[^\d.-]/g, '').length != 0) {
            $(this).css("background-color", "transparent");
            sum2 += parseFloat(this.value.replace(/[^\d.-]/g, ''));
        }
        else if (this.value.replace(/[^\d.-]/g, '').length != 0 ){
            $(this).css("background-color", "red");
        }
    });
    var total = parseFloat( $("#saldo").val() ) + (sum - sum2);

    if (total > 0){
        if( $('#statusCuenta').val() == 3 || $('#statusCuenta').val() == '3' ){
            $("#saldoPos").html( total );
            $("#saldoPos").formatCurrency();
        }else{
            $("#saldoPos").html( parseFloat($("#montoT").val()) - total);
            $("#saldoPos").formatCurrency();
        }
        $("#saldoDetalle").val(total);
        $("#saldoDetalle").formatCurrency();
    }else{
        $("#saldoDetalle").val( "$" + parseFloat(total).toFixed(2));
        $("#saldoPos").html( "$" + parseFloat(total).toFixed(2) );
    }
}

function guardar(){
    switch( $('#tipo').val() ){
        case '1':
            var data = new FormData();
            data.append('id', $('#idContado').val());
            data.append('cuenta', $('#cuenta').val());
            data.append('formaPago', $('#formaPago').val());
            data.append('fechaPago', $('#fechaPago').val());
            data.append('saldoDetalle', $('#saldoDetalle').val());
            data.append('movimiento', $('#movimiento').val());
            data.append('descripcion', $('#descripcion').val());
            data.append('minimo', $('#minimo').val());
            data.append('importe', $('#importe').val());
        
            jQuery.each($('#comprobante')[0].files, function(i, file) {
                data.append('foto', file);
            });
            
            $.ajax({
                url: 'contado/guardarDeposito',
                cache: false,
                contentType: false,
                processData: false,
                type: 'POST',
                dataType: 'JSON',
                data: data,
                beforeSend: function () {
                    App.blockUI();
                },
                success:function(data){
                    if(data.status==1){
                        $('#pagarCuenta').modal('hide');
                        success(data.msg);
                        location.reload();
                    }
                    else{
                        App.unblockUI();
                        validation(data.msg);
                    }
                },
                error : function(jqXHR, textStatus, errorThrown) {
                    App.unblockUI();
                    erroresAjax(jqXHR, textStatus);
                }
            });
            break;
        case '2':
            break;
        case '3':
            $.ajax({
                url: 'contado/guardarCancelacion',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    id: $('#idContado').val(),
                    cuenta: $('#cuenta').val(),
                    saldoDetalle: $('#saldoDetalle').val(),
                    movimiento: $('#movimiento').val(),
                    descripcion: $('#descripcion').val(),
                    minimo: $('#minimo').val(),
                    devolucion: $('#devolucion').val(),
                    penalizacion: $('#penalizacion').val()
                },
                beforeSend: function () {
                    App.blockUI();
                },
                success:function(data){
                    if(data.status==1){
                        $('#pagarCuenta').modal('hide');
                        success(data.msg);
                        location.reload();
                    }
                    else{
                        App.unblockUI();
                        validation(data.msg);
                    }
                },
                error : function(jqXHR, textStatus, errorThrown) {
                    App.unblockUI();
                    erroresAjax(jqXHR, textStatus);
                }
            });
            break;
        default:
            validation('NO SE ENCONTRÓ EL TIPO DE ACCIÓN');
            break;

    }
}

function erroresAjax(jqXHR, textStatus){
    if (jqXHR.status === 0) {
        alert('Not connect: Verify Network.');
    } else if (jqXHR.status == 404) {
        alert('Requested page not found [404]');
    } else if (jqXHR.status == 500) {
        alert('Internal Server Error [500].');
    } else if (textStatus === 'parsererror') {
        alert('Requested JSON parse failed.');
    } else if (textStatus === 'timeout') {
        alert('Time out error.');
    } else if (textStatus === 'abort') {
        alert('Ajax request aborted.');
    } else {
        alert('Uncaught Error: ' + jqXHR.responseText);
    }
}