$(document).ready(function() {
    // datatable
    // $('[data-ride="datatables"]').each(function() {
    //     var oTable = $(this).dataTable( {
    //         "bProcessing": true,
    //         "sAjaxSource": "comisiones_bonos/listado",
    //         "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
    //         "sPaginationType": "full_numbers",
    //         "aoColumns": [
    //             { "mData": "fraccionamiento" },
    //             { "mData": "lote" },
    //             { "mData": "manzana" },
    //             { "mData": "promotor" },
    //             { "mData": "cierre" },
    //             { "mData": "comision" },
    //             { "mData": "importeComision" },
    //             { "mData": "statusVivienda" },
    //             { "mData": "acciones" }
    //         ],
    //         "aaSorting": []
    //     } );
    // });

    var idProyectSelected = '';
    idProyectSelected = $('#idProyectSelect').val();
    if(($("#idProyectSelect").length > 0) && (idProyectSelected!='')){
        setTimeout(function(){
          $('#idProyecto').val(idProyectSelected).trigger("change");
        }, 1000);
        
    }

    $('#sample_3').DataTable().destroy();

    // datatable
    $("#sample_3").each(function() {
        var oTable = $(this).dataTable( {
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Comisiones - bonos"),
            //Termina docs y languaje
            "bProcessing": true,
            "sAjaxSource": "comisiones_bonos/listado",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "estatus" },
                { "mData": "statusVivienda" },                
                { "mData": "fraccionamiento" }, 
                { "mData": "lote" },
                { "mData": "manzana" },
                { "mData": "lineaCredito" },
                { "mData": "ronda" },
                { "mData": "cliente" },
                { "mData": "nss" },
                { "mData": "promotor" },
                { "mData": "avaluo" },
                { "mData": "ahorroVol" },
                { "mData": "precioVentaOci" },
                { "mData": "precioVenta" },
                { "mData": "sumaFinal" },
                { "mData": "difPropioPeculio" },
                { "mData": "numeroCredito" },
                { "mData": "resultado" },
                { "mData": "bonoEquipamiento" },
                { "mData": "saldo" },
                { "mData": "cierre" },
                { "mData": "tipoPromotor" },
                { "mData": "comision" },
                { "mData": "importeComision" },
                { "mData": "diferenciaCliente" },
                { "mData": "diferenciaEmpresa" },
                //{ "mData": "diferenciaAsesor" },
                { "mData": "diferenciaVendedor" },
                { "mData": "primerPagoPromotor" },
                { "mData": "totPago1" },

                { "mData": "fechaPrimerPagoPromotor" },
                { "mData": "tPago1" },
                { "mData": "diferenciaVendedor2" },
                { "mData": "segundoPagoPromotor" },
                { "mData": "productividad" },
                { "mData": "totPago2" },
                { "mData": "fechaSegundoPagoPromotor" },
                { "mData": "tPago2" },

                { "mData": "netoVenta" },
                { "mData": "comentarios" },
                
                { "mData": "primerPagoCoordinador" },
                { "mData": "fechaPrimerPagoCoordinador" },
                { "mData": "segundoPagoCoordinador" },
                { "mData": "fechaSegundoPagoCoordinador" },
                { "mData": "bonificacion" },
                { "mData": "fechaBonificacion" },
                { "mData": "totDepositos" }                
            ],
            "aaSorting": []
        } );
    });

/*    var oTable2 = $('#listado2').dataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Comisiones - bonos"),
            "bProcessing": true,
            "sAjaxSource": "comisiones_bonos/listado2",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "statusVivienda" },
                { "mData": "fraccionamiento" },
                { "mData": "lote" },
                { "mData": "manzana" },
                { "mData": "lineaCredito" },
                { "mData": "cliente" },
                { "mData": "nss" },
                { "mData": "promotor" },
                { "mData": "avaluo" },
                { "mData": "precioVentaOci" },
                { "mData": "precioVenta" },
                { "mData": "sumaFinal" },
                { "mData": "difPropioPeculio" },
                { "mData": "numeroCredito" },
                { "mData": "resultado" },
                { "mData": "bonoEquipamiento" },
            ],
            "aaSorting": []
    });*/

    var oTable2 = $('#listado2').dataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Comisiones - bonos",true,'listado2'),
            "bProcessing": true,
            "sAjaxSource": "comisiones_bonos/listado2",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "statusPago" },
                { "mData": "tCred" },
                { "mData": "promotor" },
                { "mData": "cliente" },
                { "mData": "curp" },
                { "mData": "rfc" },
                { "mData": "fraccionamiento" },
                { "mData": "manzana" },
                { "mData": "lote" },
                { "mData": "tCred2" },
                { "mData": "pVenta" },
                { "mData": "totComision" },

                { "mData": "otrosDesc" },
                { "mData": "retencionComision" },
                { "mData": "comisionAl100" },

                { "mData": "primerComision" },
                { "mData": "fecha1Pago" },
                { "mData": "segundaComision" },
                //{ "mData": "saldo" },
                { "mData": "bonificacion" },
                //{ "mData": "saldoConsiderar" },
                //{ "mData": "bonoEquipamiento" },
                //{ "mData": "retencion" },
                //{ "mData": "totalPagar" },
                { "mData": "fecha2Pago" }
            ],
            "aaSorting": []
    });

    $('#listado3').dataTable();

    $('a.toggle-vis').on( 'click', function (e) {
        var oTable = $('#listado2').dataTable();
        var iCol = $(this).attr('data-column');
        var bVis = oTable.fnSettings().aoColumns[iCol].bVisible;
        oTable.fnSetColumnVis( iCol, bVis ? false : true );
    });

    var title="pagos-pendientes-"
    var dt = new Date();
    var month = dt.getMonth()+1;
    var day = dt.getDate();
    var year = dt.getFullYear();
    title+="("+day + '-' + month + '-' + year+")";
    setTimeout(function(){
        var buttons = new $.fn.dataTable.Buttons(oTable2, {
             buttons: [
               {
                    extend: 'excelHtml5',
                    title: title,
                    text:'Exportar',
                    exportOptions: {
                        //columns: ':visible'
                        columns:':visible:not(.notExport)' 
                    }
                },
            ]
        }).container().appendTo($('#buttons'));
    }, 2000);

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    $('#imprimirFormatos').click(function(event) {
        /* Act on the event */
        $('#modal-formatos').modal()
    });

    $('#idProyecto').change(function() {
        //alert($(this).val());
        var idProyecto = $(this).val();
        $.ajax({
        url: 'comisiones_bonos/getInfoVenta', // obtenemos toda la informacion de costos de está vivienda(lote) al ya estar validado por gestoría
        type: 'POST',
        dataType: 'json',
        data: {
            idProyecto: idProyecto
        },beforeSend: function() {
            App.blockUI();
            $('.loading-message img').attr('src','assets/global/img/loading-spinner-grey.gif');
        },success: function(data){
            App.unblockUI();
            if (data.success == true){
                $('#idAltaVenta').val(data.id);//agregamos el id de alta de venta
                $('#valorAvaluo').val(data.avaluo);
                $('#precioVentaOci').val(data.precioVentaOci);
                $('#precioVentaEmpresa').val(data.precioVenta);
                $('#montoFinal').val(data.montoFinal);
                $('#difPropioPeculio').val(data.difPropioPeculio);
                $('#numeroCredito').val(data.numeroCredito);
                $('#resultado').val(data.resultado);
                $('#bonoPresupuestoInicial').val(data.bonoPresupuestoInicial);
                $('#saldo').val(data.saldo);
                $('#cierre').val(data.cierre);
                $('#fecha').val(data.fecha);
                $('#nombrePromotor').val(data.nombrePromotor);
                $('#comision').val(data.comision);
                $('#importeComision').val(data.importeComision);
                $('#tipoPromotor').val(data.tipoPromotor);
                $('#netoVenta').val(data.netoVenta);
                $('#diferenciaVendedor').val(data.diferenciaAsesor);
                /*campos del cliente*/
                $('#nombre').val(data.nombre);
                $('#apellidoP').val(data.apellidoP);
                $('#fraccionamiento').val(data.fraccionamiento);
                $('#lote').val(data.lote);
                $('#manzana').val(data.manzana);
                //$('#fechaNac').val(data.fechaNac);
                //(data.promotor!=false)?$('#promotor').val(data.promotor):'';
                //$("select#statusProspecto").val(data.statusProspecto).trigger('change');
                $(".removeDisabled").removeAttr('disabled');
            }else{
                clear();
                $(".removeDisabled").attr('disabled','disabled');
            }
        }
    });

    });

    $(".calculaPeculio").on("keydown keyup", function() {
        calcularPeculio();
    });

    $(".calculaResultado").on("keydown keyup", function() {
        calcularResultado();
    });

    $(".calculaComision").on("keydown keyup", function() {
        //alert();
        var precioVenta = Number($('#precioVentaEmpresa').val().replace(/[^0-9\.]+/g,""));
        var cierre = Number($('#cierre').val().replace(/[^0-9\.]+/g,"")); // $('#precioVentaEmpresa') deshacemos el formato de moneda y convertimos a numérico
        var comision = $('#comision').val();
        var importeComision = precioVenta*comision/100;
        var netoVenta = cierre - importeComision;//calculamos elneto de venta restando el importe de comisión al cierre
        if ( !isNaN(importeComision) && !isNaN(cierre) ) {

            if (netoVenta>0){
                $('#netoVenta').val(netoVenta);
                $("#netoVenta").formatCurrency();
            }else{
                $("#netoVenta").val(parseFloat(importeComision).toFixed(2));
            }

            if (importeComision > 0){
                $("#importeComision").val(importeComision);
                $("#importeComision").formatCurrency();
            }else{
                $("#importeComision").val(parseFloat(importeComision).toFixed(2));
            }

        }else{
            validation('Ingrese un valor numérico');
        }
    });

    $(".sumar").on("keydown keyup", function() {
        calculateSum();
    });

    $(".restar").on("keydown keyup", function() {
        calculateSum();
    });


    $('#pctjeComisionTotal').change(function(){  
        var id = $('#idAltaVenta1P').val();      
        var pctjeComision = ($(this).val())/100;
        $.ajax({
            url: 'comisiones_bonos/getDatosModal1',
            type: 'POST',
            dataType: 'JSON',
            data: {
                idAltaVenta: id,
                pctjeComision: pctjeComision
            },success:function(data){
                if(data.success==1){
                    $('#nomPrototipoP1').html(data.prototipo);
                    $('#pVentaP1SinFormato').val(data.pVenta);
                    $('#pVentaP1').html(data.pVenta);
                    $("#pVentaP1").formatCurrency();
                    $('#comisionP1').html(data.comision1);
                    $("#comisionP1").formatCurrency();

                    $('#diferenciaP1').html(data.diferenciaPendiente);
                    $("#diferenciaP1").formatCurrency();
                    $('#totPagoC1').html(data.totPagoC1);
                    $("#totPagoC1").formatCurrency();

                }
            }
        });
    });

    $('#pctjeComisionTotal2').change(function(){  
        var id = $('#idAltaVenta').val();      
        var pctjeComision = ($(this).val())/100;

        $.ajax({
            url: 'comisiones_bonos/getComision1',
            type: 'POST',
            dataType: 'JSON',
            data: {
                idAltaVenta: id,
                pctjeComision: pctjeComision,
                statusComision:1
            },success:function(data){
                if(data.success==1){

                    $('#nomPrototipo').html(data.prototipo);
                    $('#pVenta').html(data.pVenta);
                    $("#pVenta").formatCurrency();
                    $('#mesVenta').html(data.mesVenta);
                    $('#numViviendas').html(data.cantidadVentas);
                    $('#pcjeComision').html(data.pctje);
                    $('#comision1').html(data.comision1);
                    $("#comision1").formatCurrency();
                    $('#productividad').val(data.productividad);
                    $('#productividad').formatCurrency();
                    $('#segundoPagoPromotor').val(data.comision2);
                    $("#segundoPagoPromotor").formatCurrency();

                    $('#diferenciaP2').html(data.diferenciaPendiente);
                    $("#diferenciaP2").formatCurrency();
                    $('#totPagoC2').html(data.totPagoC2);
                    $("#totPagoC2").formatCurrency();

                }
            }
        });

    });


});


function clear(){
    $("#nombre, #apellidoP, #apellidoM, #rfc, #telefono, #fechaNac, #valorAvaluo, #precioVentaOci, #precioVentaEmpresa, #montoFinal, #difPropioPeculio, #numeroCredito, #fecha, #nombrePromotor, #comision, #tipoPromotor").val("");
    //$("#content_descripcion_cpagar").find('.help-block-error').text("");
}

function calcularPeculio(){
    var sum = 0;
    var sum2 = 0;
    //iterate through each textboxes and add the values
    $(".sumaPeculio").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }
    });
    $(".restaPeculio").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum2 += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }

    });
    var total = sum - sum2;
    if (total > 0){
        $("#difPropioPeculio").val(total);
        $("#difPropioPeculio").formatCurrency();
    }else{
        $("#difPropioPeculio").val(parseFloat(total).toFixed(2));
    }
}

function calcularResultado(){
    var sum = 0;
    var sum2 = 0;
    //iterate through each textboxes and add the values
    $(".sumaParaResultado").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }
    });
    $(".restaParaResultado").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum2 += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }

    });
    var total = sum - sum2;
    if (total > 0){
        $("#resultado").val(total);
        $("#resultado").formatCurrency();
    }else{
        $("#resultado").val(parseFloat(total).toFixed(2));
    }
}

function calculateSum() {
    var sum = 0;
    var sum2 = 0;
    //iterate through each textboxes and add the values
    $(".sumar").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }
    });

    $(".restar").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum2 += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }

    });

    var total = sum - sum2;

    if (total > 0){
        $("#total").val(total);
        $("#total").formatCurrency();
    }else{
        $("#total").val(parseFloat(total).toFixed(2));
    }
}

function modalPrimerPago(id){
    $('#primerPago').modal('show')
    $('#idAltaVenta1P').val(id);
    $('#pctjeComisionTotal').val('2').trigger('change');
    $.ajax({
        url: 'comisiones_bonos/getDatosModal1',
        type: 'POST',
        dataType: 'JSON',
        data: {
            idAltaVenta: id,
            pctjeComision: 0.02
        },success:function(data){
            if(data.success==1){
                $('#nomPrototipoP1').html(data.prototipo);
                $('#pVentaP1SinFormato').val(data.pVenta);
                $('#pVentaP1').html(data.pVenta);
                $("#pVentaP1").formatCurrency();
                $('#comisionP1').html(data.comision1);
                $("#comisionP1").formatCurrency();

                $('#diferenciaP1').html(data.diferenciaPendiente);
                $("#diferenciaP1").formatCurrency();
                $('#totPagoC1').html(data.totPagoC1);
                $("#totPagoC1").formatCurrency();

            }
        }
    });

}

function primerPProcess(){
    var id = $("#idAltaVenta1P").val();
    var pctjeComision = $('#pctjeComisionTotal').val();
    if (id>0){

    }else{
        id = 0;
    }
    $('#primerPProcess').hide('slow');
    $('#primerPProcessLabel').show('slow');
    var tPago1 = $('#tPago1').val();
    $.post('comisiones_bonos/guardaPrimerPago', {idAltaVenta: id,tPago1:tPago1,pctjeComision:pctjeComision}, function(data) {
        console.log("Data reponse: " + data);
        $("#primerPago").modal('hide');
        if ( $.parseJSON(data).success ) {
            success('El registro ha sido validado');
            location.href ="comisiones_bonos";
        }
        else {
            validation($.parseJSON(data).msg);
        }
    });
    $('#primerPProcess').show('slow');
    $('#primerPProcessLabel').hide('slow');
}

function modalSegundoPago(id){
    $('#segundoPago').modal('show')
    $('#idAltaVenta').val(id);
    $.ajax({
        url: 'comisiones_bonos/getComision1',
        type: 'POST',
        dataType: 'JSON',
        data: {
            idAltaVenta: id,
            statusComision:0
        },success:function(data){
            if(data.success==1){
                //Validamos si existe % de productividad
                if (data.productividad>0){
                    $('#siProductividad').show();
                    $('#noProductividad').hide();
                }else if(data.comision1==0.00){
                    $('#pctjeComisionTotal2').val('2').trigger('change');
                    $('#noProductividad').show();
                    $('#siProductividad').hide();
                }
                $('#nomPrototipo').html(data.prototipo);
                $('#pVenta').html(data.pVenta);
                $("#pVenta").formatCurrency();
                $('#mesVenta').html(data.mesVenta);
                $('#numViviendas').html(data.cantidadVentas);
                $('#pcjeComision').html(data.pctje);
                $('#comision1').html(data.comision1);
                $("#comision1").formatCurrency();
                $('#productividad').val(data.productividad);
                $('#productividad').formatCurrency();
                $('#segundoPagoPromotor').val(data.comision2);
                $("#segundoPagoPromotor").formatCurrency();

                $('#diferenciaP2').html(data.diferenciaPendiente);
                $("#diferenciaP2").formatCurrency();
                $('#totPagoC2').html(data.totPagoC2);
                $("#totPagoC2").formatCurrency();

            }
        }
    });
}

function segundoPProcess( id ) {
    console.log("Id av: " + id);
    console.log("Motivo cancelación: " + $("#motivoCancelacion").val());
    if(id==0){
        var id = $("#idAltaVenta").val();
        if (id>0){

        }else{
            id = 0;
        }
    }
    $('#segundoPProcess').hide('slow');
    $('#segundoPProcessLabel').show('slow');
    var productividad = $('#productividad').val();
    var pctjeComision = $('#pcjeComision').text();
    var tPago2 = $('#tPago2').val();
    var pctjeComisionTotal2 = $('#pctjeComisionTotal2').val(); // cuando no existe productividad y hay que ahistar el % de comisión final
    $.post('comisiones_bonos/guardarSeegundoPago', {idAltaVenta: id,productividad:productividad,pctjeComision:pctjeComision,tPago2:tPago2,pctjeComisionTotal2:pctjeComisionTotal2}, function(data) {
        console.log("Data reponse: " + data);
        $("#segundoPago").modal('hide');
        if ( $.parseJSON(data).success ) {
            success('El registro ha sido validado');
            location.href ="comisiones_bonos";
        }
        else {
            validation($.parseJSON(data).msg);
        }
    });
    $('#segundoPProcess').show('slow');
    $('#segundoPProcessLabel').hide('slow');
}
