$(document).ready(function() {
    var estatus_vivienda=($("#estatus_vivienda").val() != null) ? $("#estatus_vivienda").val().toString().replace(/ /g,"-") : 0;
    estatus_vivienda=(estatus_vivienda != null) ? estatus_vivienda.toString().replace(/,/g,".") : 0;
    var promotor=$("#promotor").val();
    var fecha_inicio=$("#fecha_inicio").val();
    var fecha_fin=$("#fecha_fin").val();
    var fraccionamiento=$("#fraccionamiento").val();
    var area=$("#area").val();
    table();
    $("#aplicar").click(function(event) {
        estatus_vivienda=($("#estatus_vivienda").val() != null) ? $("#estatus_vivienda").val().toString().replace(/ /g,"-") : 0;
        estatus_vivienda=(estatus_vivienda != null) ? estatus_vivienda.toString().replace(/,/g,".") : 0;
        promotor=$("#promotor").val();
        fecha_inicio=$("#fecha_inicio").val().split('/');
        fecha_fin=$("#fecha_fin").val().split('/');
        fecha_inicio=(fecha_inicio != "") ? fecha_inicio[2] +"-"+fecha_inicio[1] +"-"+fecha_inicio[0] : "";
        fecha_fin=(fecha_fin != "") ? fecha_fin[2] +"-"+fecha_fin[1] +"-"+fecha_fin[0] : "";
        fraccionamiento=$("#fraccionamiento").val();
        area=$("#area").val();
        table();
    });
    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    $("#export_csv").click(function(event) {
        /* Act on the event */
        window.location.href="colocacion/export_csv/"+estatus_vivienda+"_"+promotor+"_"+fecha_inicio+"_"+fecha_fin+"_"+fraccionamiento+"_"+area;
    });

    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');

    //Agregar items a select
    $('#estatus_vivienda').empty();
    $('#estatus_vivienda').trigger('change');
    setTimeout(function(){
        $("#area").trigger('change');
    },600);
    $("#area").change(function(event) {
        if($(this).val()==1){
            //GESTORIA(validacion venta)
            $('#estatus_vivienda').empty();
            addOption("#estatus_vivienda","correccion de rfc","CORRECCIÓN DE RFC");
            addOption("#estatus_vivienda","solicitud de avaluo","SOLICITUD DE AVALUO");
            addOption("#estatus_vivienda","correccion de avaluo","CORRECCIÓN DE AVALUO");
            addOption("#estatus_vivienda","complemento de expediente","COMPLEMENTO DE EXPEDIENTE");
            addOption("#estatus_vivienda","revision de condiciones","REVISIÓN DE CONDICIONES");
            addOption("#estatus_vivienda","espera de ubicacion","ESPERA DE UBICACIÓN");
            addOption("#estatus_vivienda","autorizado","AUTORIZADO");
            $('#estatus_vivienda').trigger('change');
        }else if($(this).val()==2){
            //TITULACION(gestoria)
            $('#estatus_vivienda').empty();
            addOption("#estatus_vivienda","espera de inscripcion","ESPERA DE INSCRIPCIÓN");
            addOption("#estatus_vivienda","inscrito", "INSCRITO");
            addOption("#estatus_vivienda","ahorro voluntario","AHORRO VOLUNTARIO");
            addOption("#estatus_vivienda","revision de condiciones","REVISIÓN DE CONDICIONES");
            addOption("#estatus_vivienda","notaria","NOTARIA");
            addOption("#estatus_vivienda","programado firma de escritura","PROGRAMADO FIRMA DE ESCRITURA");
            addOption("#estatus_vivienda","firmado","FIRMADO");
            addOption("#estatus_vivienda","detonado","DETONADO");
            $('#estatus_vivienda').trigger('change');
        }else{
            $('#estatus_vivienda').empty();
            $('#estatus_vivienda').trigger('change');
        }
    });

    function addOption(name,id,titulo,selected=false){
        var o = $("<option/>", {
            value: id,
            text: titulo
        });
        $(name).append(o);
        $(name+' option[value="' + id + '"]').prop('selected',selected);
        $(name).trigger('change');
    }

    function table(){
        var filtros="Filtros";
        filtros+= ($("#estatus_vivienda option:selected").text() != "" && $("#estatus_vivienda option:selected").text() != "Seleccione") ? " > Estatus Vivienda: "+$("#estatus_vivienda option:selected").text() : "";
        filtros+= ($("#promotor option:selected").text() != "" && $("#promotor option:selected").text() != "Seleccione") ? " > Promotor: "+$("#promotor option:selected").text() : "";
        filtros+= (fecha_inicio != "" && fecha_fin != "") ? " > Fecha inicio: "+fecha_inicio+" - Fecha fin: "+fecha_fin : "";
        filtros+= ($("#fraccionamiento option:selected").text() != "" && $("#fraccionamiento option:selected").text() != "Seleccione") ? " > Fraccionamiento: "+$("#fraccionamiento option:selected").text() : "";
        $("#filtros").text(filtros);

        // datatable
        $('[data-ride="datatables"]').DataTable().destroy();
        $('[data-ride="datatables"]').each(function() {
            var oTable = $(this).dataTable( {
                fixedHeader: {
                    header: true,
                    footer: false
                },
                "bProcessing": true,
                "sAjaxSource": "colocacion/listado/"+estatus_vivienda+"_"+promotor+"_"+fecha_inicio+"_"+fecha_fin+"_"+fraccionamiento+"_"+area,
                "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
                "sPaginationType": "full_numbers",
                "aoColumns": [
                    { "mData": "fraccionamiento" },
                    { "mData": "idPromotor" },
                    { "mData": "cliente" },
                    { "mData": "nss" },
                    { "mData": "telefono" },
                    { "mData": "idLugar" },
                    { "mData": "lote" },
                    { "mData": "manzana" },
                    { "mData": "calle" },
                    { "mData": "nOficial" },
                    { "mData": "idPrototipo" },
                    { "mData": "fechaProspeccion" },
                    { "mData": "fechaAltaVenta" },
                    { "mData": "fechaValidacion" },
                    { "mData": "fechaGestoria" },
                    { "mData": "fechaEntregaVivienda" },
                    { "mData": "precioVenta" },
                    { "mData": "statusVivienda" },
                    { "mData": "statusDtu" },
                    { "mData": "estatus" }
                ],
                "aaSorting": []
            } );
        });

    }

});

