$(document).ready(function() {
    // datatable
    $('#sample_3').DataTable().destroy();
    $('#sample_3').each(function() {//[data-ride="datatables"]
        var oTable = $(this).dataTable( {
                        //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Cancelaciones"),
            "bProcessing": true,
            "sAjaxSource": "cancelaciones_gestoria/listado",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "fraccionamiento" },
                { "mData": "nombre" },
                { "mData": "nss" },
                { "mData": "promotor" },
                { "mData": "lote" },
                { "mData": "manzana" },
                //{ "mData": "modulo" },
                { "mData": "idMotivo" },
                { "mData": "motivoCancelacion" },
                { "mData": "fechaAv" },
                { "mData": "fechaCancelacion" }

            ],
            "aaSorting": []
        } );
    });
    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    $('#aplicaFolio').click(function() {
        if ($(this).is(':checked')){
            $(this).val(1);
            $('#contentNumFolio').show('slow');
        }else{
            $(this).val(0);
            $('#numeroFolio').val('')
            $('#contentNumFolio').hide('slow');
        }
    });

    //calculamos suma total en apartado montos
    $(".sumar").on("keydown keyup", function() {
        calculateSum();
    });
    $(".restar").on("keydown keyup", function() {
        calculateSum();
    });

    $('#btnEspacio').click(function(event) {
        /* Act on the event */
        $('#modal-espacio').modal()
    });
});


function calculateSum() {
    var sum = 0;
    var sum2 = 0;
    //iterate through each textboxes and add the values
    $(".sumar").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }
    });

    $(".restar").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum2 += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }
    });

    var total = sum - sum2;

    if (total > 0){
        $("#total").val(total);
        $("#total").formatCurrency();
    }else{
        $("#total").val(parseFloat(total).toFixed(2));
    }
}

function cancelProcess( id ) {
    console.log("Id gestoria: " + id);
    console.log("Motivo cancelación: " + $("#motivoCancelacion").val());
    $.post('gestoria/cancelProcess', {idGestoria: id, motivoCancelacion: $("#motivoCancelacion").val()}, function(data) {
        console.log("Data reponse: " + data);
        $("#cancelProcess").modal('hide');
        if ( $.parseJSON(data).success ) {
            success('El tramite ha sido cancelado');
            location.href ="gestoria";
        }
        else {
            validation($.parseJSON(data).msg);
        }
    });
}
