$(document).ready(function() {
    table();
    
    $("#idCliente, #nssCliente").change(function() {
        var idCliente = $('#idCliente').val();
        var nssCliente = $('#nssCliente').val();
        
        table(idCliente, nssCliente);
    });

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});
    
});

function table(cliente="", nss=""){
    // datatable
    $('#tbl-viviendas').DataTable().destroy();
    $('[data-ride="datatables"]').each(function() {
        var oTable = $(this).dataTable( {
            fixedHeader: {
                header: true,
                footer: false
            },
            "bProcessing": true,
            "sAjaxSource": "busqueda_vivienda/listado",
            "fnServerParams": function ( aoData ) {
                 aoData.push(
                        { "name": "idCliente", "value": cliente },
                        { "name": "nsscliente", "value": nss }
                    );
            },
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "fraccionamiento" },
                { "mData": "nombCliente" },
                { "mData": "nss" },
                { "mData": "titulo" },
                { "mData": "manzana" },
                { "mData": "prototipo" },
                { "mData": "precioVenta" },
                { "mData": "avaluo" },
                { "mData": "txtstatus" },
                { "mData": "statusVivienda" },
                { "mData": "acciones" }
            ],
            "aaSorting": []
        } );
    });
}