$(document).ready(function() {
    table();
    var myTable;
    function table(){

        $('#sample_3').DataTable().destroy();
        myTable = $('#sample_3').DataTable({
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            // Initial no order.
            order: [],
            //Set column definition initialisation properties
            columnDefs: [{
                targets: [0],
                orderable: false
            }],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Arranque"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "arranque/listado/",
                "type": "POST",
            },
            // DataTables server-side processing mode
            "serverSide": true,
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "estatusArranque" },
                { "mData": "titulo" },
                { "mData": "idPaquetes" },
                { "mData": "tipoAlmacen" },
                { "mData": "numeroContrato" },
                { "mData": "totalMO" },
                { "mData": "totalMat" },
                { "mData": "totalArranque" },
                { "mData": "moPagado" },
                { "mData": "matComprado" },
                { "mData": "totalEjecutado" },
                { "mData": "moPorPagar" },
                { "mData": "matPorComprar" },
                { "mData": "totalPorEjecutar" },
                { "mData": "fecha_inicio" },
                { "mData": "fecha_fin" },
            ]
        });
    }

    $("#idEmpresa").change(function (event) {
        let idEmpresa=$(this).val();
        if (idEmpresa != 0) {
            App.blockUI();
            let idArranque=$("#idArranque").val();
            $.post('arranque/getPaquetes/' +idEmpresa+'/'+idArranque, {}, function (data) {
                var res = JSON.parse(data);
                $('.paquetes').empty();
                if (res != 0) {
                    for (i in res) {
                        console.log(res[i].id+" - "+res[i].titulo);
                        addOption(".paquetes",res[i].id,res[i].titulo);
                    }
                }
                $(".paquetes").trigger('change');
            });
            App.unblockUI();
        }else{
            $('.paquetes').empty();
            $(".paquetes").trigger('change');
        }
    });

});

function addOption(name,id,titulo,selected=false){
    var o = $("<option/>", {
        value: id,
        text: titulo
    });
    $(name).append(o);
    $(name+' option[value="' + id + '"]').prop('selected',selected);
}

function cambioEstatus(id, estatus){
    var mensaje = (estatus == 2) ? '¿ESTÁ SEGURO DE PONER "EN CURSO" EL ARRANQUE?' : '¿ESTÁ SEGURO DE PONER "EN FINALIZADO" EL ARRANQUE?'
    ConfirmDialog2(mensaje, 'CONFIRMACIÓN DE ARRANQUE').then(function (res) {
        if (res == "true") {
            App.blockUI();
            $('.loading-message img').attr('src', 'assets/global/img/loading-spinner-grey.gif');
            $.post('arranque/cambioEstatus/' + id+'/'+estatus, {}, function (data, textStatus, xhr) {
                $("#sample_3").DataTable().ajax.reload();
                App.unblockUI();
                var res = JSON.parse(data);
                if (res.showNotification == 1 || res.showNotification == '1'){
                    if (res.isTable == 1 || res.isTable == '1') {
                        var msg = 'EL ARRANQUE NO TIENE LA INFORMACIÓN COMPLETA AQUI SE DETALLA<br><br><br>' +
                            '<table width="100%" border="1" cellpadding="0" cellspacing="1" bordercolor="#000000" style="border-collapse:collapse;border-color:#ddd;">' +
                                '<tr>' +
                                    '<th>PAQUETE</th>' +
                                    '<th>PPTO MANO OBRA</th>' +
                                    '<th>PPTO MATERIALES</th>' +
                                    '<th>ESTIMACIONES</th>' +
                                    '<th>RESIDENTES</th>' +
                                    '<th>PROG. OBRA</th>' +
                                '</tr>';
                        //var json = JSON.parse(res.notificacion);
                        var json = res.notificacion;
                        $.each(json, (index, value) => {
                            msg += '<tr>' +
                                        '<th style="text-align: center;">' + value.paquete + '</th>' +
                                        '<th style="text-align: center;">' + value.pmo + '</th>' +
                                        '<th style="text-align: center;">' + value.pmat + '</th>' +
                                        '<th style="text-align: center;">' + value.estimaciones + '</th>' +
                                        '<th style="text-align: center;">' + value.residentes + '</th>' +
                                        '<th style="text-align: center;">' + value.programa + '</th>' +
                                '</tr>';
                        });
                        msg += '</table>';
                        //msg = JSON.parse($('#notificacion').text());
                        /*ConfirmDialog(msg, 'NOTIFICACIÓN DE ARRANQUE').then(function (res) {
                            if (res == "true") {
                                //location.reload();
                            }
                        });*/
                        modalAnimate(msg, 'NOTIFICACIÓN DE ARRANQUE');
                        setTimeout(function () {
                            //$('#showModalAnimate').trigger('click');
                            $('#modalNotificacion').modal('show');
                        }, 700);
                    }else{
                        //var msg = JSON.parse(res.notificacion);
                        var msg = res.notificacion;
                        /*ConfirmDialog(msg, 'NOTIFICACIÓN DE ARRANQUE').then(function (res) {
                            if (res == "true") {
                                //location.reload();
                            }
                        });*/
                        if(res.sesion == 1){
                            modalAnimate(msg, 'NOTIFICACIÓN DE ARRANQUE', false, false, false, true);
                        }
                        else{
                            modalAnimate(msg, 'NOTIFICACIÓN DE ARRANQUE');
                        }
                        setTimeout(function () {
                            //$('#showModalAnimate').trigger('click');
                            $('#modalNotificacion').modal('show');
                        }, 700);
                    }
                }
            });
        }
    });
}