

    const irregular = {
            'oes' : 'o',
            "esprais" : "espray",
            "noes" : "no",
            "yoes" : "yos",
            "volumenes" : "volumen",
            "cracs" : "crac",
            "albalaes" : "albala",
            "faralaes" : "farala",
            "clubes" : "club",
            "paases" : "paas",
            "jerseis" : "jersey",
            "especamenes" : "especimen",
            "caracteres" : "caracter",
            "menus" : "menu",
            "regamenes" : "regimen",
            "curraculos" : "curriculum",
            "ultimatos" : "ultimatum",
            "memorandos" : "memroandum",
            "referendos" : "referendum",
            "canciones" : "cancion",
            "sandwiches" : "sandwich",
            "migrations" : "migration"
        };

        /**
         * Palabras invariables
         *
         * @var array
         */
    const invariable = [
            "abrelatas",
            "afrikaans",
            "afueras",
            "albricias",
            "aledaños",
            "alias",
            "alicates",
            "andurriales",
            "analisis",
            "atlas",
            "caries",
            "cascarrabias",
            "compost",
            "cortaplumas",
            "creces",
            "crisis",
            "cuelgacapas",
            "cumpleaños",
            "cuadriceps",
            "dosis",
            "dux",
            "deficit",
            "escolaridad",
            "enseres",
            "esponsales",
            "exequias",
            "fauces",
            "facciones",
            "forceps",
            "gafas",
            "gargaras",
            "guardarropas",
            "hipotesis",
            "honorarios",
            "jueves",
            "lavacoches",
            "limpiabotas",
            "lunes",
            "maitines",
            "marcapasos",
            "martes",
            "metamorfosis",
            "miercoles",
            "mondadientes",
            "modales",
            "nupcias",
            "parabrisas",
            "paracaadas",
            "paraguas",
            "pararrayos",
            "pisapapeles",
            "portaaviones",
            "portaequipajes",
            "quitamanchas",
            "rascacielos",
            "rompeolas",
            "sacacorchos",
            "salvavidas",
            "salvavidas",
            "saltamontes",
            "sms",
            "santesis",
            "tesis",
            "test",
            "tenazas",
            "tijeras",
            "triceps",
            "trust",
            "vacaciones",
            "valses",
            "vaveres",
            "viacrucis",
            "viernes",
            "virus",
            "viveres",
            "extasis"
        ];

        /**
         * Palabras incontables.
         *
         * @var array
         */
    const noPlural = [
            "adolescencia",
            "azucar",
            "calor",
            "cafe",
            "canal",
            "caos",
            "cariz",
            "carne",
            "decrepitud",
            "descanso",
            "el",
            "el",
            "ella",
            "ellas",
            "ellos",
            "equipaje",
            "estambre",
            "este",
            "eternidad",
            "fenix",
            "generosidad",
            "grima",
            "hambre",
            "hielo",
            "hojaldre",
            "lente",
            "linde",
            "mar",
            "margen",
            "nada",
            "nadie",
            "norte",
            "nosotras",
            "nosotros",
            "oeste",
            "panico",
            "pereza",
            "poblacion",
            "policia",
            "pringue",
            "pringue",
            "publico",
            "salud",
            "sed",
            "sur",
            "te",
            "tez",
            "tilde",
            "tizne",
            "tu",
            "tu",
            "viescas",
            "vosotras",
            "vosotros",
            "yo"
        ];

        /**
         * Reglas para formar el singular (ends => cut)
         *
         * @var array
         */
    const singularRules = {
            'on' : 'ones',
            'l' : 'les',
            'y' : 'yes',
            'd' : 'des',
            'r' : 'res',
            's' : 'ses',
            'z' : 'ces',
            'a' : 'as',
            'e' : 'es',
            'o' : 'os'
        };

        /**
         * Reglas para formar el plural (add => cut)
         *
         * @var array
         */
    const pluralRules = {
            'ones' : 'on',
            'les' : 'l',
            'yes' : 'y',
            'des' : 'd',
            'res' : 'r',
            'ses' : 's',
            'ces' : 'z',
            'es' : 'e',
            'as' : 'a',
            'os' : 'o'
        };

        /**
         * Reglas para formar el plural (add => cut)
         *
         * @var array
         */
    const preposicion = [
            "a"
            ,"ante"
            ,"bajo"
            ,"cabe"
            ,"con"
            ,"contra"
            ,"de"
            ,"desde"
            ,"en"
            ,"entre"
            ,"hacia"
            ,"hasta"
            ,"para"
            ,"por"
            ,"según"
            ,"sin"
            ,"so"
            ,"sobre"
            ,"tras"
        ];

    const pronombre = [
            /*pronombre personales*/
            "yo"
            ,"me"
            ,"mi"
            ,"nos"
            ,"nosotras"
            ,"nosotros"
            ,"conmigo"
            ,"te"
            ,"ti"
            ,"tu"
            ,"os"
            ,"usted"
            ,"ustedes"
            ,"vos"
            ,"vosotras"
            ,"vosotros"
            ,"contigo"
            ,"el"
            ,"ella"
            ,"ellas"
            ,"ello"
            ,"ellos"
            ,"la"
            ,"las"
            ,"lo"
            ,"lo"
            ,"los"
            ,"le"
            ,"les"
            ,"se"
            ,"si"
            ,"consigo"
            /*pronombres demostrativos*/
            ,"aquellas"
            ,"aquella"
            ,"aquellos"
            ,"aquel"
            ,"aquellas"
            ,"aquella"
            ,"aquellos"
            ,"aquel"
            ,"aquello"
            ,"esas"
            ,"esa"
            ,"esas"
            ,"esa"
            ,"esos"
            ,"ese"
            ,"esos"
            ,"ese"
            ,"eso"
            ,"esotra"
            ,"esotro"
            ,"esta"
            ,"estas"
            ,"esta"
            ,"estas"
            ,"esta"
            ,"estos"
            ,"este"
            ,"estos"
            ,"este"
            ,"esto"
            ,"estotra"
            ,"estotro"
            /*pronombres posesivos*/
            ,"mia"
            ,"mias"
            ,"mio"
            ,"mios"
            ,"nuestra"
            ,"nuestras"
            ,"nuestro"
            ,"nuestros"
            ,"suya"
            ,"suyas"
            ,"suyo"
            ,"suyos"
            ,"tuya"
            ,"tuyas"
            ,"tuyo"
            ,"tuyos"
            ,"vuestra"
            ,"vuestras"
            ,"vuestro"
            ,"vuestros"
            /*pronombres indefinidos*/
            ,"algo"
            ,"alguien"
            ,"alguna"
            ,"algunas"
            ,"alguno"
            ,"algunos"
            ,"cualesquiera"
            ,"cualquiera"
            ,"demas"
            ,"misma"
            ,"mismas"
            ,"mismo"
            ,"mismos"
            ,"mucha"
            ,"muchas"
            ,"mucho"
            ,"muchos"
            ,"nada"
            ,"nadie"
            ,"ninguna"
            ,"ningunas"
            ,"ninguno"
            ,"ningunos"
            ,"otra"
            ,"otras"
            ,"otro"
            ,"otros"
            ,"poca"
            ,"pocas"
            ,"poco"
            ,"pocos"
            ,"quienquier"
            ,"quienesquiera"
            ,"quienquiera"
            ,"tanta"
            ,"tantas"
            ,"tanto"
            ,"tantos"
            ,"toda"
            ,"todas"
            ,"todo"
            ,"todos"
            ,"ultima"
            ,"ultimas"
            ,"ultimo"
            ,"ultimos"
            ,"una"
            ,"unas"
            //,"uno" - OMITIDO POR MARCA
            ,"unos"
            ,"varias"
            ,"varios"
            /*pronombres interrogativos*/
            ,"adonde"
            ,"como"
            ,"cual"
            ,"cuales"
            ,"cuando"
            ,"cuanta"
            ,"cuantas"
            ,"cuanto"
            ,"cuantos"
            ,"donde"
            ,"que"
            ,"quien"
            ,"quienes"
            /*pronombres relativos*/
            ,"como"
            //,"donde" - OMITIDO POR MARCA
            ,"cuando"
            ,"cual"
            ,"cuales"
            ,"cuanta"
            ,"cuantas"
            ,"cuantos"
            ,"cuya"
            ,"cuyas"
            ,"cuyo"
            ,"cuyos"
            ,"que"
        ];


    function plural(string){
        if(!invariable.includes(string)){
            if(!noPlural.includes(string)){
                if(!preposicion.includes(string)){
                    if(!isPlural(string)){
                        string = endsWith(singularRules, string);
                        return string;
                    }
                }
            }
        }
        return string;
    }

    //Devuelve TRUE si es plural la entrada
    function isPlural(string){
        flag=false;
        let end="";
        Object.entries(pluralRules).forEach(entry => {
            const [key] = entry;
            end=string.substring(string.length - key.length, key.length);
            if((end == key)  && !flag){
                flag=true;
            }
        });
        return flag;
    }

    //Retorna palabra singular
    function singular(string){
        if(!invariable.includes(string)){
            string = endsWith(pluralRules, string);
        }
        return string;
    }

    //Devuelve TRUE si es singular la entrada
    function isSingular(string){
        let flag=false;
        let end=""
        Object.entries(singularRules).forEach(entry => {
            const [key] = entry;
            end=string.substring(string.length - key.length, key.length);
            if((end == key) && !flag){
                flag=true;
            }
        });
        return flag;
    }

    //Función de corte y concatenación de cadenas
    function endsWith(haystack, string){
        string = string.toLowerCase();
        let exit=false;
        let end="";
        Object.entries(haystack).forEach(entry => {
            const [key,value] = entry;
            end=string.substring(string.length - key.length, string.length);
            if((end == key) && !exit){
                string= string.substring(0, string.length - key.length);
                //console.log(string," - ",value);
                string+=value;
                exit=true;
            }
        });
        return string;
    }

    //Pluraliza una cadena
    function pluralizar(string){
        string=string.split(" ");
        let result="";
        for (i=0; i < string.length; i++) {
            result+=(i == 0) ? plural(string[i]) : " "+plural(string[i]);
        }
        return result;
    }

    //Singulariza una cadena
    function singularizar(string){
        string=string.split(" ");
        let result="";
        for (i=0; i < string.length; i++) {
            result+=(i == 0) ? singular(string[i]) : " "+singular(string[i]);
        }
        return result;
    }

    //Comprueba que la palabra no sea una preposición, retorna true o false
    function isPreposicion(string){
        return preposicion.includes(string);
    }

    //Comprueba que la palabra no sea un pronombre, retorna true o false
    function isPronombre(string){
        return pronombre.includes(string);
    }