<?php
    class msupercategoriamo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "supercategorias_mo";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".supercategoria
            ,".$this->alias.".idCategoria
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                 $this->alias.".id
            ,".$this->alias.".supercategoria as titulo";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'supercategoria' => '',
                'idCategoria' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['supercategoria'] = $r->row()->supercategoria;
                $array['idCategoria'] = $r->row()->idCategoria;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }  
    }