<?php

    class Mfraccionamiento extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "fraccionamientos";
            $this->alias = 'f';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".titulo
            ,".$this->alias.".estado
            ,".$this->alias.".municipio
            ,".$this->alias.".colonia
            ,".$this->alias.".cp
            ,".$this->alias.".foto
            ,".$this->alias.".thumbnail
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'titulo' => '',
                'estado' => '',
                'municipio' => '',
                'colonia' => '',
                'cp' => '',
                'foto' => '',
                'thumbnail' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['titulo'] = $r->row()->titulo;
                $array['estado'] = $r->row()->estado;
                $array['municipio'] = $r->row()->municipio;
                $array['colonia'] = $r->row()->colonia;
                $array['cp'] = $r->row()->cp;
                $array['foto'] = $r->row()->foto;
                $array['thumbnail'] = $r->row()->thumbnail;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);            

            if($_SESSION['viv']['rol'] > 1){

                $queryIdFraccionamientos  = $this->db->query('
                    SELECT idFraccionamiento FROM fraccionamientosxusuarios
                    WHERE idUsuario = '.$_SESSION['viv']['id'].'
                ');
                $arrayIdFraccs = array(0=>0);
                if($queryIdFraccionamientos->num_rows()>0){
                    $i=0;
                    foreach ($queryIdFraccionamientos->result() as $f) {
                        $arrayIdFraccs[$i] = $f->idFraccionamiento;
                        $i++;
                    }

                }
                $this->db->where_in('f.id',$arrayIdFraccs);
            }

            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getFraccionamientos(){
            $idUsuario=$_SESSION['viv']['id'];
            $rol=$_SESSION['viv']['rol'];
            if ($rol == 1){
                $query=$this->db->query("SELECT * FROM fraccionamientos WHERE status=1");
            }else{
                $query=$this->db->query("SELECT * FROM fraccionamientos WHERE status=1 AND id IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$idUsuario)");
            }


            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllFraccionamientos(){
            $idUsuario=$_SESSION['viv']['id'];
            $rol=$_SESSION['viv']['rol'];
            if ($rol == 1){
                $query=$this->db->query("SELECT * FROM fraccionamientos");
            }else{
                $query=$this->db->query("SELECT * FROM fraccionamientos WHERE id IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$idUsuario)");
            }


            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByTitulo($titulo){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.titulo' => $titulo);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                $query=$query->row();
                return $query->id;
            }else{
                return 0;
            }
        }
    }