<?php
    class Mcategoriamo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "categorias_mo";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".clave
            ,".$this->alias.".categoria
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                 $this->alias.".id
            ,".$this->alias.".categoria as titulo";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'clave' => '',
                'categoria' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['clave'] = $r->row()->clave;
                $array['categoria'] = $r->row()->categoria;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }


       
    }