<?php

    class marranque extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "arranque";
            $this->alias = 'a';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".titulo
            ,".$this->alias.".idPaquetes
            ,".$this->alias.".numeroContrato
            ,".$this->alias.".fecha_inicio
            ,".$this->alias.".fecha_fin
            ,".$this->alias.".fechaFirma
            ,".$this->alias.".idSupervisor
            ,".$this->alias.".retencionfg
            ,".$this->alias.".status
            ,".$this->alias.".estatus_arranque
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'titulo' => '',
                'idPaquetes' => '',
                'numeroContrato' => '',
                'fecha_inicio' => '',
                'fecha_fin' => '',
                'fechaFirma' => '',
                'idSupervisor' => '',
                'retencionfg' => '',
                'status' => '',
                'estatus_arranque' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['titulo'] = $r->row()->titulo;
                $array['idPaquetes'] = $r->row()->idPaquetes;
                $array['numeroContrato'] = $r->row()->numeroContrato;
                $array['fecha_inicio'] = $r->row()->fecha_inicio;
                $array['fecha_fin'] = $r->row()->fecha_fin;
                $array['fechaFirma'] = $r->row()->fechaFirma;
                $array['idSupervisor'] = $r->row()->idSupervisor;
                $array['retencionfg'] = $r->row()->retencionfg;
                $array['status'] = $r->row()->status;
                $array['estatus_arranque'] = $r->row()->estatus_arranque;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = "$this->alias.idPaquetes LIKE '$idPaquete,%' OR $this->alias.idPaquetes LIKE '%,$idPaquete' OR $this->alias.idPaquetes LIKE '%,$idPaquete,%' OR $this->alias.idPaquetes = $idPaquete";
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }
    }