<?php
      class inicio extends MY_Controller {
            public $data,$user,$nsession_front;
            public function __construct(){
                  parent::__construct();
                  $this->nsession_front = $this->config->item('nsession_front');
                  if (!isset($_SESSION[$this->nsession_front]) || (($_SESSION[$this->nsession_front]['usuario'] == ""))) redirect('login');
                  $this->data['fjs'] = array('');
                  $this->data['js'] = array('assets/js/inicio/content.js');
                  $this->data['css'] = '';
                  $this->data['titulo'] ='CONTROL | Avances de Obra ';
                  /* Tools */
                  $this->load->helper(array('tools'));
                  // $this->output->enable_profiler(true);
                  /* Modelos */
                  $this->load->model(array('musuario', 'mpaquete','mfraccionamiento', 'mprototipos', 'mconstructor','mestimacion', 'mpresupuestomo', 'mmanoobra', 'mactividadesprototipo', 'mactividadmo', 'mavanceobra', 'mcategoriamo', 'mproyecto', 'mdetallepaquete', 'marranque', 'msupercategoriamo', 'mfotosvivienda'));

                  $this->data['fotos_www'] = $this->config->item('base_www').'/galeria/';
            }

            // Vista default
            public function index(){
                  $paquetes = array();
                  $paquetesT = array();
                  $qPaquete = $this->mpaquete->getAll();
                  if(!is_numeric($qPaquete)){
                        foreach ($qPaquete->result_array() as $pack) {
                              $qArranque = $this->marranque->getByIdPaquete($pack['id']);
                              if( !is_numeric($qArranque) ){
                                    switch($qArranque['estatus_arranque']){
                                          case 2: $paquete = $this->infoPaquetes($pack); 
                                                if( count($paquete) > 0 ){
                                                      $paquetes[] = $paquete;
                                                }
                                                break;
                                          case 3: $paquete = $this->infoPaquetes($pack);
                                                if( count($paquete) > 0 ){
                                                      $paquetesT[] = $paquete;
                                                }
                                                break;
                                          default:
                                                break;
                                    }
                              }
                        } 
                  }
                  $data['paquetes'] = $paquetes;
                  $data['paquetesT'] = $paquetesT;
                  $this->data['contenido'] = $this->load->view('inicio/index_view', $data, TRUE);
                  $this->load->view('templates/main_template',$this->data);
            }

            // Lista de Lotes por Paquete
            public function paquete($id){
                  $data['id'] = $id;
                  $paquete = $this->mpaquete->getById($id);
                  if(!is_numeric($paquete)){
                        $qArranque = $this->marranque->getByIdPaquete($paquete['id']);
                        $status_arranque = ( !is_numeric($qArranque) )? $qArranque['estatus_arranque'] : 0;
                        // informacion del paquete
                        $MO = $paquete['idManoObra'];
                        $qManoObra = $this->mmanoobra->getbyId($MO);
                        $pack = $this->infoPaquetes($paquete);
                        $pack['statusPaquete'] = $status_arranque;
                        $data['paquete'] = $pack;
                        
                        foreach ($pack['array_lotes'] as $mza => $arrLt) { 
                              foreach ($arrLt as $num => $lote) {
                                    $qProyecto = $this->mproyecto->getLoteByIdFracIdProtLtMz($qManoObra['idFraccionamiento'], $qManoObra['idPrototipo'], $lote, $mza);
                                    if( !is_numeric($qProyecto) ){
                                          $arrTemp[$mza][$num] = array('lt' => $lote, 'idProyecto' => $qProyecto->row()->id);
                                    }
                              }
                        }
                        $data['lotes'] = $arrTemp;
                  }
                  else{
                        $data['paquete'] = array();
                  }

                  $this->data['contenido'] = $this->load->view('inicio/paquete_view', $data, TRUE);
                  $this->load->view('templates/main_template',$this->data);
            }

            // Lista de Supercategorias por Lote
            public function lote($id, $idProyecto){
                  $data['id'] = $id;
                  $data['idProyecto'] = $idProyecto;
                  $paquete = $this->mpaquete->getById($id);
                  $etapas = array();
                  if(!is_numeric($paquete)){
                        $qArranque = $this->marranque->getByIdPaquete($paquete['id']);
                        $status_arranque = ( !is_numeric($qArranque) )? $qArranque['estatus_arranque'] : 0;
                        // informacion del paquete
                        $pack = $this->infoPaquetes($paquete);
                        $pack['statusPaquete'] = $status_arranque;
                        $data['paquete'] = $pack;

                        $qSuperC = $this->msupercategoriamo->getAll();
                        if(!is_numeric($qSuperC)){
                              // Se separan por SuperCategoria
                              foreach ($qSuperC->result() as $superC) {
                                    $lote = array();
                                    //El array de superCategorias
                                    $etapas[] = array( 'id' => $superC->id,
                                          'etapa' => $superC->supercategoria
                                    );
                              }
                        }
                  }
                  else{
                        $data['paquete'] = array();
                  }
                  $qProyecto = $this->mproyecto->getById($idProyecto);
                  if(!is_numeric($qProyecto)){
                        $data['proyecto'] = $qProyecto;
                  }
                  else{
                        $data['proyecto'] = array();
                  }
                  $data['etapas'] = $etapas;

                  $this->data['contenido'] = $this->load->view('inicio/lote_view', $data, TRUE);
                  $this->load->view('templates/main_template',$this->data);
            }

            // Donde se agregaran las imagenes
            public function nuevo($idPaquete, $idProyecto, $idSuperC){
                  $data['idPaquete'] = $idPaquete;
                  $data['idProyecto'] = $idProyecto;
                  $data['idSuperC'] = $idSuperC;
                  $paquete = $this->mpaquete->getById($idPaquete);
                  if(!is_numeric($paquete)){
                        $qArranque = $this->marranque->getByIdPaquete($paquete['id']);
                        $status_arranque = ( !is_numeric($qArranque) )? $qArranque['estatus_arranque'] : 0;
                        // informacion del paquete
                        $MO = $paquete['idManoObra'];
                        $qManoObra = $this->mmanoobra->getbyId($MO);
                        $pack = $this->infoPaquetes($paquete);
                        $pack['statusPaquete'] = $status_arranque;
                        $data['paquete'] = $pack;
                  }
                  else{
                        $data['paquete'] = array();
                  }
                  $qProyecto = $this->mproyecto->getById($idProyecto);
                  if(!is_numeric($qProyecto)){
                        $data['proyecto'] = $qProyecto;
                  }
                  else{
                        $data['proyecto'] = array();
                  }
                  $qSuperC = $this->msupercategoriamo->getById($idSuperC);
                  if(!is_numeric($qSuperC)){
                        $data['etapa'] = $qSuperC;
                  }else{
                        $data['etapa'] = array();
                  }
                  $qFotos = $this->mfotosvivienda->getAllByIdProyIdSuperC($idProyecto, $idSuperC);
                  if(!is_numeric($qFotos)){
                        $data['fotos'] = $qFotos->result_array();
                  }else{
                        $data['fotos'] = array();
                  }
                  $this->data['contenido'] = $this->load->view('inicio/nuevo_view', $data, TRUE);
                  $this->load->view('templates/main_template',$this->data);
            }
            
            public function avance(){
                  $nFotos = $this->mfotosvivienda->getAllByIdProyIdSuperC($_POST['idProyecto'], $_POST['idSupercategoria'], true);
                  $data = 'done';
                  if( $nFotos < 5 ){
                        // Subida de imagenes
                        $config = array();
                        $this->load->library('upload', $config);
                        $this->load->library('image_lib');
                        $this->load->library("image_moo");
                        if (isset($_FILES)){
                              $imagenes = array();
                              foreach($_FILES as $key=>$value){
                                    if ($_FILES[$key]['size'] > 0){
                                          $_FILES[$key]['name'] = strtolower($_FILES[$key]['name']);
                                          $imagenes[] = $key;
                                    }
                              }
                              $totalImagenes = count($imagenes);
      
                              for($i=0; $i< $totalImagenes; $i++){
                                    //Configuracion del thumbnail
                                    $tipo = 'foto';
                                    $v = $nFotos;
                                    if ($tipo == 'foto'){
                                          $uploaddir = $this->data['fotos_www'];
                                          $configT['upload_path'] = $uploaddir;
                                          $configT['image_library'] = 'gd2';
                                          $configT['create_thumb'] = TRUE;
                                          $configT['maintain_ratio'] = FALSE;
                                          $configT['width'] = 150;
                                          $configT['height'] = 150;
                                          //Configuracion de la libreria upload
                                          $nextId = $this->mfotosvivienda->nextId();
                                          $config['file_name'] =  $nextId."_".$v;
                                          $config['overwrite'] = TRUE;
                                          $config['upload_path'] = $uploaddir;
                                          $config['max_size'] = '10240';
                                          $config['allowed_types'] = 'gif|jpg|jpeg|png';
                                          $this->upload->initialize($config);
                                          if ( ! $this->upload->do_upload($imagenes[$i]) ) {
                                                $redirect = 1;
                                                $data = $this->upload->display_errors();
                                          }
                                          else {
                                                $dataFile = $this->upload->data();
                                                //Foto default
                                                $pData['foto'] = $nextId.'_'.$v.$dataFile['file_ext'];
                                                $pData['idSupercategoria'] = $_POST['idSupercategoria'];
                                                $pData['tipo'] = $_POST['supercategoria'];
                                                $pData['idProyecto'] = $_POST['idProyecto'];
                                                $id = $this->mfotosvivienda->insertar($pData);
                                          }
                                    }
                              }
                        }
                  }
                  else{
                        $data = 'Solo puede guardar 5 fotos por etapa.';
                  }

                  echo json_encode($data);
            }

            public function infoPaquetes($pack){
                  $paquete = array();
                  $packEstimado = $this->mestimacion->getByIdPaquete($pack['id']);
                  $qManoObra = $this->mmanoobra->getById($pack['idManoObra']);
                  $LotesManzanas = contarLotesManzanas($pack['rango_lotes']);
                  $manzana = '';
                  if(!is_numeric($packEstimado)){
                        $arrMzs = array_keys($LotesManzanas['arrayMzs']);
                        foreach($arrMzs AS $mzas){
                              $manzana = $manzana . $mzas . ', ';
                        }
                        $manzana = substr($manzana, 0, -2);
                        $residentes = $this->mdetallepaquete->getResidentesByIdPaquete($pack['id']);
                        $textoR = '';
                        if(!is_numeric($residentes)){
                              foreach($residentes->result() as $idResidente){
                                    $nombreR = $this->musuario->getCampo('nombre', $idResidente->idResidente) . ' ' . $this->musuario->getCampo('apellidoP', $idResidente->idResidente) . ' ' . $this->musuario->getCampo('apellidoM', $idResidente->idResidente); 
                                    $textoR = $textoR . $nombreR .'<br>';
                              }
                              $textoR = substr($textoR, 0, -4);
                        }
                        $paquete = array('id' => $pack['id'],
                              'titulo' => $pack['titulo'],
                              'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$qManoObra['idFraccionamiento']),
                              'foto' => $this->mfraccionamiento->getCampo('foto',$qManoObra['idFraccionamiento']),
                              'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                              'constructor' => $this->mconstructor->getCampo('nombre',$pack['idConstructor']) . ' ' . $this->mconstructor->getCampo('apellidoP',$pack['idConstructor']) . ' ' . $this->mconstructor->getCampo('apellidoM',$pack['idConstructor']),
                              'lotes' => $LotesManzanas['lotes'],
                              'manzana' => $manzana,
                              'rango_lotes' => $LotesManzanas['total'],
                              'array_lotes' => $LotesManzanas['arrayMzs'],
                              'fecha_inicio' => $pack['fecha_inicio'],
                              'fecha_fin' => $pack['fecha_fin'],
                              'residentes' => ($textoR != '')? $textoR : 'No tiene residentes asignados'
                        );
                  }
                  return $paquete;
            }
            
            public function eliminar_archivo() {
                  if (isset($_POST['elid'])){
                        $id = $this->input->post('elid');
                        $archivo = $this->mfotosvivienda->getCampo('foto',$id);
                        if(unlink($this->data['fotos_www'].$archivo)){// Se borra el registro de la tabla
                              $this->mfotosvivienda->borrar($id);
                              $c_valor = "true";
                        }else{ $c_valor = "false";}
                        $data = json_encode(array("valor"=>$c_valor));
                        echo $data;
                  }
            }
      }