<?php

    class Mprototipoxfraccionamiento extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "prototiposxfraccionamiento";
            $this->alias = 'pf';
            $this->aliasPro = 'pro';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".titulo AS titulo_old
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectPrototipo = "".
                $this->aliasPro.".id AS pt_id
            ,".$this->aliasPro.".nombre AS titulo
            ,".$this->aliasPro.".status AS pt_status
            ,IF(".$this->aliasPro.".status > 0,'Activo','Inactivo') AS pt_txtstatus";

            $this->SelectResult = "".
            $this->aliasPro.".id
            ,".$this->aliasPro.".titulo";

            $this->SelectIds = "".
            $this->aliasPro.".id";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'titulo' => '',
                'idPrototipo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['titulo'] = $r->row()->titulo;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias.'.idFraccionamiento' => $_SESSION['viv']['idFraccionamiento']);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllList(){
            // $this->db->select($this->selectDefault.",".$this->selectPrototipo,FALSE);
            $this->db->select('pro.id, pro.nombre AS titulo',FALSE);
            $arrayWhere = array($this->alias.'.status' => true);//, $this->alias.'.idFraccionamiento' => $_SESSION['viv']['idFraccionamiento']

            if($_SESSION['viv']['rol'] > 1){
                //sino es super admin, obtenemos el id de cada fraccionamiento donde el usuario está asociado
                $queryIdFraccionamientos  = $this->db->query('
                    SELECT idFraccionamiento FROM fraccionamientosxusuarios
                    WHERE idUsuario = '.$_SESSION['viv']['id'].'
                ');
                $arrayIdFraccs = array(0=>0);
                if($queryIdFraccionamientos->num_rows()>0){
                    $i=0;
                    foreach ($queryIdFraccionamientos->result() as $f) {
                        $arrayIdFraccs[$i] = $f->idFraccionamiento;
                        $i++;
                    }

                }
                $this->db->where_in('pf.idFraccionamiento',$arrayIdFraccs);
            }

            $this->db->where($arrayWhere);
            $this->db->join("prototipos pro", "pro.id=pf.idPrototipo");
            $this->db->group_by('pf.idPrototipo');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdFraccionamiento($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idFraccionamiento' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

    }