<?php
    class Mordenpago extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "orden_pago";
            $this->alias = 'o';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idEstimaciones
            ,".$this->alias.".monto
            ,".$this->alias.".statusPago
            ,".$this->alias.".retencion
            ,".$this->alias.".retencionvicios
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPaquete' => '',
                'idEstimaciones' => '',
                'monto' => '',
                'statusPago' => '',
                'retencion' => '',
                'retencionvicios' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idEstimaciones'] = $r->row()->idEstimaciones;
                $array['monto'] = $r->row()->monto;
                $array['statusPago'] = $r->row()->statusPago;
                $array['retencion'] = $r->row()->retencion;
                $array['retencionvicios'] = $r->row()->retencionvicios;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getActiveByIdEstimaciones($idEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            $this->db->where($this->alias.'.idEstimaciones = '.$idEstimaciones.' AND '.$this->alias.'.statusPago != 4');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getAllByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getCanceladoByIdEstimaciones($idEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            $this->db->where($this->alias.'.idEstimaciones = '.$idEstimaciones.' AND '.$this->alias.'.statusPago = 4');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }
    }