<?php

    class Mactividadesprototipo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "actividadesprototipo";
            $this->alias = 'ap';
            $this->selectDefault = "".
            $this->alias.".id
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".idCategoria
            ,".$this->alias.".idActividad
            ,".$this->alias.".cantidad
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPrototipo' => '',
                'idCategoria' => '',
                'idActividad' => '',
                'cantidad' => '',
                'tipo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['idCategoria'] = $r->row()->idCategoria;
                $array['idActividad'] = $r->row()->idActividad;
                $array['cantidad'] = $r->row()->cantidad;
                $array['tipo'] = $r->row()->cantidad;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllByPrototipoCategoria($idPrototipo=0,$idCategoria=0){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.idPrototipo' => $idPrototipo,$this->alias.'.idCategoria' => $idCategoria);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "ASC");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getCategoriasByPrototipo($idManoObra=0){
            /*$query="SELECT idCategoria,(SELECT categoria FROM categorias_mo WHERE id=idCategoria) categoria FROM actividadesprototipo WHERE
            idPrototipo=$idPrototipo GROUP BY idCategoria ORDER BY idCategoria ASC";*/
            $query="SELECT act.idCategoria FROM presupuesto_mo pmo LEFT JOIN actividadesprototipo act ON pmo.idActividadPrototipo=act.id 
            WHERE pmo.idManoObra=$idManoObra GROUP BY act.idCategoria";

            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPrototipo($idPrototipo){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPrototipo' => $idPrototipo);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getActividadesNews($idPrototipo){
            $query = $this->db->query('
                SELECT a.id, p.idActividadPrototipo, p.id AS idPresupuestoMO, a.idPrototipo, a.idCategoria, a.idActividad, a.cantidad, p.precioUnitario
                FROM actividadesprototipo AS a LEFT JOIN presupuesto_mo AS p ON a.id = p.idActividadPrototipo
                WHERE a.idPrototipo = '.$idPrototipo. ' ORDER BY a.id ASC;
            ');
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getAllByManoObraCategoria($MO=0,$idCategoria=0){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = $this->alias . '.status = 1 AND mo.id = ' . $MO . ' AND ' . $this->alias.'.idCategoria = ' . $idCategoria . ' AND pmo.idActividadPrototipo = ' . $this->alias.'.id';
            $this->db->join('mano_obra as mo', $this->alias . '.idPrototipo = mo.idPrototipo');
            $this->db->join('presupuesto_mo as pmo', 'mo.id = pmo.idManoObra');
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "ASC");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }