<?php
      class inicio extends MY_Controller {
            public $data,$user,$nsession_front;
            public function __construct(){
                  parent::__construct();
                  $this->nsession_front = $this->config->item('nsession_front');
                  if (!isset($_SESSION[$this->nsession_front]) || (($_SESSION[$this->nsession_front]['usuario'] == ""))) redirect('login');
                  $this->data['fjs'] = array('');
                  $this->data['js'] = array('assets/js/inicio/content.js?v=2');
                  $this->data['css'] = '';
                  $this->data['titulo'] ='CONTROL | Avances de Obra ';
                  /* Tools */
                  $this->load->helper(array('tools'));
                  /* Modelos */
                  $this->load->model(array('musuario', 'mpaquete', 'mroles', 'mfraccionamiento', 'mprototipos', 'mconstructor','mestimacion', 'mestimaciones', 'mestimados', 'mpresupuestomo', 'mmanoobra', 'mactividadesprototipo', 'mactividadmo', 'mavanceobra', 'mcategoriamo', 'mordenpago', 'mproyecto', 'mdetallepaquete', 'mpaquetepresupuesto', 'marranque'));
            }

            // Vista default
            public function index(){
                  $allPaquetes = array();
                  $paquetes = array();
                  $paquetesT = array();
                  $paquetesP = array();
                  if( $_SESSION[$this->nsession_front]['rol'] == 9 ){
                        $qPaquete = $this->mpaquete->getByIdResidente($_SESSION[$this->nsession_front]['id']);
                        if(!is_numeric($qPaquete)){
                              foreach ($qPaquete->result() as $pack) {
                                    $qArranque = $this->marranque->getByIdPaquete($pack->id);
                                    if( !is_numeric($qArranque) ){
                                          switch($qArranque['estatus_arranque']){
                                                case 1: $detallePack = $this->mdetallepaquete->getByIdResidente($pack->id, $_SESSION[$this->nsession_front]['id']);
                                                      $arrRango = array();
                                                      $arrMzs = array();
                                                      $textoLots = '';
                                                      $manzana = '';
                                                      if(!is_numeric($detallePack)){
                                                            $lts['total'] = $detallePack->num_rows();
                                                            foreach($detallePack->result() as $dPack){
                                                                  if( !in_array($dPack->rango_lotes, $arrRango) ){
                                                                        $tempLtMz = contarLotesManzanas($dPack->rango_lotes);
                                                                        $arrRango[] = $dPack->rango_lotes;
                                                                        $textoLots = $textoLots . $tempLtMz['lotes'] . ' ';
                                                                        $keyA = array_keys($tempLtMz['arrayMzs']);
                                                                        $manzana = $manzana . $keyA[0] . ', ';
                                                                  }
                                                            }
                                                            $lts['lotes'] = substr($textoLots, 0, -1);
                                                            $manzana = substr($manzana, 0, -2);
                                                            unset($arrRango);
                                                            unset($textoLots);
                                                      }
                                                      else{
                                                            $lts['total'] = 0;
                                                      }
                                                      $packEstimado = $this->mestimacion->getByIdPaquete($pack->id);
                                                      $qManoObra = $this->mmanoobra->getById($pack->idManoObra);
                                                      if(!is_numeric($packEstimado)){
                                                            $paquetesP[] = array('id' => $pack->id,
                                                                  'titulo' => $pack->titulo,
                                                                  'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$qManoObra['idFraccionamiento']),
                                                                  'foto' => $this->mfraccionamiento->getCampo('foto',$qManoObra['idFraccionamiento']),
                                                                  'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                                                                  'constructor' => $this->mconstructor->getCampo('nombre',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoP',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoM',$pack->idConstructor),
                                                                  'lotes' => $lts['lotes'],
                                                                  'manzana' => $manzana,
                                                                  'rango_lotes' => $lts['total'],
                                                                  'fecha_inicio' => $pack->fecha_inicio,
                                                                  'fecha_fin' => $pack->fecha_fin,
                                                                  'residentes' => ''
                                                            );
                                                      }
                                                      break;
                                                case 2: $detallePack = $this->mdetallepaquete->getByIdResidente($pack->id, $_SESSION[$this->nsession_front]['id']);
                                                      $arrRango = array();
                                                      $arrMzs = array();
                                                      $textoLots = '';
                                                      $manzana = '';
                                                      if(!is_numeric($detallePack)){
                                                            $lts['total'] = $detallePack->num_rows();
                                                            foreach($detallePack->result() as $dPack){
                                                                  if( !in_array($dPack->rango_lotes, $arrRango) ){
                                                                        $tempLtMz = contarLotesManzanas($dPack->rango_lotes);
                                                                        $arrRango[] = $dPack->rango_lotes;
                                                                        $textoLots = $textoLots . $tempLtMz['lotes'] . ' ';
                                                                        $keyA = array_keys($tempLtMz['arrayMzs']);
                                                                        $manzana = $manzana . $keyA[0] . ', ';
                                                                  }
                                                            }
                                                            $lts['lotes'] = substr($textoLots, 0, -1);
                                                            $manzana = substr($manzana, 0, -2);
                                                            unset($arrRango);
                                                            unset($textoLots);
                                                      }
                                                      else{
                                                            $lts['total'] = 0;
                                                      }
                                                      $packEstimado = $this->mestimacion->getByIdPaquete($pack->id);
                                                      $qManoObra = $this->mmanoobra->getById($pack->idManoObra);
                                                      if(!is_numeric($packEstimado)){
                                                            $paquetes[] = array('id' => $pack->id,
                                                                  'titulo' => $pack->titulo,
                                                                  'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$qManoObra['idFraccionamiento']),
                                                                  'foto' => $this->mfraccionamiento->getCampo('foto',$qManoObra['idFraccionamiento']),
                                                                  'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                                                                  'constructor' => $this->mconstructor->getCampo('nombre',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoP',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoM',$pack->idConstructor),
                                                                  'lotes' => $lts['lotes'],
                                                                  'manzana' => $manzana,
                                                                  'rango_lotes' => $lts['total'],
                                                                  'fecha_inicio' => $pack->fecha_inicio,
                                                                  'fecha_fin' => $pack->fecha_fin,
                                                                  'residentes' => ''
                                                            );
                                                      }
                                                      break;
                                                case 3: $detallePack = $this->mdetallepaquete->getByIdResidente($pack->id, $_SESSION[$this->nsession_front]['id']);
                                                      $arrRango = array();
                                                      $textoLots = '';
                                                      $manzana = '';
                                                      if(!is_numeric($detallePack)){
                                                            $lts['total'] = $detallePack->num_rows();
                                                            foreach($detallePack->result() as $dPack){
                                                                  if( !in_array($dPack->rango_lotes, $arrRango) ){
                                                                        $tempLtMz = contarLotesManzanas($dPack->rango_lotes);
                                                                        $arrRango[] = $dPack->rango_lotes;
                                                                        $textoLots = $textoLots . $tempLtMz['lotes'] . ' ';
                                                                        $keyA = array_keys($tempLtMz['arrayMzs']);
                                                                        $manzana = $manzana . $keyA[0] . ', ';
                                                                  }
                                                            }
                                                            $lts['lotes'] = substr($textoLots, 0, -1);
                                                            $manzana = substr($manzana, 0, -2);
                                                            unset($arrRango);
                                                            unset($textoLots);
                                                      }
                                                      else{
                                                            $lts['total'] = 0;
                                                      }
                                                      $packEstimado = $this->mestimacion->getByIdPaquete($pack->id);
                                                      $qManoObra = $this->mmanoobra->getById($pack->idManoObra);
                                                      if(!is_numeric($packEstimado)){
                                                            $paquetesT[] = array('id' => $pack->id,
                                                                  'titulo' => $pack->titulo,
                                                                  'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$qManoObra['idFraccionamiento']),
                                                                  'foto' => $this->mfraccionamiento->getCampo('foto',$qManoObra['idFraccionamiento']),
                                                                  'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                                                                  'constructor' => $this->mconstructor->getCampo('nombre',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoP',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoM',$pack->idConstructor),
                                                                  'lotes' => $lts['lotes'],
                                                                  'manzana' => $manzana,
                                                                  'rango_lotes' => $lts['total'],
                                                                  'fecha_inicio' => $pack->fecha_inicio,
                                                                  'fecha_fin' => $pack->fecha_fin,
                                                                  'residentes' => ''
                                                            );
                                                      }
                                                      break;
                                                default:
                                                      break;
                                          }
                                    }
                              } 
                        }
                  }
                  if($_SESSION[$this->nsession_front]['rol'] == 1 || $_SESSION[$this->nsession_front]['rol'] == 5 || $_SESSION[$this->nsession_front]['rol'] == 14){
                        $qPaquete = $this->mpaquete->getAll();
                        if(!is_numeric($qPaquete)){
                              foreach ($qPaquete->result() as $pack) {
                                    $qArranque = $this->marranque->getByIdPaquete($pack->id);
                                    if( !is_numeric($qArranque) ){
                                          switch($qArranque['estatus_arranque']){
                                                case 1: $packEstimado = $this->mestimacion->getByIdPaquete($pack->id);
                                                      $qManoObra = $this->mmanoobra->getById($pack->idManoObra);
                                                      $LotesManzanas = contarLotesManzanas($pack->rango_lotes);
                                                      $manzana = '';
                                                      if(!is_numeric($packEstimado)){
                                                            $arrMzs = array_keys($LotesManzanas['arrayMzs']);
                                                            foreach($arrMzs AS $mzas){
                                                                  $manzana = $manzana . $mzas . ', ';
                                                            }
                                                            $manzana = substr($manzana, 0, -2);
                                                            $residentes = $this->mdetallepaquete->getResidentesByIdPaquete($pack->id);
                                                            $textoR = '';
                                                            if(!is_numeric($residentes)){
                                                                  foreach($residentes->result() as $idRes){
                                                                        $nombreR = $this->musuario->getCampo('nombre', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoP', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoM', $idRes->idResidente); 
                                                                        $textoR = $textoR . $nombreR .'<br>';
                                                                  }
                                                                  $textoR = substr($textoR, 0, -4);
                                                            }
                                                            $paquetesP[] = array('id' => $pack->id,
                                                                  'titulo' => $pack->titulo,
                                                                  'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$qManoObra['idFraccionamiento']),
                                                                  'foto' => $this->mfraccionamiento->getCampo('foto',$qManoObra['idFraccionamiento']),
                                                                  'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                                                                  'constructor' => $this->mconstructor->getCampo('nombre',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoP',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoM',$pack->idConstructor),
                                                                  'lotes' => $LotesManzanas['lotes'],
                                                                  'manzana' => $manzana,
                                                                  'rango_lotes' => $LotesManzanas['total'],
                                                                  'fecha_inicio' => $pack->fecha_inicio,
                                                                  'fecha_fin' => $pack->fecha_fin,
                                                                  'residentes' => ($textoR != '')? $textoR : 'No tiene residentes asignados'
                                                            );
                                                      }
                                                      break;
                                                case 2: $packEstimado = $this->mestimacion->getByIdPaquete($pack->id);
                                                      $qManoObra = $this->mmanoobra->getById($pack->idManoObra);
                                                      $LotesManzanas = contarLotesManzanas($pack->rango_lotes);
                                                      $manzana = '';
                                                      if(!is_numeric($packEstimado)){
                                                            $arrMzs = array_keys($LotesManzanas['arrayMzs']);
                                                            foreach($arrMzs AS $mzas){
                                                                  $manzana = $manzana . $mzas . ', ';
                                                            }
                                                            $manzana = substr($manzana, 0, -2);
                                                            $residentes = $this->mdetallepaquete->getResidentesByIdPaquete($pack->id);
                                                            $textoR = '';
                                                            if(!is_numeric($residentes)){
                                                                  foreach($residentes->result() as $idRes){
                                                                        $nombreR = $this->musuario->getCampo('nombre', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoP', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoM', $idRes->idResidente); 
                                                                        $textoR = $textoR . $nombreR .'<br>';
                                                                  }
                                                                  $textoR = substr($textoR, 0, -4);
                                                            }
                                                            $paquetes[] = array('id' => $pack->id,
                                                                  'titulo' => $pack->titulo,
                                                                  'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$qManoObra['idFraccionamiento']),
                                                                  'foto' => $this->mfraccionamiento->getCampo('foto',$qManoObra['idFraccionamiento']),
                                                                  'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                                                                  'constructor' => $this->mconstructor->getCampo('nombre',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoP',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoM',$pack->idConstructor),
                                                                  'lotes' => $LotesManzanas['lotes'],
                                                                  'manzana' => $manzana,
                                                                  'rango_lotes' => $LotesManzanas['total'],
                                                                  'fecha_inicio' => $pack->fecha_inicio,
                                                                  'fecha_fin' => $pack->fecha_fin,
                                                                  'residentes' => ($textoR != '')? $textoR : 'No tiene residentes asignados'
                                                            );
                                                      }
                                                      break;
                                                case 3: $packEstimado = $this->mestimacion->getByIdPaquete($pack->id);
                                                      $qManoObra = $this->mmanoobra->getById($pack->idManoObra);
                                                      $LotesManzanas = contarLotesManzanas($pack->rango_lotes);
                                                      $manzana = '';
                                                      if(!is_numeric($packEstimado)){
                                                            $arrMzs = array_keys($LotesManzanas['arrayMzs']);
                                                            foreach($arrMzs AS $mzas){
                                                                  $manzana = $manzana . $mzas . ', ';
                                                            }
                                                            $manzana = substr($manzana, 0, -2);
                                                            $residentes = $this->mdetallepaquete->getResidentesByIdPaquete($pack->id);
                                                            $textoR = '';
                                                            if(!is_numeric($residentes)){
                                                                  foreach($residentes->result() as $idRes){
                                                                        $nombreR = $this->musuario->getCampo('nombre', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoP', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoM', $idRes->idResidente); 
                                                                        $textoR = $textoR . $nombreR .'<br>';
                                                                  }
                                                                  $textoR = substr($textoR, 0, -4);
                                                            }
                                                            $paquetesT[] = array('id' => $pack->id,
                                                                  'titulo' => $pack->titulo,
                                                                  'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo',$qManoObra['idFraccionamiento']),
                                                                  'foto' => $this->mfraccionamiento->getCampo('foto',$qManoObra['idFraccionamiento']),
                                                                  'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                                                                  'constructor' => $this->mconstructor->getCampo('nombre',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoP',$pack->idConstructor) . ' ' . $this->mconstructor->getCampo('apellidoM',$pack->idConstructor),
                                                                  'lotes' => $LotesManzanas['lotes'],
                                                                  'manzana' => $manzana,
                                                                  'rango_lotes' => $LotesManzanas['total'],
                                                                  'fecha_inicio' => $pack->fecha_inicio,
                                                                  'fecha_fin' => $pack->fecha_fin,
                                                                  'residentes' => ($textoR != '')? $textoR : 'No tiene residentes asignados'
                                                            );
                                                      }
                                                      break;
                                                default:
                                                      break;
                                          }
                                    }
                              } 
                        }
                  }
                  $paquetes = $paquetes;
                  $paquetesT = $paquetesT;
                  $paquetesP = $paquetesP;
                  array_push($allPaquetes, $paquetes);
                  array_push($allPaquetes, $paquetesP);
                  array_push($allPaquetes, $paquetesT);
                  $data['paquetes'] = $allPaquetes;
                  $this->data['contenido'] = $this->load->view('inicio/index_view', $data, TRUE);
                  $this->load->view('templates/main_template',$this->data);
            }

            // Lista de actividades
            public function avance($id){
                  $data['id'] = $id;
                  $paquete = $this->mpaquete->getById($id);
                  if(!is_numeric($paquete)){
                        $qArranque = $this->marranque->getByIdPaquete($paquete['id']);
                        $status_arranque = ( !is_numeric($qArranque) )? $qArranque['estatus_arranque'] : 0;
                        $residentes = '';
                        if( $_SESSION[$this->nsession_front]['rol'] == 9 ){
                              $detallePack = $this->mdetallepaquete->getByIdResidente($paquete['id'], $_SESSION[$this->nsession_front]['id']);
                              $arrLots = array();
                              $arrRango = array();
                              $textoLots = '';
                              $manzana = '';
                              if(!is_numeric($detallePack)){
                                    $lts['total'] = $detallePack->num_rows();
                                    foreach($detallePack->result() as $dPack){
                                          if( !in_array($dPack->rango_lotes, $arrRango) ){
                                                $tempLtMz = contarLotesManzanas($dPack->rango_lotes);
                                                $arrRango[] = $dPack->rango_lotes;
                                                $textoLots = $textoLots . $tempLtMz['lotes'] . ' ';
                                                $keyA = array_keys($tempLtMz['arrayMzs']);
                                                $manzana = $manzana . $keyA[0] . ', ';
                                                $arrLots[$keyA[0]] = $tempLtMz['arrayMzs'][$keyA[0]];
                                          }
                                    }
                                    $lts['arrayLts'] = $arrLots;
                                    $lts['lotes'] = substr($textoLots, 0, -2);
                                    $manzana = substr($manzana, 0, -2);
                                    $keyA = array_keys($arrLots);
                                    unset($arrRango);
                                    unset($arrLots);
                                    unset($tempLtMz);
                                    unset($textoLots);
                              }
                              else{
                                    $lts['total'] = 0;
                              }                              
                        }
                        if($_SESSION[$this->nsession_front]['rol'] == 1 || $_SESSION[$this->nsession_front]['rol'] == 5 || $_SESSION[$this->nsession_front]['rol'] == 14){
                              $LotesManzanas = contarLotesManzanas($paquete['rango_lotes']);
                              $manzana = '';
                              $arrMzs = array_keys($LotesManzanas['arrayMzs']);
                              foreach($arrMzs AS $mzas){
                                    $manzana = $manzana . $mzas . ', ';
                              }
                              $manzana = substr($manzana, 0, -2);
                              $lts['arrayLts'] = $LotesManzanas['arrayMzs'];
                              $lts['total'] = $LotesManzanas['total'];
                              $lts['lotes'] = $LotesManzanas['lotes'];
                              $keyA = array_keys($LotesManzanas['arrayMzs']);
                              $residentes = $this->mdetallepaquete->getResidentesByIdPaquete($paquete['id']);
                              $textoR = '';
                              if(!is_numeric($residentes)){
                                    foreach($residentes->result() as $idRes){
                                          $nombreR = $this->musuario->getCampo('nombre', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoP', $idRes->idResidente) . ' ' . $this->musuario->getCampo('apellidoM', $idRes->idResidente); 
                                          $textoR = $textoR . $nombreR .'<br>';
                                    }
                                    $residentes = substr($textoR, 0, -4);
                              }
                              else{
                                    $residentes = 'No tiene residentes asignados';
                              }
                              unset($arrayMzs);
                              unset($textoR);
                        }
                        // informacion del paquete
                        $MO = $paquete['idManoObra'];
                        $qManoObra = $this->mmanoobra->getbyId($MO);
                        $pack = array('id' => $paquete['id'],
                              'titulo' => $paquete['titulo'],
                              'fraccionamiento' => $this->mfraccionamiento->getCampo('titulo', $qManoObra['idFraccionamiento']),
                              'prototipo' => $this->mprototipos->getCampo('nombre',$qManoObra['idPrototipo']),
                              'constructor' => $this->mconstructor->getCampo('nombre',$paquete['idConstructor']) . ' ' . $this->mconstructor->getCampo('apellidoP',$paquete['idConstructor']) . ' ' . $this->mconstructor->getCampo('apellidoM',$paquete['idConstructor']),
                              'lotes' => $lts['lotes'],
                              'manzana' => $manzana,
                              'rango_lotes' => $lts['total'],
                              'array_lotes' => $lts['arrayLts'],
                              'fecha_inicio' => $paquete['fecha_inicio'],
                              'fecha_fin' => $paquete['fecha_fin'],
                              'statusPaquete' => $status_arranque,
                              'residentes' => $residentes
                        );
                        $data['paquete'] = $pack;
                        $data['lotes'] = $lts['arrayLts'];

                        // Información de las semanas
                        $qEstimacion = $this->mestimacion->getByIdPaquete($pack['id']);
                        $estimaciones = array();
                        $idCancel = array();
                        $idEs = 0;
                        if(!is_numeric($qEstimacion)){
                              $qEstimaciones = $this->mestimaciones->getAllByIdEstimacion($qEstimacion['id']);
                              if(!is_numeric($qEstimaciones)){
                                    $futuro = false;
                                    foreach ($qEstimaciones->result() as $esti) {
                                          $fecha_fin = new DateTime($esti->fecha);
                                          $intervalo = new DateInterval('P6D');
                                          // Se suman los 6 dias para que obtener el día final [semana] (1 + 6 = 7 :V)
                                          $fecha_fin->add($intervalo);
                                          $estimaciones[$esti->id] = array('id' => $esti->id,
                                                'nEstimacion' => $esti->nEstimacion,
                                                'fecha_ini' => $esti->fecha,
                                                'fecha_fin' => $fecha_fin->format('Y-m-d')
                                          );
                                          if($fecha_fin->format('Y-m-d') >= date('Y-m-d') && $esti->fecha <= date('Y-m-d')){
                                                $idEs = $esti->id;
                                                $Cancel = false;
                                                $orden = $this->mordenpago->getActiveByIdEstimaciones($esti->id);
                                                // Checa que no haya una order pagada, pendente o facturada
                                                if(is_numeric($orden)){
                                                      // Si no existe orden con cualquier otro estatus, llama a ver si hay orden cancelada
                                                      $ordenC = $this->mordenpago->getCanceladoByIdEstimaciones($esti->id);
                                                      // Si la hay volvera a activarla
                                                      if(!is_numeric($ordenC)){
                                                            $Cancel = true;
                                                      }
                                                }
                                                if($esti->fecha > date('Y-m-d')){
                                                      $futuro = true;
                                                }
                                          }
                                    }
                                    //Inicia listado
                                    if(!$idEs && $futuro && $status_arranque == 3){
                                          try {
                                                $this->db->trans_begin();
                                                $crear = false;
                                                $qPresupuesto = $this->mpresupuestomo->getByIdManoObra($MO);
                                                $detallePaquete = $this->mdetallepaquete->getByIdPaquete($paquete['id']);
                                                $xPaquete = $detallePaquete->num_rows();
                                                if(!is_numeric($qPresupuesto)){
                                                      foreach ($qPresupuesto->result() as $valor) {
                                                            $qPackPresu = $this->mpaquetepresupuesto->getByIdPaqueteIdPresupuesto($paquete['id'], $valor->id);
                                                            if(!is_numeric($qPackPresu)){
                                                                  if($qPackPresu['lotesCompletados'] != $xPaquete){
                                                                        $crear = true;
                                                                        break;
                                                                  }
                                                            }
                                                      }
                                                      if($crear){
                                                            $fecha_fin = new DateTime($esti->fecha);
                                                            $intervalo = new DateInterval('P7D');
                                                            $fecha_fin->add($intervalo);
                                                            $eData['idEstimacion'] = $qEstimacion['id'];
                                                            $eData['nEstimacion'] = $esti->nEstimacion + 1;
                                                            $eData['fecha'] = $fecha_fin->format('Y-m-d');

                                                            //aqui se suma la semana
                                                            $idEs = $this->mestimaciones->insertar($eData);
                                                            $Cancel = false;
                                                            $orden = 0;
                                                            if(is_numeric($idEs)){
                                                                  $qCatProt = $this->mactividadesprototipo->getCategoriasByPrototipo($qManoObra['idManoObra']);
                                                                  foreach ($qCatProt->result() as $CategoriaProt) {
                                                                        $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($qManoObra['idManoObra'], $CategoriaProt->idCategoria);
                                                                        foreach ($qActProt->result() as $ActividadProt) {
                                                                              $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($MO, $ActividadProt->id);
                                                                              if(!is_numeric($qPresupuesto)){
                                                                                    $esData['idEstimaciones'] = $idEs;
                                                                                    $esData['idPresupuesto'] = $qPresupuesto['id'];
                                                                                    $esData['estimacion'] = 0;
                                                                                    $idE2 = $this->mestimados->insertar($esData);
                                                                                    $avData['idEstimado'] = $idE2;
                                                                                    $idA = $this->mavanceobra->insertar($avData);
                                                                              }
                                                                        }
                                                                  }
                                                                  $intervalo = new DateInterval('P6D');
                                                                  $fecha_fin->add($intervalo);
                                                                  $estimaciones[$idEs] = array('id' => $idEs,
                                                                        'nEstimacion' => $eData['nEstimacion'],
                                                                        'fecha_ini' => $eData['fecha'],
                                                                        'fecha_fin' => $fecha_fin->format('Y-m-d')
                                                                  );
                                                            }
                                                      }
                                                }

                                                if ($this->db->trans_status() === FALSE){
                                                      $this->db->trans_rollback();
                                                }
                                                else{
                                                      $this->db->trans_commit();
                                                }
                                          }
                                          catch (\Exception $e)
                                          {
                                              if ($this->db->trans_status() === FALSE){
                                                  $this->db->trans_rollback();
                                                  die($e->getMessage());
                                              }
                                          }
                                    }
                                    //Finaliza listado
                              }
                        }
                        $data['idEs'] = $idEs;
                        $data['estimaciones'] = $estimaciones;

                        $categorias = array();
                        $actividades = array();
                        foreach ($lts['arrayLts'] as $manzanas => $lotes) {
                              foreach ($lotes as $lots) {
                                    $faltantes[$manzanas][$lots] = 0;
                              }
                        }
                        unset($lotes);
                        if(isset($pack['id'])){
                              $MO = $paquete['idManoObra'];
                              $qCatProt = $this->mactividadesprototipo->getCategoriasByPrototipo($MO);
                              if(!is_numeric($qCatProt)){
                                    // Se separan por categoria
                                    foreach ($qCatProt->result() as $CategoriaProt) {
                                          $lote = array();
                                          //El array de categorias
                                          $categorias[] = array( 'id' => $CategoriaProt->idCategoria,
                                                'clave' => $this->mcategoriamo->getCampo('clave', $CategoriaProt->idCategoria),
                                                'categoria' => $this->mcategoriamo->getCampo('categoria', $CategoriaProt->idCategoria),
                                          );
                                    }
                                    // Se separa la actividad de la 1a categoria
                                    $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($paquete['idManoObra'], $qCatProt->row()->idCategoria);
                                    if(!is_numeric($qActProt) && $idEs > 0){
                                          // Aqui separara por actividades
                                          foreach ($qActProt->result() as $ActividadProt) {
                                                $qActividad = $this->mactividadmo->getById($ActividadProt->idActividad);
                                                $avance = array();
                                                if(!is_numeric($qActividad)){
                                                      $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($MO, $ActividadProt->id);
                                                      if(!is_numeric($qPresupuesto)){
                                                            $qEstimado = $this->mestimados->getByIdPresupuestoAndIdEstimaciones($qPresupuesto['id'], $idEs);
                                                            $qLotesPresu = $this->mavanceobra->getAllLotesByIdPresupuesto($qPresupuesto['id']);
                                                            foreach ($lts['arrayLts'] as $manzanas => $mzLots) {
                                                                  foreach ($mzLots as $lots) {
                                                                        $lotes[$manzanas][$lots] = 0;
                                                                        $activar[$manzanas][$lots] = true;
                                                                        $mostrar[$manzanas][$lots] = false;
                                                                  }
                                                            }
                                                            // 
                                                            if($status_arranque == 2 && (is_numeric($orden) || $Cancel) ){
                                                                  foreach ($lts['arrayLts'] as $manzanas => $mzLots) {
                                                                        foreach ($mzLots as $lots) {
                                                                              // Es para revisar que un lote que este marcado (que no sea de la semana actual) si esta marcado, no permita que se marque otra vez en otra semana
                                                                              $qOtrosAvances = $this->mavanceobra->getAllByIdPresuSinIdEstiLikeLt($qPresupuesto['id'], $idEs, $lots.'/'.$manzanas);
                                                                              if(!is_numeric($qOtrosAvances)){
                                                                                    foreach ($qOtrosAvances->result() as $avans) {
                                                                                          $checar = explode(',', $avans->lotes);
                                                                                          foreach ($checar as $key) {
                                                                                                if($key == $lots.'/'.$manzanas){
                                                                                                      $activar[$manzanas][$lots] = false;
                                                                                                }
                                                                                          }
                                                                                    }
                                                                              }
                                                                        }
                                                                  }
                                                            }
                                                            else{
                                                                  foreach ($lts['arrayLts'] as $manzanas => $mzLots) {
                                                                        foreach ($mzLots as $lots) {
                                                                              $activar[$manzanas][$lots] = false;
                                                                        }
                                                                  }
                                                            }
                                                            if(!is_numeric($qLotesPresu)){
                                                                  foreach ($qLotesPresu->result() as $lots) {
                                                                        $ltTA = explode(',', $lots->lotes);
                                                                        foreach ($lts['arrayLts'] as $manzas => $lotes2) {
                                                                              foreach ($lotes2 as $lots2) {
                                                                                    $lotes[$manzas][$lots2] = (in_array($lots2.'/'.$manzas, $ltTA))? $lotes[$manzas][$lots2] + 1 : $lotes[$manzas][$lots2];
                                                                              }
                                                                        }
                                                                  }  
                                                            }
                                                            // Aqui ya se guarda la info. de avance en base al estimado
                                                            $qAvance = $this->mavanceobra->getByIdEstimado($qEstimado['id']);
                                                            $ltsEstimados = $qEstimado['estimacion'];
                                                            
                                                            if(!is_numeric($qAvance)){
                                                                  $ltA = explode(',', $qAvance['lotes']);
                                                                  foreach ($lts['arrayLts'] as $manzanas => $mzLots) {
                                                                        foreach ($mzLots as $lots) {
                                                                              $mostrar[$manzanas][$lots] = ($ltsEstimados > 0 || $activar)? true : false;
                                                                              $estados[$manzanas][$lots] = (in_array($lots.'/'.$manzanas, $ltA))? true : false;
                                                                              $mostrar[$manzanas][$lots] = ((in_array($lots.'/'.$manzanas, $ltA)))? true : $mostrar[$manzanas][$lots];
                                                                        }
                                                                  }
                                                                  
                                                                  $avance = array('id' => $qAvance['id'],
                                                                        'estado' => $estados,
                                                                        'activar' => $activar,
                                                                        'mostrar' => $mostrar
                                                                  );
                                                            }
                                                      }
                                                }
                                                //Al guardar el array de actividad, tendra el avance de la obra.
                                                if(!empty($avance)){
                                                      $actividades[] = array('id' => $ActividadProt->idActividad,
                                                            'clave' => $qActividad['clave'],
                                                            'descripcion' => $qActividad['descripcion'],
                                                            'lotes' => $lotes,
                                                            'avances' => $avance
                                                      );
                                                      foreach ($lts['arrayLts'] as $manzas => $mzLots) {
                                                            foreach ($mzLots as $lots) {
                                                                  $faltantes[$manzas][$lots] = $faltantes[$manzas][$lots] + $lotes[$manzas][$lots];
                                                            }
                                                      }
                                                }
                                          }
                                    }
                              }
                        }

                        $data['categorias'] = $categorias;
                        $data['actividades'] = $actividades;
                        $data['faltantes'] = $faltantes;
                        $data['keyM'] = $keyA[0];
                  }
                  else{
                        $data['paquete'] = array();
                  }

                  $this->data['contenido'] = $this->load->view('inicio/avances_view', $data, TRUE);
                  $this->load->view('templates/main_template',$this->data);
            }

            public function guardar(){
                  $enables = array();
                  $spanLot = 0;
                  //Hay que separar el titulo de los inputs, para obtener el id del avance y el lote a agregar
                  $datos = explode('_', $_POST['nombre']);
                  // Se revisa en 4 porque se separa en cuatro [semana, categoria, lote y avance]
                  if(count($datos) === 5){
                        $idAvan = substr($datos[4], 4);
                        $lt = substr($datos[2], 2);
                        $mza = substr($datos[3], 2);
                        $ltAnte = $this->mavanceobra->getCampo('lotes', $idAvan); // Lotes registrador
                        $DltAnte = $this->mavanceobra->getCampo('dia_lotes', $idAvan); // Lotes registrados por días
                        $ltT = explode(',', $ltAnte); // Array de lotes temporales
                        $lotes = ''; //Nuevo string que actualiza lotes
                        $Dlts = ''; //Nuevo string que actualiza lotes * día
                        $idEsdo = $this->mavanceobra->getCampo('idEstimado', $idAvan);
                        $idEsti = $this->mestimados->getCampo('idEstimaciones', $idEsdo);
                        $idEs = $this->mestimaciones->getCampo('idEstimacion', $idEsti);
                        $idPaquete = $this->mestimacion->getCampo('idPaquete', $idEs);
                        $idPresu = $this->mestimados->getCampo('idPresupuesto', $idEsdo);
                  }
                  if($_POST['valor'] === 'true' && count($datos) === 5){
                        // Si no hay lotes en el avance, entrara
                        if(empty($ltAnte)){
                              $lotes = $lt.'/'.$mza;
                              $Dlts = date('D').'_'.$lt.'/'.$mza;
                        }
                        else {
                              // Si ya hay datos, se debe realizar lo siguiente
                              array_push($ltT, $lt.'/'.$mza);
                              sort($ltT);
                              foreach ($ltT as $lot) {
                                    $lotes = $lotes . $lot . ',';
                              }
                              $lotes = substr($lotes, 0, -1);
                              $Dlotes = explode(' ', $DltAnte);
                              // guarda los dias registrados
                              foreach ($Dlotes as $dias) {
                                    $dia = explode('_', $dias);
                                    foreach ($dia as $d) {
                                          $pos = strpos('/', $d);
                                          if (!empty($d) && !is_numeric($d) && $pos === false) {
                                                $arD[] = $d;
                                          }
                                    }
                              }
                              //revisa si alguno de los dias guardados esta guardado
                              if(in_array(date('D'), $arD)){
                                    foreach ($Dlotes as $dias) {
                                          $dia = explode('_', $dias);
                                          if(date('D') == $dia[0]){
                                                $dlt = explode(',', $dia[1]);
                                                array_push($dlt, $lt.'/'.$mza);
                                                sort($dlt);
                                                $Dlts = $Dlts . date('D') . '_';
                                                foreach ($dlt as $lot) {
                                                      $Dlts = $Dlts . $lot . ',';
                                                }
                                                $Dlts = substr($Dlts, 0, -1);
                                                $Dlts = $Dlts . ' ';
                                          }
                                          else{
                                                $Dlts = $Dlts . $dias . ' ';
                                          }
                                    }
                                    $Dlts = substr($Dlts, 0, -1);
                              }
                              else{
                                    // Si no es el dia, mantendra el dia como esta
                                    $Dlts = $DltAnte . ' ' . date('D').'_'.$lt.'/'.$mza;
                              }
                        }
                        $pData['lotes'] = $lotes;
                        $pData['dia_lotes'] = $Dlts;
                        $this->mavanceobra->actualizar($pData, $idAvan);
                        foreach ($_POST['otros'] as $key){
                              //Todos se volveran a habilitar
                              $enables[] = $key[0];
                              // Si no estaba marcado se sumara al array para las notificaciones
                              if($key[1] === 'false'){
                                    $spanLot = $spanLot + 1;
                              }
                        }
                        $qPackPresu = $this->mpaquetepresupuesto->getByIdPaqueteIdPresupuesto($idPaquete, $idPresu);
                        if(!is_numeric($qPackPresu)){
                              $nuevoTotal = $qPackPresu['lotesCompletados'] + 1;
                              $pqLtAnt = $qPackPresu['lotes'];
                              $pqLt = '';
                              if(empty($pqLtAnt)){
                                    $pqLt = $lt.'/'.$mza;
                              }
                              else {
                                    $pqLAr = explode(',', $pqLtAnt);
                                    array_push($pqLAr, $lt.'/'.$mza);
                                    sort($pqLAr);
                                    foreach ($pqLAr as $lot) {
                                          $pqLt = $pqLt . $lot . ',';
                                    }
                                    $pqLt = substr($pqLt, 0, -1);
                              }
                              $lData['lotesCompletados'] = $nuevoTotal;
                              $lData['lotes'] = $pqLt;
                              $this->mpaquetepresupuesto->actualizar($lData, $qPackPresu['id']);
                        }
                  }
                  else{
                        //Codigo para borrar
                        // Si ya hay datos, se debe realizar lo siguiente
                        foreach ($ltT as $lot) {
                              if($lt.'/'.$mza != $lot){
                                    $lotes = $lotes . $lot . ',';
                              }
                        }
                        // Separa los dias con lotes marcados anteriormente
                        $DltA = explode(' ', $DltAnte);
                        //Este array va a ser para separar los días con sus lotes: array[lunes] = array(lt1, lt2, ...) 
                        $diasT = array();
                        foreach ($DltA as $dias) {
                              $dia = explode('_', $dias);
                              $dlt = explode(',', $dia[1]);
                              sort($dlt);
                              foreach ($dlt as $lot) {
                                    $diasT[$dia[0]][] = $lot;
                              }
                        }
                        // Revisara los arreglos y borrara el lote que coincida
                        foreach ($diasT as $dias) {
                              $keys = array_keys($diasT, $dias)[0];
                              $temp = array();
                              for ($i=0; $i < count($dias); $i++) {
                                    if($lt.'/'.$mza != $dias[$i]){
                                          $temp[] = $dias[$i];
                                    }
                              }
                              if(empty($temp)){
                                    unset($diasT[$keys]);
                              }
                              else{
                                    $diasT[$keys] = $temp;
                              }
                        }
                        // crea el string de los lotes por dias que aun quedan marcados
                        foreach ($diasT as $dias) {
                              $Dlts = $Dlts . array_keys($diasT, $dias)[0] . '_';
                              foreach ($dias as $lot) {
                                    $Dlts = $Dlts . $lot . ',';
                              }
                              $Dlts = substr($Dlts, 0, -1);
                              $Dlts = $Dlts . ' ';
                        }
                        $Dlts = substr($Dlts, 0, -1);
                        $lotes = substr($lotes, 0, -1);
                        $upgrade['dia_lotes'] = (empty($Dlts))? NULL : $Dlts;
                        $upgrade['lotes'] = (empty($lotes))? NULL : $lotes;
                        $this->mavanceobra->actualizar($upgrade, $idAvan);
                        // Todos se volveran a habilitar
                        foreach ($_POST['otros'] as $key){
                              $enables[] = $key[0];
                              if($key[1] === 'false'){
                                    $spanLot = $spanLot + 1;
                              }
                        }
                        $qPackPresu = $this->mpaquetepresupuesto->getByIdPaqueteIdPresupuesto($idPaquete, $idPresu);
                        if(!is_numeric($qPackPresu)){
                              $nuevoTotal = $qPackPresu['lotesCompletados'] - 1;
                              $pqLtAnt = $qPackPresu['lotes'];
                              $pqLt = '';
                              $pqLAr = explode(',', $pqLtAnt);                              
                              foreach ($pqLAr as $lot) {
                                    if($lt.'/'.$mza != $lot){
                                          $pqLt = $pqLt . $lot . ',';
                                    }
                              }
                              $pqLt = substr($pqLt, 0, -1);
                              $lData['lotesCompletados'] = $nuevoTotal;
                              $lData['lotes'] = (empty($pqLt))? NULL : $pqLt;
                              $this->mpaquetepresupuesto->actualizar($lData, $qPackPresu['id']);
                        }
                  }
                  $datitos['activos'] = $enables;
                  $datitos['notificarXLt'] = $spanLot;
                  echo json_encode($datitos);
            }

            public function crearLote(){
                  $actividades = array();
                  $datos = explode('_', $_POST['valor']);
                  if(count($datos) === 4){
                        $esTecnica = false;
                        if($_SESSION[$this->nsession_front]['rol'] == 1 || $_SESSION[$this->nsession_front]['rol'] == 5 || $_SESSION[$this->nsession_front]['rol'] == 14){
                              $esTecnica = true;
                        }                        
                        $idSema = substr($datos[0], 4);
                        $idEstimacion = $this->mestimaciones->getCampo('idEstimacion', $idSema);
                        // Calcular fecha
                        $fecha_ini = $this->mestimaciones->getCampo('fecha', $idSema);
                        $fecha_fin = new DateTime($fecha_ini);
                        $intervalo = new DateInterval('P6D');
                        // Se suman los 6 dias para que obtener el día final [semana] (1 + 6 = 7 :V)
                        $fecha_fin->add($intervalo);
                        // Fin para el calculo de fechas
                        // Llama cualquier orden que no este cancelada
                        $Cancel = false;
                        $orden = $this->mordenpago->getActiveByIdEstimaciones($idSema);
                        // Checa que no haya una order pagada, pendente o facturada
                        if(is_numeric($orden)){
                              // Si no existe orden con cualquier otro estatus, llama a ver si hay orden cancelada
                              $ordenC = $this->mordenpago->getCanceladoByIdEstimaciones($idSema);
                              // Si la hay volvera a activarla
                              if(!is_numeric($ordenC)){
                                    $Cancel = true;
                              }
                        }
                        $idPrototipo = $this->mestimacion->getCampo('idPrototipo', $idEstimacion);
                        $idPaquete = $this->mestimacion->getCampo('idPaquete', $idEstimacion);
                        $qArranque = $this->marranque->getByIdPaquete($idPaquete);
                        $status_arranque = ( !is_numeric($qArranque) )? $qArranque['estatus_arranque'] : 0;
                        $MO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
                        $idCate = substr($datos[1], 4);
                        $lt = substr($datos[2], 2);
                        $mza = substr($datos[3], 2);
                        // Se separa la actividad de la 1a categoria
                        $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($MO, $idCate);
                        $actividades = array();
                        if(!is_numeric($qActProt)){
                              // Aqui separara por actividades
                              foreach ($qActProt->result() as $ActividadProt) {
                                    $qActividad = $this->mactividadmo->getById($ActividadProt->idActividad);
                                    $avance = array();
                                    if(!is_numeric($qActividad)){
                                          $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($MO, $ActividadProt->id);
                                          if(!is_numeric($qPresupuesto)){
                                                $qEstimado = $this->mestimados->getByIdPresupuestoAndIdEstimaciones($qPresupuesto['id'], $idSema);
                                                $qOtrosAvances = $this->mavanceobra->getAllByIdPresuSinIdEstiLikeLt($qPresupuesto['id'], $idSema, $lt.'/'.$mza);
                                                $activar = true;
                                                $mostrar = false;
                                                
                                                if($status_arranque == 2 && ( ( ( ($fecha_fin->format('Y-m-d') >= date('Y-m-d') && $fecha_ini <= date('Y-m-d')) || $esTecnica) && is_numeric($orden) ) || ( ($fecha_fin->format('Y-m-d') <= date('Y-m-d') || $esTecnica) && $Cancel ) ) ){
                                                      // Es para revisar que un lote que este marcado (que no sea de la semana actual) si esta marcado, no permita que se marque otra vez en otra semana
                                                      if(!is_numeric($qOtrosAvances)){
                                                            foreach ($qOtrosAvances->result() as $avans) {
                                                                  $checar = explode(',', $avans->lotes);
                                                                  foreach ($checar as $key) {
                                                                        if($key == $lt.'/'.$mza){
                                                                              $activar = false;
                                                                        }
                                                                  }
                                                            }
                                                      }
                                                }
                                                else{
                                                      $activar = false;
                                                }
                                                // Aqui ya se guarda la info. de avance en base al estimado
                                                $qAvance = $this->mavanceobra->getByIdEstimado($qEstimado['id']);
                                                $ltsEstimados = $qEstimado['estimacion'];
                                                $mostrar = ($ltsEstimados > 0 || $activar)? true : false;
                                                if(!is_numeric($qAvance)){
                                                      $ltA = explode(',', $qAvance['lotes']);
                                                      $avance = array('id' => $qAvance['id'],
                                                            'estado' => (in_array($lt.'/'.$mza, $ltA))? 1 : 0,
                                                            'activar' => $activar,
                                                            'mostrar' => ((in_array($lt.'/'.$mza, $ltA)))? true : $mostrar
                                                      );
                                                }
                                          }
                                    }
                                    if(!empty($avance)){
                                          //Al guardar el array de actividad, tendra el avance de la obra.
                                          $actividades[] = array('id' => $ActividadProt->idActividad,
                                                'clave' => $qActividad['clave'],
                                                'descripcion' => $qActividad['descripcion'],
                                                'avances' => $avance
                                          );
                                    }
                              }
                        }
                  }
                  echo json_encode($actividades);
            }
            
            public function crearCategoriaXSemana(){
                  if(!empty($_POST['semana']) && !empty($_POST['cate'])){
                        $idSema = substr($_POST['semana'], 4);
                        $idEstimacion = $this->mestimaciones->getCampo('idEstimacion', $idSema);
                        // Calcular fecha
                        $fecha_ini = $this->mestimaciones->getCampo('fecha', $idSema);
                        $fecha_fin = new DateTime($fecha_ini);
                        $intervalo = new DateInterval('P6D');
                        // Se suman los 6 dias para que obtener el día final [semana] (1 + 6 = 7 :V)
                        $fecha_fin->add($intervalo);
                        // Fin para el calculo de fechas
                        // Llama cualquier orden que no este cancelada
                        $Cancel = false;
                        $orden = $this->mordenpago->getActiveByIdEstimaciones($idSema);

                        // Checa que no haya una order pagada, pendente o facturada
                        if(is_numeric($orden)){
                              // Si no existe orden con cualquier otro estatus, llama a ver si hay orden cancelada
                              $ordenC = $this->mordenpago->getCanceladoByIdEstimaciones($idSema);
                              // Si la hay volvera a activarla
                              if(!is_numeric($ordenC)){
                                    $Cancel = true;
                              }
                        }
                        $idPrototipo = $this->mestimacion->getCampo('idPrototipo', $idEstimacion);
                        $idPaquete = $this->mestimacion->getCampo('idPaquete', $idEstimacion);
                        $qArranque = $this->marranque->getByIdPaquete($idPaquete);
                        $status_arranque = ( !is_numeric($qArranque) )? $qArranque['estatus_arranque'] : 0;
                        $MO = $this->mpaquete->getCampo('idManoObra', $idPaquete);
                        $idCate = substr($_POST['cate'], 4);
                  
                        if( $_SESSION[$this->nsession_front]['rol'] == 9 ){
                              $esTecnica = false;
                              $detallePack = $this->mdetallepaquete->getByIdResidente($idPaquete, $_SESSION[$this->nsession_front]['id']);
                              $arrMzs = array();
                              $arrLots = array();
                              $arrRango = array();
                              $textoLots = '';
                              if(!is_numeric($detallePack)){
                                    $lts['total'] = $detallePack->num_rows();
                                    foreach($detallePack->result() as $dPack){
                                          if( !in_array($dPack->rango_lotes, $arrRango) ){
                                                $tempLtMz = contarLotesManzanas($dPack->rango_lotes);
                                                $arrRango[] = $dPack->rango_lotes;
                                                $textoLots = $textoLots . $tempLtMz['lotes'] . ' ';
                                                $keyA = array_keys($tempLtMz['arrayMzs']);
                                                $arrMzs[$keyA[0]] = $tempLtMz['arrayMzs'][$keyA[0]];
                                          }
                                    }
                                    $lts['arrayMzs'] = $arrMzs;
                                    $lts['lotes'] = substr($textoLots, 0, -2);
                                    $keyA = array_keys($arrMzs);
                                    unset($arrRango);
                                    unset($tempLtMz);
                                    unset($arrMzs);
                                    unset($textoLots);
                              }
                              else{
                                    $lts['total'] = 0;
                              }
                        }
                        if($_SESSION[$this->nsession_front]['rol'] == 1 || $_SESSION[$this->nsession_front]['rol'] == 5 || $_SESSION[$this->nsession_front]['rol'] == 14){
                              $esTecnica = true;
                              $rango_lotes = $this->mpaquete->getCampo('rango_lotes', $idPaquete);
                              $LotesManzanas = contarLotesManzanas($rango_lotes);
                              $lts['arrayMzs'] = $LotesManzanas['arrayMzs'];
                              $keyA = array_keys($LotesManzanas['arrayMzs']);
                              unset($LotesManzanas);
                        }
                        foreach($lts['arrayMzs'] as $manzana => $mzsLts){
                              foreach($mzsLts as $lots){
                                    $arrLots[] = $lots.'_mz'.$manzana;
                                    $titulos[] = $lots.' ('.$manzana.')';
                              }
                        }
                        $lts['arrayLts'] = $arrLots;
                        unset($arrLots);
                        foreach ($lts['arrayLts'] as $lots) {
                              $faltantes[$lots] = 0;
                        }
                        // Se separa la actividad de la 1a categoria
                        $qActProt = $this->mactividadesprototipo->getAllByManoObraCategoria($MO, $idCate);
                        $actividades = array();
                        if(!is_numeric($qActProt)){
                              // Aqui separara por actividades
                              foreach ($qActProt->result() as $ActividadProt) {
                                    $qActividad = $this->mactividadmo->getById($ActividadProt->idActividad);
                                    $avance = array();
                                    if(!is_numeric($qActividad)){
                                          $qPresupuesto = $this->mpresupuestomo->getByidManoObraIdActividadPrototipo($MO, $ActividadProt->id);
                                          if(!is_numeric($qPresupuesto)){
                                                $qEstimado = $this->mestimados->getByIdPresupuestoAndIdEstimaciones($qPresupuesto['id'], $idSema);
                                                $qLotesPresu = $this->mavanceobra->getAllLotesByIdPresupuesto($qPresupuesto['id']);
                                                foreach ($lts['arrayLts'] as $lots) {
                                                      $lotes[$lots] = 0;
                                                      $activar[$lots] = true;
                                                      $mostrar[$lots] = false;
                                                }
                                                
                                                if($status_arranque == 2 && ( ( ( ($fecha_fin->format('Y-m-d') >= date('Y-m-d') && $fecha_ini <= date('Y-m-d')) || $esTecnica) && is_numeric($orden) ) || ( ($fecha_fin->format('Y-m-d') <= date('Y-m-d') || $esTecnica) && $Cancel ) ) ){
                                                      // Es para revisar que un lote que este marcado (que no sea de la semana actual) si esta marcado, no permita que se marque otra vez en otra semana
                                                      foreach ($lts['arrayMzs'] as $manzas => $lotes2) {
                                                            foreach ($lotes2 as $lots2) {
                                                                  $qOtrosAvances = $this->mavanceobra->getAllByIdPresuSinIdEstiLikeLt($qPresupuesto['id'], $idSema, $lots2.'/'.$manzas);
                                                                  if(!is_numeric($qOtrosAvances)){
                                                                        foreach ($qOtrosAvances->result() as $avans) {
                                                                              $checar = explode(',', $avans->lotes);
                                                                              foreach ($checar as $key) {
                                                                                    if($key == $lots2.'/'.$manzas){
                                                                                          $activar[$lots2.'_mz'.$manzas] = false;
                                                                                    }
                                                                              }
                                                                        }
                                                                  }
                                                            }
                                                      }
                                                }
                                                else{
                                                      foreach ($lts['arrayLts'] as $lots) {
                                                            $activar[$lots] = false;
                                                      }
                                                }
                                                if(!is_numeric($qLotesPresu)){
                                                      foreach ($qLotesPresu->result() as $lots) {
                                                            $ltTA = explode(',', $lots->lotes);
                                                            foreach ($lts['arrayMzs'] as $manzas => $lotes2) {
                                                                  foreach ($lotes2 as $lots2) {
                                                                        $lotes[$lots2.'_mz'.$manzas] = (in_array($lots2.'/'.$manzas, $ltTA))? $lotes[$lots2.'_mz'.$manzas] + 1 : $lotes[$lots2.'_mz'.$manzas];
                                                                  }
                                                            }
                                                      }  
                                                }
                                                // Aqui ya se guarda la info. de avance en base al estimado
                                                $qAvance = $this->mavanceobra->getByIdEstimado($qEstimado['id']);
                                                $ltsEstimados = $qEstimado['estimacion'];
                                                if(!is_numeric($qAvance)){
                                                      $ltA = explode(',', $qAvance['lotes']);
                                                      foreach ($lts['arrayMzs'] as $manzas => $lotes2) {
                                                            foreach ($lotes2 as $lots2) {
                                                                  $mostrar[$lots2.'_mz'.$manzas] = ($ltsEstimados > 0 || $activar[$lots2.'_mz'.$manzas])? true : false;
                                                                  $estados[$lots2.'_mz'.$manzas] = (in_array($lots2.'/'.$manzas, $ltA))? 1 : 0;
                                                                  $mostrar[$lots2.'_mz'.$manzas] = ((in_array($lots2.'/'.$manzas, $ltA) ) )? true : $mostrar[$lots2.'_mz'.$manzas];
                                                            }
                                                      }
                                                      $avance = array('id' => $qAvance['id'],
                                                            'estado' => $estados,
                                                            'activar' => $activar,
                                                            'mostrar' => $mostrar
                                                      );
                                                }
                                          }
                                    }
                                    if(!empty($avance)){
                                          //Al guardar el array de actividad, tendra el avance de la obra.
                                          $actividades[] = array('id' => $ActividadProt->idActividad,
                                                'clave' => $qActividad['clave'],
                                                'descripcion' => $qActividad['descripcion'],
                                                'lotes' => $lotes,
                                                'avances' => $avance
                                          );
                                          foreach ($lts['arrayLts'] as $lots) {
                                                $faltantes[$lots] = $faltantes[$lots] + $lotes[$lots];
                                          }
                                    }
                              }
                        }
                        $datitos['actividades'] = $actividades;
                        $datitos['lotes'] = $lts['arrayLts'];
                        $datitos['titulos'] = $titulos;
                        $datitos['faltantes'] = $faltantes;
                  }
                  else{
                        $datitos['actividades'] = array();
                        $datitos['lotes'] = array();
                        $datitos['faltantes'] = array();
                  }
                  echo json_encode($datitos);
            }
      }