<?php
    class munidades extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "unidades";
            $this->alias = 'u';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".unidad
            ,".$this->alias.".abreviatura
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                $this->alias.".id
            ,CONCAT(".$this->alias.".unidad,' ',".$this->alias.".abreviatura) AS titulo";     
         }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'unidad' => '',
                'abreviatura' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['unidad'] = $r->row()->unidad;
                $array['abreviatura'] = $r->row()->abreviatura;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }



    }