<?php

class msync extends MY_Model{

    var $column_order = array('id');
    var $column_search = array('titulo');
    var $order = array('id' => 'desc'); // default order
    var $info;
    var $query="";
    protected $CI;
    public function __construct()
    {
        parent::__construct();
        $this->CI =& get_instance();
        $this->load->database();
    }

    ///////////Inician funciones de carga del lado del servidor///////////
    private function _get_datatables_query(){
        //ID USUARIO TIPO TIEMPO VERSION INICIO FIN ESTATUS
        $usuario="CONCAT_WS(' ',usr.nombre,usr.apellidoP,usr.apellidoM) usuario ";
        $this->query="SELECT $usuario,lws.id,lws.nombreTabla,lws.funcion,lws.json,lws.created,lws.updated,lws.created_by,
        TIMESTAMPDIFF(SECOND,lws.created,lws.updated) as tiempo, 
        TIMESTAMPDIFF(MINUTE,lws.updated,NOW()) as transcurrido
        FROM logs_ws lws
        LEFT JOIN usuarios usr ON usr.id=lws.created_by
        WHERE nombreTabla LIKE '%syncApp%' ";
        //Adaptación especial para que trabaje con UNION
        $i=0;
        foreach ($this->column_search as $item){
            if($_POST['search']['value']) {

                if($i===0){
                    $this->query.=" AND (".$item." LIKE '%".$_POST['search']['value']."%'";
                }else{
                    $this->query.=" OR ".$item." LIKE '%".$_POST['search']['value']."%'";
                }
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->query.=")";
            }
            $i++;
        }
        //Termina adaptación especial

        $this->createFilters();
        //Adaptación genérica, no se modifica.
        if(isset($_POST['order'])){
            $this->query.=" ORDER BY ".$this->column_order[$_POST['order']['0']['column']]." ".$_POST['order']['0']['dir'];
        }else if(isset($this->order)){
            $order = $this->order;
            $this->query.=" ORDER BY ".key($order)." ".$order[key($order)];
        }
        //Termina adaptación genérica
    }

    function get_datatables(){
        $this->info=$_REQUEST["info"];
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->query.=" LIMIT ".$_POST['start'].",".$_POST['length'];
        $this->query = $this->db->query($this->query);
        if($this->query->num_rows() > 0){
            return $this->query;
        }else{
            return 0;
        }
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }
    ////////////Terminan de carga del del lado del servidor////////////

    public function createFilters(){
        foreach ($this->info as $key => $val) {
            if($val != "" AND $val != 0){
                switch($key){
                    case 'fecha_inicio': 
                        $fecha_inicio = date_format(new DateTime($val),"Y-m-d");
                        break;
                    case 'fecha_fin': 
                        $fecha_fin = date_format(new DateTime($val),"Y-m-d");
                        if ($fecha_inicio != "" && $fecha_fin != "") {
                            if($fecha_inicio != $fecha_fin){
                                $this->query.=" AND lws.fecha >= '$fecha_inicio' AND lws.fecha <= '$fecha_fin' + INTERVAL 1 DAY ";
                            }else{
                                $this->query.=" AND DATE(lws.fecha) = DATE('$fecha_inicio') ";
                            }
                        }
                        break;
                    case 'idUsuario': 
                        $this->query.=" AND lws.created_by=$val ";
                        break;
                }
            }
        }
    }

}
