<?php
    class msubcategoriamo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "subcategorias_mo";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".clave
            ,".$this->alias.".categoria
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                 $this->alias.".id
            ,".$this->alias.".categoria as titulo";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'clave' => '',
                'categoria' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['clave'] = $r->row()->clave;
                $array['categoria'] = $r->row()->categoria;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getSubCategoriasByPaquete($idPaquete){
            $query="SELECT idSubCategoria,(SELECT categoria FROM subcategorias_mo WHERE id=idSubCategoria) subCategoria,COUNT(idSubCategoria) n FROM actividades_mo WHERE idSubCategoria IN (SELECT id FROM subcategorias_mo WHERE id IN (SELECT (SELECT idSubCategoria FROM actividades_mo WHERE id=(SELECT idActividad FROM actividadesprototipo WHERE id=(SELECT idActividadPrototipo FROM presupuesto_mo pmo WHERE id = idPresupuestoMO))) subcategoria FROM paquete_presupuesto WHERE idPaquete=$idPaquete)) GROUP BY idSubCategoria ORDER BY idSubCategoria";

            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getSubCategoriasFinalizadasByLote($idPaquete,$nEstimacion,$lote){
            $subCategoria="(SELECT idSubCategoria FROM actividades_mo WHERE id = (SELECT idActividad FROM actividadesprototipo WHERE id = (SELECT idActividadPrototipo FROM presupuesto_mo WHERE id = (SELECT idPresupuesto FROM estimados_programa WHERE id=idEstimado))))";

            $query="SELECT $subCategoria idSubCategoria,COUNT($subCategoria) n FROM avanceobra WHERE idEstimado IN (SELECT id FROM estimados_programa WHERE idEstimaciones IN 
                (SELECT id FROM estimaciones_programa WHERE idEstimacion=(SELECT id FROM estimacion_programa WHERE idPaquete=$idPaquete) AND nEstimacion <= $nEstimacion)) AND lotes LIKE '%$lote%' GROUP BY $subCategoria ORDER BY $subCategoria ";

            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query->result_array();
            }else{
                return 0;
            }
        }

       
    }