<?php

    class Mrecepcion extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "recepcion";
            $this->alias = 'r';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".id_orden_compra
            ,".$this->alias.".fecha
            ,".$this->alias.".folio
            ,".$this->alias.".id_proveedor
            ,".$this->alias.".id_almacen
            ,".$this->alias.".id_moneda
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".importe_neto
            ,".$this->alias.".numero_articulos
            ,".$this->alias.".fecha_entrega
            ,".$this->alias.".estatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'id_orden_compra' => '',
                'fecha' => '',
                'folio' => '',
                'id_proveedor' => '',
                'id_almacen' => '',
                'id_moneda' => '',
                'importe_neto' => '',
                'numero_articulos' => '',
                'fecha_entrega' => '',
                'estatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['id_orden_compra'] = $r->row()->id_orden_compra;
                $array['fecha'] = $r->row()->fecha;
                $array['folio'] = $r->row()->folio;
                $array['id_proveedor'] = $r->row()->id_proveedor;
                $array['id_almacen'] = $r->row()->id_almacen;
                $array['id_moneda'] = $r->row()->id_moneda;
                $array['importe_neto'] = $r->row()->importe_neto;
                $array['numero_articulos'] = $r->row()->numero_articulos;
                $array['fecha_entrega'] = $r->row()->fecha_entrega;
                $array['estatus'] = $r->row()->estatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }


        function getAllExcelRows(){
            $id = $_SESSION["viv"]['idEmpresa'];
            $query=$this->db->query("
              SELECT `id_orden_compra`,
                    (select nombre from proveedores where id = id_proveedor limit 1),
                     (select nombre from almacenes where id = id_almacen limit 1),
                    `id_moneda`,
                    `fecha`,
                    `folio`,
                    `importe_neto`,
                    `numero_articulos`,
                    `fecha_entrega`,
                    `estatus`
            FROM `recepcion`
            WHERE idEmpresa = $id ORDER BY  id  asc
            ");
             
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function valInsert($id,$idEmpresa){
            $query=$this->db->query("SELECT id FROM recepcion WHERE id=$id AND idEmpresa=$idEmpresa");
            return ($query->num_rows()>0) ? false : true;
        }

        function valUpdate($id,$data){
            $search="";
            foreach ($data as $key => $val) {
                switch ($key) {
                    case 'lista_articulos':
                        break;
                    case 'id':
                        $id=$val;
                        break;
                    default:
                        $search.=' AND '.$key.'="'.$val.'"';
                }
            }
            $query=$this->db->query("SELECT id FROM recepcion WHERE id=$id $search");
            return ($query->num_rows()>0) ? false : true;
        }

        function actualiza($data,$id){
            $idEmpresa=$data["idEmpresa"];
            $data['updated'] = date("Y-m-d H:i:s");
            $this->db->update($this->table, $data," id = $id AND idEmpresa=$idEmpresa ");
            return true;
        }

        function getByIdOrdenProveedorMaterial($idOrden, $idProveedor, $id_articulo){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id_orden_compra' => $idOrden, $this->alias.'.id_proveedor' => $idProveedor, "dr.id_articulo" => $id_articulo);
            $this->db->join('detalle_recepcion dr', $this->alias.'.id = dr.id_recepcion');
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        //Agregar serverside

        // var $table = 'logs';
        var $column_order = array(null, 'id_orden_compra','fecha','folio','id_proveedor','id_almacen','id_moneda','importe_neto','numero_articulos','fecha_entrega','estatus'); //set column field database for datatable orderable
        var $column_search = array('id_orden_compra','fecha','folio','id_proveedor','id_almacen','id_moneda','importe_neto','numero_articulos','fecha_entrega','estatus'); //set column field database for datatable searchable
        var $order = array('id' => 'desc'); // default order

        private function _get_datatables_query()
        {
            $this->db->from($this->table);

            if($_SESSION["viv"]["idEmpresa"] > 0){
                    $id=$_SESSION["viv"]["idEmpresa"];
                    $arrayWhere = array('idEmpresa' => $id);
                    $this->db->where($arrayWhere);

            }

            $i = 0;

            foreach ($this->column_search as $item) // loop column
            {
                if($_POST['search']['value']) // if datatable send POST for search
                {

                    if($i===0) // first loop
                    {
                        $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                        $this->db->like($item, $_POST['search']['value']);
                    }
                    else
                    {
                        $this->db->or_like($item, $_POST['search']['value']);
                    }

                    if(count($this->column_search) - 1 == $i) //last loop
                        $this->db->group_end(); //close bracket
                }
                $i++;
            }

            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }
        
        function get_datatables()
        {
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }                   

        function count_filtered()
        {
            $this->_get_datatables_query();
            $query = $this->db->get();
            return $query->num_rows();
        }

        public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }

    }