<?php

    class mproyecto extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "proyectos";
            $this->alias = 'p';

            $this->alias2 = 'pro';//prospecto
            $this->aliasPro = 'proto';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".numPaquete
            ,".$this->alias.".lote
            ,".$this->alias.".manzana
            ,".$this->alias.".calle
            ,".$this->alias.".nOficial
            ,".$this->alias.".numeroInterior
            ,".$this->alias.".cuv
            ,".$this->alias.".claveCatastral
            ,".$this->alias.".supTerreno
            ,".$this->alias.".supConstruccion
            ,".$this->alias.".precioVenta
            ,".$this->alias.".statusProyecto
            ,".$this->alias.".puntaje
            ,".$this->alias.".porcentajeAvance
            ,".$this->alias.".costoAvance
            ,".$this->alias.".checkAvance
            ,".$this->alias.".contratista
            ,".$this->alias.".avaluo
            ,".$this->alias.".folioAvaluo
            ,".$this->alias.".unidadVerificadora
            ,".$this->alias.".fechaVencimiento
            ,".$this->alias.".fechaDtu
            ,".$this->alias.".statusAlertDTU
            ,".$this->alias.".lineaCredito
            ,".$this->alias.".tipoVialidad
            ,".$this->alias.".nombreVialidad
            ,".$this->alias.".nivel
            ,".$this->alias.".estacionamiento
            ,".$this->alias.".tipoPrimeraVialidad
            ,".$this->alias.".primeraEntreVialidad
            ,".$this->alias.".tipoSegundaVialidad
            ,".$this->alias.".segundaEntreVialidad
            ,".$this->alias.".tipoVialidadPosterior
            ,".$this->alias.".nombreVialidadPosterior
            ,".$this->alias.".metrosFrente
            ,".$this->alias.".orientacion
            ,".$this->alias.".statusVenta
            ,".$this->alias.".statusObra
            ,".$this->alias.".tipoLote
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectDefault2 = "".
                $this->alias.".id
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".numPaquete
            ,"."CONCAT(lote, ' (', manzana, ')') AS titulo
            ,".$this->alias.".manzana
            ,".$this->alias.".statusVenta
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->SelectResult = "".
            $this->alias.".id,"
            ."CONCAT(".$this->alias.".lote, ' Mz:',".$this->alias.".manzana) as titulo";

            // $this->SelectProspect = "".
            // $this->alias2.".id,".
            // ."CONCAT(".$this->alias.".lote, ' Mz:',".$this->alias.".manzana) as titulo";
            $this->selectProspecto = "". //campos de la tabla prospecto
                $this->alias2.".id
            ,".$this->alias2.".idPromotor
            ,".$this->alias2.".nombre
            ,".$this->alias2.".apellidoP
            ,".$this->alias2.".apellidoM
            ,".$this->alias2.".rfc
            ,".$this->alias2.".telefono
            ,".$this->alias2.".fecha
            ,".$this->alias2.".fechaNac
            ,".$this->alias2.".lugarProspeccion
            ,".$this->alias2.".otroLugar
            ,".$this->alias2.".nss
            ,".$this->alias2.".curp
            ,".$this->alias2.".statusProspecto
            ,".$this->alias2.".comentario
            ,".$this->alias2.".prototipo
            ,".$this->alias2.".claveElector
            ,".$this->alias2.".calleProspecto
            ,".$this->alias2.".numeroCasa
            ,".$this->alias2.".codigoPostal
            ,".$this->alias2.".colonia
            ,".$this->alias2.".ciudad
            ,".$this->alias2.".empresaTrabajador";


            $this->selectPrototipo = "".
                $this->aliasPro.".id AS pt_id
            ,".$this->aliasPro.".nombre AS pt_nombre
            ,".$this->aliasPro.".status AS pt_status
            ,IF(".$this->aliasPro.".status > 0,'Activo','Inactivo') AS pt_txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'idPrototipo' => '',
                'numPaquete' => '',
                'lote' => '',
                'manzana' => '',
                'calle' => '',
                'nOficial' => '',
                'numeroInterior' => '',
                'cuv' => '',
                'claveCatastral' => '',
                'supTerreno' => '',
                'supConstruccion' => '',
                'precioVenta' => '',
                'statusProyecto' => '',
                'puntaje' => '',
                'porcentajeAvance' => '',
                'costoAvance' => '',
                'checkAvance' => '',
                'contratista' => '',
                'avaluo' => '',
                'folioAvaluo' => '',
                'unidadVerificadora' => '',
                'fechaVencimiento' =>'',
                'fechaDtu' => '',
                'statusAlertDTU' => '',
                'lineaCredito' => '',
                'tipoVialidad' => '',
                'nombreVialidad' => '',
                'nivel' => '',
                'estacionamiento' => '',
                'tipoPrimeraVialidad' => '',
                'primeraEntreVialidad' => '',
                'tipoSegundaVialidad' => '',
                'segundaEntreVialidad' => '',
                'tipoVialidadPosterior' => '',
                'nombreVialidadPosterior' => '',
                'metrosFrente' => '',
                'orientacion' => '',
                'statusVenta' => '',
                'statusObra' => '',
                'tipoLote' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['numPaquete'] = $r->row()->numPaquete;
                $array['lote'] = $r->row()->lote;
                $array['manzana'] = $r->row()->manzana;
                $array['calle'] = $r->row()->calle;
                $array['nOficial'] = $r->row()->nOficial;
                $array['numeroInterior'] = $r->row()->numeroInterior;
                $array['cuv'] = $r->row()->cuv;
                $array['claveCatastral'] = $r->row()->claveCatastral;
                $array['supTerreno'] = $r->row()->supTerreno;
                $array['supConstruccion'] = $r->row()->supConstruccion;
                $array['precioVenta'] = $r->row()->precioVenta;
                $array['statusProyecto'] = $r->row()->statusProyecto;
                $array['puntaje'] = $r->row()->puntaje;
                $array['porcentajeAvance'] = $r->row()->porcentajeAvance;
                $array['costoAvance'] = $r->row()->costoAvance;
                $array['checkAvance'] = $r->row()->checkAvance;
                $array['contratista'] = $r->row()->contratista;
                $array['avaluo'] = $r->row()->avaluo;
                $array['folioAvaluo'] = $r->row()->folioAvaluo;
                $array['unidadVerificadora'] = $r->row()->unidadVerificadora;
                $array['fechaVencimiento'] = $r->row()->fechaVencimiento;
                $array['fechaDtu'] = $r->row()->fechaDtu;
                $array['statusAlertDTU'] = $r->row()->statusAlertDTU;
                $array['lineaCredito'] = $r->row()->lineaCredito;
                $array['tipoVialidad'] = $r->row()->tipoVialidad;
                $array['nombreVialidad'] = $r->row()->nombreVialidad;
                $array['nivel'] = $r->row()->nivel;
                $array['estacionamiento'] = $r->row()->estacionamiento;
                $array['tipoPrimeraVialidad'] = $r->row()->tipoPrimeraVialidad;
                $array['primeraEntreVialidad'] = $r->row()->primeraEntreVialidad;
                $array['tipoSegundaVialidad'] = $r->row()->tipoSegundaVialidad;
                $array['segundaEntreVialidad'] = $r->row()->segundaEntreVialidad;
                $array['tipoVialidadPosterior'] = $r->row()->tipoVialidadPosterior;
                $array['nombreVialidadPosterior'] = $r->row()->nombreVialidadPosterior;
                $array['metrosFrente'] = $r->row()->metrosFrente;
                $array['orientacion'] = $r->row()->orientacion;
                $array['statusVenta'] = $r->row()->statusVenta;
                $array['statusObra'] = $r->row()->statusObra;
                $array['tipoLote'] = $r->row()->tipoLote;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll($idFraccionamiento=null){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);

            if($_SESSION['viv']['rol'] > 1){
                //$idsfraccionamientosxusuario = $this->mfraccionamientoxusuario->getArrayFraccByIdUsuario($_SESSION['viv']['id']);

                $queryIdFraccionamientos  = $this->db->query('
                    SELECT idFraccionamiento FROM fraccionamientosxusuarios
                    WHERE idUsuario = '.$_SESSION['viv']['id'].'
                ');
                $arrayIdFraccs = array(0=>0);
                if($queryIdFraccionamientos->num_rows()>0){
                    $i=0;
                    foreach ($queryIdFraccionamientos->result() as $f) {
                        # code...
                        $arrayIdFraccs[$i] = $f->idFraccionamiento;
                        $i++;
                    }

                }
                /*echo "<pre>";
                print_r($arrayIdFraccs);
                echo "<pre><br><br><br><br>";*/
                //exit();
                $this->db->where_in('p.idFraccionamiento',$arrayIdFraccs);

            }
            if($idFraccionamiento > 0){
                $this->db->where($this->alias.'.idFraccionamiento=', $idFraccionamiento);
            }
            $this->db->where(" (SELECT status FROM fraccionamientos WHERE id = p.idFraccionamiento) = 1",null,false);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllList(){
            $this->db->select($this->selectDefault,FALSE);
            // $this->db->select($this->selectDefault.",".$this->selectPrototipo,FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias.'.idFraccionamiento' => $_SESSION['viv']['idFraccionamiento']);
            $this->db->where($arrayWhere);
            // $this->db->join("prototipos proto", "proto.id=p.idPrototipo");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        //reporte condiciones de la vivienda inventario o total con estos datos
        function inventarioTecnica($filtros=array(),$formato = '',$total=false){
            $where = '';
            if ($filtros['idPrototipo']!='' && $filtros['idPrototipo']!=0){
                $idPrototipo = $filtros['idPrototipo'];
                $where .= " AND p.idPrototipo = $idPrototipo";
            }
            if ($filtros['statusProyecto']!='' && $filtros['statusProyecto']!=0){
                $statusProyecto = str_replace("%20", " ", $filtros['statusProyecto']);
                $where .= " AND p.statusProyecto = '$statusProyecto'";
            }
            if ($filtros['lineaCredito']!='' && $filtros['lineaCredito']!=0){
                $lineaCredito = $filtros['lineaCredito'];
                $where .= " AND p.lineaCredito = '$lineaCredito'";
            }
            if ($filtros['fraccionamiento']!='' && $filtros['fraccionamiento']!=0){
                $fraccionamiento = $filtros['fraccionamiento'];
                $where .= " AND p.idFraccionamiento = $fraccionamiento";
            }

            $vfrom = $filtros['fecha_inicio'];
            $vto = $filtros['fecha_fin'];

            if ((strlen($vfrom) > 0) && (strlen($vto) == '')) {

                $where .= " AND DATE_FORMAT(p.fechaDtu, '%Y-%m-%d') >= DATE_FORMAT(STR_TO_DATE('" . $vfrom . "','%Y-%m-%d'),'%Y-%m-%d')";
            }

            if ((strlen($vfrom) == '') && (strlen($vto) > 0)) {

                $where .= " AND DATE_FORMAT(P.fechaDtu, '%Y-%m-%d') <= DATE_FORMAT(STR_TO_DATE('" . $vto . "','%Y-%m-%d'),'%Y-%m-%d')";
            }
            if ((strlen($vfrom) > 0) && (strlen($vto) > 0)) {

                $where .= " AND DATE_FORMAT(p.fechaDtu, '%Y-%m-%d') BETWEEN DATE_FORMAT(STR_TO_DATE('" . $vfrom . "','%Y-%m-%d'),'%Y-%m-%d') AND DATE_FORMAT(STR_TO_DATE('" . $vto . "','%Y-%m-%d'),'%Y-%m-%d')";
            }

            $where .= " AND (SELECT status FROM fraccionamientos WHERE id=p.idFraccionamiento)=1";

            if ($formato == 'csv'){
                $this->selectDefault = "
                    p.idFraccionamiento
                    ,(SELECT titulo FROM fraccionamientos WHERE id = idFraccionamiento) AS 'FRACCIONAMIENTO'
                    ,(SELECT titulo FROM prototiposxfraccionamiento WHERE id = idPrototipo) AS 'PROTOTIPO'
                    -- ,p.idPrototipo AS 'PROTOTIPO'
                    ,p.numPaquete AS 'NÚMERO DE PAQUETE'
                    ,p.lote AS 'LOTE'
                    ,p.manzana AS 'MANZANA'
                    ,p.calle AS 'CALLE'
                    ,p.nOficial AS 'NÚMERO OFICIAL'
                    ,p.cuv AS 'CUV'
                    ,p.claveCatastral AS 'CLAVE CATASTRAL'
                    ,p.supTerreno AS 'SUPERFICIE TERRENO'
                    ,p.supConstruccion AS 'SUPERFICIE CONSTRUCCIÓN'
                    ,p.precioVenta AS 'PRECIO VENTA'
                    ,p.statusProyecto AS 'ESTATUS PROYECTO'
                    ,p.puntaje AS 'PUNTAJE'
                    ,p.porcentajeAvance AS 'PORCENTAJE AVANCE'
                    ,p.contratista AS 'CONTRATISTA'
                    ,p.avaluo AS 'AVALUO'
                    ,p.unidadVerificadora AS 'UNIDAD VERIFICADORA'
                    ,p.fechaVencimiento AS 'FECHA DE VENCIMIENTO'
                    ,p.fechaDtu AS 'FECHA DTU'
                    ,p.lineaCredito AS 'LINEA DE CRÉDITO'
            ";
            }

            $query="";
            $id=$_SESSION["viv"]["id"];
            if(!$total){
                if($_SESSION["viv"]["rol"] == 1){
                    $query ="SELECT ".$this->selectDefault." FROM proyectos as p WHERE status=1 "." ".$where;
                }else{
                    $query ="SELECT ".$this->selectDefault." FROM proyectos as p WHERE p.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id) "." ".$where;
                }
            }else{
                if($_SESSION["viv"]["rol"] == 1){
                    $query ="SELECT SUM(precioVenta) AS total FROM proyectos as p WHERE status=1 "." ".$where;
                }else{
                    $query ="SELECT SUM(precioVenta) AS total FROM proyectos as p WHERE p.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id) "." ".$where;
                }
            }
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                if(!$total){
                    return $query;
                }else{
                    $query=$query->row();
                    return "$".number_format($query->total,2);
                }
            }else{
                return 0;
            }
        }


        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getSelectResultForComision(){ // obtenemos todas las viviendas (proyectos que tengan estatus 4, es decir estatus para asignar comision a promotor)
            $query="
                SELECT ".$this->SelectResult."
                    FROM alta_venta AS av, proyectos AS p
                    WHERE av.idProyecto=p.id
                    AND statusVenta = 3
                    AND statusValidacion=4
                    AND av.id NOT IN (SELECT idAltaVenta FROM comisiones_bonos)
                    AND av.status=1"; //statusValidacion=4
            $id=$_SESSION["viv"]["id"];
            if($_SESSION["viv"]["rol"] > 1){
                $query.=" AND p.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
            }
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        //obtenemos todos los proyectos con status disponible
        function getBySelectResult(){
            $this->db->select($this->SelectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.statusVenta' => 0);
            $this->db->where($arrayWhere);
            $this->db->where("p.idFraccionamiento = ".$_SESSION['viv']['idFraccionamiento']);
            //$this->db->join("proyectos p", "p.id=av.idProyecto");
            $this->db->order_by($this->alias.'.id', "asc");
            //$query = $this->db->get('alta_venta AS av');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getBySelectResult2( $id = null ){
            $this->db->select($this->SelectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.statusVenta' => 0);
            $this->db->where($arrayWhere);
            $this->db->where("p.idFraccionamiento = ".$id);
            //$this->db->join("proyectos p", "p.id=av.idProyecto");
            $this->db->order_by($this->alias.'.id', "asc");
            //$query = $this->db->get('alta_venta AS av');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getLast(){
           $arrayWhere = array($this->alias.'.status' => true);
           $this->db->select($this->selectDefault,FALSE);
           $this->db->where($arrayWhere);
           if ($_SESSION['viv']['rol']!=1){
                $id = $_SESSION['viv']['id'];
                $this->db->where("p.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=".$id.")");
           }
           $this->db->order_by($this->alias.'.id','desc');
           $this->db->limit(1);
           $query = $this->db->get($this->table.' AS '.$this->alias);
           if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function _getCSV($idFraccionamiento=null,$curdate=false){
            $id=$_SESSION['viv']['id'];
            $AND = ' WHERE p.idFraccionamiento = '.$idFraccionamiento;($idFraccionamiento!=null and $idFraccionamiento!=0)?' AND p.idFraccionamiento = $idFraccionamiento ':'';

            $AND = ($idFraccionamiento!=null and $idFraccionamiento!=0)?$AND." AND fra.status=1":'WHERE fra.status=1';
            if($curdate == true){
                $AND .= ($AND!='')?' AND DATE(p.created) = CURDATE() AND fra.status=1':' WHERE DATE(p.created) = CURDATE() AND fra.status=1';
            }

            //$AND .= 'fra.status=1 ';
            $query="SELECT
                p.id AS 'ID',
                -- 'FRACCIONAMIENTO' AS 'TIPO DE ASENTAMIENTO',
                (SELECT titulo FROM fraccionamientos WHERE ID=idFraccionamiento) AS 'NOMBRE DE ASENTAMIENTO',
                -- 'URBANA' AS 'TIPO DE ZONA',
                'CIRCUITO' AS 'TIPO DE VIALIDAD1',
                p.nombreVialidad AS 'NOMBRE DE VIALIDAD',
                'NA' AS 'SUPERMANZANA',
                p.manzana AS 'MANZANA',
                p.lote AS 'LOTE',
                p.nOficial AS 'NUM. EXTERIOR',
                -- 'NA' AS 'NÚM. EXTERIOR ALFABETICO',
                -- 'NA' AS 'NÚM. EXTERIOR ANTERIOR',
                -- 'NA' AS 'NÚM. INTERIOR',
                -- 'NA' AS 'NÚM. INTERIOR ALFABÉTICO',
                'CLAVECATASTRAL' AS 'NUMERO CATASTRAL DEL LOTE',

                -- '' AS 'EDIFICIO',
                -- nivel AS 'NIVEL',
                -- estacionamiento AS 'ESTACIONAMIENTO',
                -- tipoVialidad AS 'TIPO DE VIALIDAD2 ',
                -- primeraEntreVialidad AS 'NOMBRE DE LA PRIMERA ENTRE VIALIDAD',
                -- tipoPrimeraVialidad AS 'TIPO DE VIALIDAD3  ',
                -- segundaEntreVialidad AS 'NOMBRE DE LA SEGUNDA ENTRE VIALIDAD',
                -- tipoSegundaVialidad AS 'TIPO DE VIALIDAD4   ',
                -- nombreVialidadPosterior AS 'NOMBRE DE LA VIALIDAD POSTERIOR',
                -- tipoVialidadPosterior AS 'TIPO DE LA VIALIDAD POSTERIOR',
                p.precioVenta AS 'COSTO',
                (SELECT comision FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'COMISION TOTAL',
                (SELECT pago1 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'Al 90%',
                (SELECT imptoPago1 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'IMPUESTOS 9% 1ERA COMISION',
                (SELECT totalPago1 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'TOTAL PAGO 1',
                (SELECT pago2 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'AL 10%',
                (SELECT imptoPago2 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'IMPUESTOS 9% 2DA COMISION',
                (SELECT totalPago2 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'TOTAL PAGO 2',
                av.bonoEquipamiento AS 'BONO EQUIPAMIENTO',
                p.supTerreno AS 'METROS CUADRADOS LOTE',
                p.metrosFrente AS 'METROS FRENTE LOTE',
                p.orientacion AS 'ORIENTACION',
                -- '' AS 'ORIGEN',
                -- '' AS 'DESTINO',
                -- '' AS 'MARGEN',
                -- '' AS 'CADENAMIENTO',
                -- '' AS 'ADMINISTRACIÓN',
                -- '' AS 'DERECHO DE TRÁNSITO',
                -- '' AS 'CÓDIGO DE CARRETERA',
                p.lineaCredito AS 'LINEA DE CREDITO',
                -- p.folioAvaluo AS 'AVALUO FOLIO',
                (SELECT titulo FROM folios_avaluo WHERE id = folioAvaluo) AS 'AVALUO FOLIO',
                g.ronda AS 'RONDA',
                DATE_FORMAT(av.created,'%d/%m/%Y') AS 'FECHA ALTA DE VENTA',
                av.fechaApartado AS 'FECHA APARTADO',
                av.fechaProceso AS 'FECHA PROCESO',
                g.fechaIngreso AS 'FECHA INSCRIPCION',
                g.fechaFirma AS 'FECHA FIRMA',                
                av.fechaVenta AS 'FECHA DETONACION',
                DATEDIFF(av.fechaVenta,av.created) AS 'DIAS',
                (SELECT nombre FROM prototipos WHERE id=idPrototipo) AS 'PROTOTIPO',
                p.porcentajeAvance AS '% AVANCE',
                CASE p.statusVenta
                    WHEN 0 THEN 'DISPONIBLE'
                    WHEN 1 THEN 'APARTADO'
                    WHEN 2 THEN 'PROCESO'
                    WHEN 3 THEN 'VENDIDA'
                    END AS 'ESTATUS',
                (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM prospectos WHERE id = av.idProspecto) AS 'NOMBRE CLIENTE',
                (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id = av.idProspecto)) AS 'NOMBRE PROMOTOR',
                (SELECT UPPER(tipoPromotor) FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id = av.idProspecto)) AS 'TIPO PROMOTOR',

                -- (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id = av.created_by) AS 'NOMBRE PROMOTOR',
                p.cuv AS 'CUV',
                (SELECT puntaje FROM prospectos WHERE id = idProspecto) AS 'PUNTAJE'
                FROM proyectos AS p
                LEFT JOIN alta_venta av ON p.id = av.idProyecto
                LEFT JOIN gestoria g ON av.id = g.idAltaVenta
                LEFT JOIN fraccionamientos fra ON fra.id = p.idFraccionamiento 

                ".$AND."
                GROUP BY p.id
                ";
                //$query.=($_SESSION["viv"]["rol"]!=1) ? " WHERE idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id);" : ";";
                $query=$this->db->query($query);
            return $query;
        }

        function getCSV($idFraccionamiento=null,$curdate=false){
            $id=$_SESSION['viv']['id'];

            //subqueries
            $altaVenta="(SELECT %field FROM alta_venta av WHERE p.id=av.idProyecto AND status=1 ORDER BY id DESC LIMIT 1)";
            $idAltaVenta=str_replace('%field','id',$altaVenta);
            $bonoEquipamiento=str_replace('%field','bonoEquipamiento',$altaVenta);
            $created=str_replace('%field','created',$altaVenta);
            $fechaApartado=str_replace('%field','fechaApartado',$altaVenta);
            $fechaProceso=str_replace('%field','fechaProceso',$altaVenta);
            $fechaProceso=str_replace('%field','fechaProceso',$altaVenta);
            $fechaVenta=str_replace('%field','fechaVenta',$altaVenta);
            $idProspecto=str_replace('%field','idProspecto',$altaVenta);

            $gestoria="(SELECT %field FROM gestoria ge WHERE ge.idAltaVenta=$idAltaVenta AND status=1 ORDER BY id DESC LIMIT 1)";
            $ronda=str_replace('%field','ronda',$gestoria);
            $fechaIngreso=str_replace('%field','fechaIngreso',$gestoria);
            $fechaFirma=str_replace('%field','fechaFirma',$gestoria);
            //Filtros
            $estatus="(SELECT status FROM fraccionamientos fr WHERE fr.id=p.idFraccionamiento)";
            $AND = " WHERE p.idFraccionamiento = ".$idFraccionamiento;($idFraccionamiento!=null and $idFraccionamiento!=0)?" AND p.idFraccionamiento = $idFraccionamiento ":"";

            $AND = ($idFraccionamiento!=null and $idFraccionamiento!=0)?$AND." AND $estatus=1":"WHERE $estatus=1";
            if($curdate == true){
                $AND .= ($AND!='')?' AND DATE(p.created) = CURDATE() AND $estatus=1':' WHERE DATE(p.created) = CURDATE() AND $estatus=1';
            }

            $query="SELECT
                p.id,
                (SELECT titulo FROM fraccionamientos WHERE id=idFraccionamiento) AS 'asentamiento',
                'CIRCUITO' AS 'tVialidad1',
                p.nombreVialidad AS 'nombreVialidad',
                'NA' AS 'supermanzana',
                p.manzana AS 'manzana',
                p.lote AS 'lote',
                p.nOficial AS 'numExterior',
                'CLAVECATASTRAL' AS 'claveCatastral',
                p.precioVenta AS 'costo',
                (SELECT comision FROM comisiones co WHERE $idAltaVenta = co.idAltaVenta) AS 'comisionTotal',
                (SELECT pago1 FROM comisiones co WHERE $idAltaVenta = co.idAltaVenta) AS 'al90',
                (SELECT imptoPago1 FROM comisiones co WHERE $idAltaVenta = co.idAltaVenta) AS 'impuestosComision1',
                (SELECT totalPago1 FROM comisiones co WHERE $idAltaVenta = co.idAltaVenta) AS 'totalPago1',
                (SELECT pago2 FROM comisiones co WHERE $idAltaVenta = co.idAltaVenta) AS 'al10',
                (SELECT imptoPago2 FROM comisiones co WHERE $idAltaVenta = co.idAltaVenta) AS 'impuestosComision2',
                (SELECT totalPago2 FROM comisiones co WHERE $idAltaVenta = co.idAltaVenta) AS 'totalPago2',
                $bonoEquipamiento AS 'bonoEquipamiento',
                p.supTerreno AS 'supTerreno',
                p.metrosFrente AS 'metrosFrente',
                p.orientacion AS 'orientacion',
                p.lineaCredito AS 'lineaCredito',
                (SELECT titulo FROM folios_avaluo fa WHERE fa.id = p.folioAvaluo) AS 'avaluo',
                $ronda AS 'ronda',
                DATE_FORMAT($created,'%d/%m/%Y') AS 'fechaAv',
                $fechaApartado AS 'fechaApartado',
                $fechaProceso AS 'fechaProceso',
                $fechaIngreso AS 'fechaInscripcion',
                $fechaFirma AS 'fechaFirma',                
                $fechaVenta AS 'fechaDetonacion',
                DATEDIFF($fechaVenta,$created) AS 'dias',
                (SELECT nombre FROM prototipos WHERE id=p.idPrototipo) AS 'prototipo',
                p.porcentajeAvance AS 'avance',
                CASE p.statusVenta
                    WHEN 0 THEN 'DISPONIBLE'
                    WHEN 1 THEN 'APARTADO'
                    WHEN 2 THEN 'PROCESO'
                    WHEN 3 THEN 'VENDIDA'
                    END AS 'estatus',
                (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM prospectos WHERE id = $idProspecto) AS 'nombreCliente',
                (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id = $idProspecto)) AS 'nombrePromotor',
                (SELECT UPPER(tipoPromotor) FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id = $idProspecto)) AS 'tipoPromotor',
                p.cuv AS 'cuv',
                (SELECT puntaje FROM prospectos WHERE id = $idProspecto) AS 'puntaje'
                FROM proyectos AS p
                $AND
                ";
                $query=$this->db->query($query);
            return $query;
        }

        function getCSV2($idFraccionamiento=null,$curdate=false){
            $id=$_SESSION['viv']['id'];
            $AND = ' WHERE p.idFraccionamiento = '.$idFraccionamiento;($idFraccionamiento!=null and $idFraccionamiento!=0)?' AND p.idFraccionamiento = $idFraccionamiento ':'';

            $AND = ($idFraccionamiento!=null and $idFraccionamiento!=0)?$AND." AND fra.status=1":'WHERE fra.status=1';
            if($curdate == true){
                $AND .= ($AND!='')?' AND DATE(p.created) = CURDATE() AND fra.status=1':' WHERE DATE(p.created) = CURDATE() AND fra.status=1';
            }

            //$AND .= 'fra.status=1 ';
            $query="SELECT
                p.id,
                -- 'FRACCIONAMIENTO' AS 'TIPO DE ASENTAMIENTO',
                (SELECT titulo FROM fraccionamientos WHERE ID=idFraccionamiento) AS 'asentamiento',
                -- 'URBANA' AS 'TIPO DE ZONA',
                'CIRCUITO' AS 'tVialidad1',
                p.nombreVialidad AS 'nombreVialidad',
                'NA' AS 'supermanzana',
                p.manzana AS 'manzana',
                p.lote AS 'lote',
                p.nOficial AS 'numExterior',
                'CLAVECATASTRAL' AS 'claveCatastral',
                p.precioVenta AS 'costo',
                (SELECT comision FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'comisionTotal',
                (SELECT pago1 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'al90',
                (SELECT imptoPago1 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'impuestosComision1',
                (SELECT totalPago1 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'totalPago1',
                (SELECT pago2 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'al10',
                (SELECT imptoPago2 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'impuestosComision2',
                (SELECT totalPago2 FROM comisiones WHERE av.id = comisiones.idAltaVenta) AS 'totalPago2',
                av.bonoEquipamiento AS 'bonoEquipamiento',
                p.supTerreno AS 'supTerreno',
                p.metrosFrente AS 'metrosFrente',
                p.orientacion AS 'orientacion',
                -- '' AS 'ORIGEN',
                -- '' AS 'DESTINO',
                -- '' AS 'MARGEN',
                -- '' AS 'CADENAMIENTO',
                -- '' AS 'ADMINISTRACIÓN',
                -- '' AS 'DERECHO DE TRÁNSITO',
                -- '' AS 'CÓDIGO DE CARRETERA',
                p.lineaCredito AS 'lineaCredito',
                -- p.folioAvaluo AS 'AVALUO FOLIO',
                (SELECT titulo FROM folios_avaluo WHERE id = folioAvaluo) AS 'avaluo',
                g.ronda AS 'ronda',
                DATE_FORMAT(av.created,'%d/%m/%Y') AS 'fechaAv',
                av.fechaApartado AS 'fechaApartado',
                av.fechaProceso AS 'fechaProceso',
                g.fechaIngreso AS 'fechaInscripcion',
                g.fechaFirma AS 'fechaFirma',                
                av.fechaVenta AS 'fechaDetonacion',
                DATEDIFF(av.fechaVenta,av.created) AS 'dias',
                (SELECT nombre FROM prototipos WHERE id=idPrototipo) AS 'prototipo',
                p.porcentajeAvance AS 'avance',
                CASE p.statusVenta
                    WHEN 0 THEN 'DISPONIBLE'
                    WHEN 1 THEN 'APARTADO'
                    WHEN 2 THEN 'PROCESO'
                    WHEN 3 THEN 'VENDIDA'
                    END AS 'estatus',
                (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM prospectos WHERE id = av.idProspecto) AS 'nombreCliente',
                (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id = av.idProspecto)) AS 'nombrePromotor',
                (SELECT UPPER(tipoPromotor) FROM usuarios WHERE id = (SELECT idPromotor FROM prospectos WHERE id = av.idProspecto)) AS 'tipoPromotor',

                -- (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id = av.created_by) AS 'NOMBRE PROMOTOR',
                p.cuv AS 'cuv',
                (SELECT puntaje FROM prospectos WHERE id = idProspecto) AS 'puntaje'
                FROM proyectos AS p
                LEFT JOIN alta_venta av ON p.id = av.idProyecto
                LEFT JOIN gestoria g ON av.id = g.idAltaVenta
                LEFT JOIN fraccionamientos fra ON fra.id = p.idFraccionamiento 

                ".$AND."
                GROUP BY p.id
                ";
                //$query.=($_SESSION["viv"]["rol"]!=1) ? " WHERE idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id);" : ";";
                $query=$this->db->query($query);
            return $query;
        }

        function insertBatchRegistros($registros){
            if (is_array($registros)){
                $this->db->insert_batch($this->table, $registros);
            }
        }


        //reporte  de proyectos en estatus de disponible, apartado, proceso, detonado
        // function inventarioTecnica($filtros=array(),$formato = ''){
        function inventarioGerente($filtros = array()){
            $where = '';
            $join = 'LEFT JOIN alta_venta av ON p.id = av.idProyecto';
            // $selectPlus = ',av.id ,av.idProspecto';
            if ($filtros['idPrototipo']!=''){
                $idPrototipo = $filtros['idPrototipo'];
                $where .= " AND p.idPrototipo = $idPrototipo";
            }
            if ($filtros['statusProyecto']!=''){
                $statusProyecto = $filtros['statusProyecto'];
                // $where .= " AND p.statusProyecto = '$statusProyecto'";
                if ( $statusProyecto == 1 ) {
                    $where .= " AND p.statusVenta = '0'"; // Proyecto disponible
                }
                if ( $statusProyecto == 2 ) {
                    $where .= " AND p.statusVenta = '1'"; // Proyecto apartado
                }
                if ( $statusProyecto == 3 ) {
                    $where .= " AND p.statusVenta = '2'"; // Proyecto en proceso de compra
                }
                if ( $statusProyecto == 4 ) {
                    $where .= " AND p.statusVenta = '3'"; // Proyecto detonado (Vendido)
                }
            }
            if ($filtros['lineaCredito']!=''){
                $lineaCredito = $filtros['lineaCredito'];
                $where .= " AND p.lineaCredito = '$lineaCredito'";
            }
            if ($filtros['promotor']!=''){
                $promotor = $filtros['promotor'];
                $join .= "INNER JOIN alta_venta av ON p.id = av.idProyecto";
                $where .= " AND av.created_by = '$promotor'";
            }

            $vfrom = $filtros['fecha_inicio'];
            $vto = $filtros['fecha_fin'];

            if ((strlen($vfrom) > 0) && (strlen($vto) == '')) {

                $where .= " AND DATE_FORMAT(p.fechaDtu, '%Y-%m-%d') >= DATE_FORMAT(STR_TO_DATE('" . $vfrom . "','%Y-%m-%d'),'%Y-%m-%d')";
            }

            if ((strlen($vfrom) == '') && (strlen($vto) > 0)) {

                $where .= " AND DATE_FORMAT(P.fechaDtu, '%Y-%m-%d') <= DATE_FORMAT(STR_TO_DATE('" . $vto . "','%Y-%m-%d'),'%Y-%m-%d')";
            }
            if ((strlen($vfrom) > 0) && (strlen($vto) > 0)) {

                $where .= " AND DATE_FORMAT(p.fechaDtu, '%Y-%m-%d') BETWEEN DATE_FORMAT(STR_TO_DATE('" . $vfrom . "','%Y-%m-%d'),'%Y-%m-%d') AND DATE_FORMAT(STR_TO_DATE('" . $vto . "','%Y-%m-%d'),'%Y-%m-%d')";
            }
            /*if ($formato == 'csv'){
                $this->selectDefault = "
                    -- p.idFraccionamiento AS 'FRACCIONAMIENTO'
                    (SELECT titulo FROM fraccionamientos WHERE id = idFraccionamiento) AS 'FRACCIONAMIENTO'
                    ,(SELECT titulo FROM prototiposxfraccionamiento WHERE id = idPrototipo) AS 'PROTOTIPO'
                    -- ,p.idPrototipo AS 'PROTOTIPO'
                    ,p.numPaquete AS 'NÚMERO DE PAQUETE'
                    ,p.lote AS 'LOTE'
                    ,p.manzana AS 'MANZANA'
                    ,p.calle AS 'CALLE'
                    ,p.nOficial AS 'NÚMERO OFICIAL'
                    ,p.cuv AS 'CUV'
                    ,p.claveCatastral AS 'CLAVE CATASTRAL'
                    ,p.supTerreno AS 'SUPERFICIE TERRENO'
                    ,p.supConstruccion AS 'SUPERFICIE CONSTRUCCIÓN'
                    ,p.precioVenta AS 'PRECIO VENTA'
                    ,p.statusProyecto AS 'ESTATUS PROYECTO'
                    ,p.puntaje AS 'PUNTAJE'
                    ,p.porcentajeAvance AS 'PORCENTAJE AVANCE'
                    ,p.contratista AS 'CONTRATISTA'
                    ,p.avaluo AS 'AVALUO'
                    ,p.unidadVerificadora AS 'UNIDAD VERIFICADORA'
                    ,p.fechaVencimiento AS 'FECHA DE VENCIMIENTO'
                    ,p.fechaDtu AS 'FECHA DTU'
                    ,p.lineaCredito AS 'LINEA DE CRÉDITO'
            ";
            }           */
            $query = $this->db->query("
                    SELECT ".$this->selectDefault."
                            ,av.id
                            ,av.idProspecto
                    FROM proyectos as p
                    ".$join."
                    WHERE p.idFraccionamiento = ".$_SESSION['viv']['idFraccionamiento']."
                    ".$where."

                ");
            if( $query->num_rows() > 0 ){
                return $query;
            }
            return 0;
        }


        function getAllProjects(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllProjectExistAltaVenta($filter = array()) {
            $id=$_SESSION['viv']['id'];
            $this->db->select($this->selectDefault.", av.idProspecto",FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            //$this->db->where("p.idFraccionamiento = ".$_SESSION['viv']['idFraccionamiento']);
            if ($_SESSION['viv']['rol'] > 1){
                $this->db->where("p.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=".$id.")");
            }
            if( $filter['idCliente'] != '' && $filter['idCliente'] > 0 ) {
                $idCliente = $filter['idCliente'];
                $this->db->where('av.idProspecto', $idCliente);
            }
            if( $filter['nsscliente'] != '' && $filter['nsscliente'] > 0 ) {
                $nsscliente = $filter['nsscliente'];
                $this->db->where('av.idProspecto', $nsscliente);
            }
            $this->db->join("alta_venta av", "p.id = av.idProyecto");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getComisiones($info, $csv=false, $total=false) {
            $id=$_SESSION['viv']['id'];
            $info=explode("_", $info);
            $tipoPromotor=$info[0];
            $promotor=$info[1];
            $fecha_inicio=$info[2];
            $fecha_fin=$info[3];

            if(!$csv){
                $fields="
                    p.idFraccionamiento,
                    (SELECT CONCAT(nombre,' ',apellidoP) FROM usuarios WHERE id=idPromotor) AS 'idPromotor',
                    p.lote,
                    p.manzana,
                    p.calle,
                    p.nOficial,
                    av.fechaVenta AS 'fechaVenta',
                    u.tipoPromotor,
                    cb.cierre,
                    u.comision,
                    cb.importeComision,
                    p.id AS 'idVivienda'
                    ";
            }else{
                $fields="
                    p.idFraccionamiento,
                    (SELECT CONCAT(nombre,' ',apellidoP) FROM usuarios WHERE id=idPromotor) AS 'Promotor',
                    p.lote AS 'Lote',
                    p.manzana AS 'MZA',
                    p.calle AS 'Calle',
                    p.nOficial AS 'N° Oficial',
                    av.fechaVenta AS 'Fecha Venta',
                    u.tipoPromotor AS 'Tipo de Promotor',
                    cb.cierre AS 'Cierre',
                    u.comision AS '% de Comisión',
                    cb.importeComision AS 'Importe de Comisión'
                    ";
            }
            if($total){
                $fields=" SUM(cb.importeComision) AS total ";
            }

            $query="SELECT $fields FROM proyectos AS p ,alta_venta AS av, prospectos AS pr, comisiones_bonos AS cb, usuarios AS u WHERE
            p.id=av.idProyecto AND pr.id=av.idProspecto AND idAltaVenta=av.id AND idPromotor=u.id"; //AND pr.idFraccionamiento=".$_SESSION["viv"]["idFraccionamiento"]

            if ($_SESSION['viv']['rol']!=1){
                $query.=' AND p.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario='.$id.')';
            }

            if($tipoPromotor != "" && $tipoPromotor != 0 && $tipoPromotor != null){
                $query.=" AND u.tipoPromotor='$tipoPromotor' ";
            }
            if($promotor != "" && $tipoPromotor != 0 && $promotor != null){
                $query.=" AND pr.idPromotor=$promotor ";
            }
            if(($fecha_inicio != '' && $fecha_inicio !=  null) && ($fecha_fin != '' && $fecha_fin !=  null)){
                $fecha_inicio=new DateTime($info[2]);
                $fecha_inicio=$fecha_inicio->format("Y-m-d");
                $fecha_fin=new DateTime($info[3]);
                $fecha_fin=$fecha_fin->format("Y-m-d");
               $query .= " AND av.fechaVenta BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE) ";
            }

            $query=$this->db->query($query);
            if($query->num_rows() > 0){
                if(!$total){
                    return $query;
                }else{
                    $query=$query->row();
                    return "$".number_format($query->total,2);
                }
            }else{
                return 0;
            }
        }

        function getDisponible($info, $csv=false, $total=false) {
            $info=explode("_", $info);
            $estatus_vivienda=$info[0];
            $promotor=$info[1];
            $fecha_inicio=$info[2];
            $fecha_fin=$info[3];
            $fraccionamiento=$info[4];

            if(!$csv){
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=p.idFraccionamiento) AS 'fraccionamiento',
                    '' AS 'idPromotor',
                    '' AS 'cliente',
                    p.lote,
                    p.manzana,
                    p.calle,
                    p.nOficial,
                    p.idPrototipo,
                    '' AS 'fecha',
                    p.precioVenta,
                    CASE p.statusVenta
                    WHEN 0 THEN 'Disponible'
                    WHEN 1 THEN 'Apartado/Interesado'
                    WHEN 2 THEN 'Proceso/En trámite'
                    WHEN 3 THEN 'Vendida'
                    END AS 'statusVenta',
                    p.statusProyecto,
                    p.id AS 'idVivienda'";
            }else{
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=p.idFraccionamiento) AS 'FRACCIONAMIENTO',
                    '' AS 'PROMOTOR',
                    '' AS 'CLIENTE',
                    p.lote AS 'LOTE',
                    p.manzana AS 'MZA',
                    p.calle AS 'CALLE',
                    p.nOficial AS 'N° OFICIAL',
                    p.idPrototipo AS 'PROTOTIPO',
                    '' AS 'FECHA',
                    p.precioVenta AS 'PRECIO VENTA',
                    CASE p.statusVenta
                    WHEN 0 THEN 'Disponible'
                    WHEN 1 THEN 'Apartado/Interesado'
                    WHEN 2 THEN 'Proceso/En trámite'
                    WHEN 3 THEN 'Vendida'
                    END AS 'ESTATUS VENTA',
                    p.statusProyecto AS 'ESTATUS DTU'";
            }

            if($total){
                $fields=" SUM(p.precioVenta) AS total ";
            }

            $query="SELECT $fields FROM proyectos AS p WHERE status=1 ";
            if($estatus_vivienda != "" && $estatus_vivienda != null){
                $query.=" AND p.statusVenta=$estatus_vivienda ";
            }
/*            if($promotor != "" && $promotor != null){
                $query.=" AND pr.idPromotor=$promotor ";
            }*/
/*            if(($fecha_inicio != '' && $fecha_inicio !=  null) && ($fecha_fin != '' && $fecha_fin !=  null)){
                $fecha_inicio=new DateTime($info[2]);
                $fecha_inicio=$fecha_inicio->format("Y-m-d");
                $fecha_fin=new DateTime($info[3]);
                $fecha_fin=$fecha_fin->format("Y-m-d");
               $query .= " AND pr.fecha BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE) ";
            }*/
            if($fraccionamiento != "" && $fraccionamiento != 0 && $fraccionamiento != null){
                $query.=" AND p.idFraccionamiento=$fraccionamiento ";
            }

            $query=$this->db->query($query);
            if($query->num_rows() > 0){
                if(!$total){
                    return $query;
                }else{
                    $query=$query->row();
                    return "$".number_format($query->total,2);
                }
            }else{
                return 0;
            }
        }

        function getProspeccion($info, $csv=false, $total=false) {
            $info=explode("_", $info);
            $promotor=$info[1];
            $fecha_inicio=$info[2];
            $fecha_fin=$info[3];
            $fraccionamiento=$info[4];

            if(!$csv){
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=pr.idFraccionamiento) AS 'fraccionamiento',
                    (SELECT CONCAT(nombre,' ',apellidoP) AS nombre FROM usuarios WHERE id=idPromotor) AS 'idPromotor',
                    CONCAT(pr.nombre,' ',pr.apellidoP) AS 'cliente',
                    '' AS 'lote',
                    '' AS 'manzana',
                    '' AS 'calle',
                    '' AS 'nOficial',
                    '' AS 'idPrototipo',
                    pr.fecha AS 'fecha',
                    '' AS 'precioVenta',
                    '' AS 'statusVenta',
                    '' AS 'statusProyecto',
                    '' AS 'idVivienda'";
            }else{
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=pr.idFraccionamiento) AS 'FRACCIONAMIENTO',
                    (SELECT CONCAT(nombre,' ',apellidoP) FROM usuarios WHERE id=idPromotor) AS 'PROMOTOR',
                    CONCAT(pr.nombre,' ',pr.apellidoP) AS 'CLIENTE',
                    pr.rfc AS 'RFC',
                    pr.nss AS 'NSS',
                    pr.telefono AS 'TELÉFONO',
                    DATE_FORMAT(pr.fechaNac,'%d/%m/%Y') AS 'FECHA DE NACIMIENTO',
                    pr.lugarProspeccion AS 'LUGAR DE PROSPECCIÓN',
                    pr.comentario AS 'COMENTARIO',
                    '' AS 'LOTE',
                    '' AS 'MZA',
                    '' AS 'CALLE',
                    '' AS 'N° OFICIAL',
                    '' AS 'PROTOTIPO',
                    pr.fecha AS 'FECHA PROSPECCIÓN',
                    '' AS 'PRECIO VENTA',
                    '' AS 'ESTATUS VENTA',
                    '' AS 'ESTATUS DTU'";
            }
            $query="SELECT $fields FROM prospectos AS pr WHERE pr.id NOT IN (SELECT idProspecto FROM alta_venta) ";
            if($promotor != "" && $promotor != null){
                $query.=" AND pr.idPromotor=$promotor ";
            }
            if(($fecha_inicio != '' && $fecha_inicio !=  null) && ($fecha_fin != '' && $fecha_fin !=  null)){
                $fecha_inicio=new DateTime($info[2]);
                $fecha_inicio=$fecha_inicio->format("Y-m-d");
                $fecha_fin=new DateTime($info[3]);
                $fecha_fin=$fecha_fin->format("Y-m-d");
               $query .= " AND pr.fecha BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE) ";
            }
            if($fraccionamiento != "" && $fraccionamiento != 0 && $fraccionamiento != null){
                $query.=" AND pr.idFraccionamiento=$fraccionamiento ";
            }

            $query=$this->db->query($query);
            if($query->num_rows() > 0){
                if(!$total){
                    return $query;
                }else{
                    $query=0;
                    return "$".number_format($query,2);
                }
            }else{
                return 0;
            }
        }

        function getColocacion($info, $csv=false, $total=false) {
            $info=explode("_", $info);
            $estatus_vivienda=$info[0];
            $promotor=$info[1];
            $fecha_inicio=$info[2];
            $fecha_fin=$info[3];
            $fraccionamiento=$info[4];
            $area=$info[5];

            if(!$csv){
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=p.idFraccionamiento) AS 'fraccionamiento',
                    (SELECT CONCAT(nombre,' ',apellidoP,' ',apellidoM) AS nombre FROM usuarios WHERE id=idPromotor) AS 'idPromotor',
                    CONCAT(pr.nombre,' ',pr.apellidoP,' ',pr.apellidoM) AS 'cliente',
                    pr.nss,
                    pr.telefono,
                    (SELECT titulo FROM lugares_prospeccion WHERE id=pr.idLugar) AS 'idLugar',
                    p.lote,
                    p.manzana,
                    p.calle,
                    p.nOficial,
                    (SELECT nombre FROM prototipos WHERE id=p.idPrototipo) idPrototipo,
                    pr.fecha AS 'fechaProspeccion',
                    av.created AS 'fechaAltaVenta',
                    av.fechaValidacion,
                    av.fechaVenta,
                    (SELECT created FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) AS 'fechaGestoria',
                    (SELECT fechaEntrega FROM entrega WHERE idAltaVenta=av.id LIMIT 1) AS 'fechaEntregaVivienda',
                    p.precioVenta,
                    CASE p.statusVenta WHEN 0 THEN 'Disponible' WHEN 1 THEN 'Apartado/Interesado' WHEN 2 THEN 'Proceso/En trámite' WHEN 3 THEN 'Vendida' END AS 'statusVivienda',
                    p.statusProyecto AS 'statusDtu',
                    av.statusValidacion2 AS 'estatus'";
            }else{
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=p.idFraccionamiento) AS 'FRACCIONAMIENTO',
                    (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) AS nombre FROM usuarios WHERE id=idPromotor) AS 'PROMOTOR',
                    UPPER(CONCAT(pr.nombre,' ',pr.apellidoP,' ',pr.apellidoM)) AS 'CLIENTE',
                    pr.nss AS 'NSS',
                    pr.telefono AS 'TELEFONO',
                    (SELECT UPPER(titulo) FROM lugares_prospeccion WHERE id=pr.idLugar) AS 'LUGAR PROSPECCION',
                    p.lote AS 'LOTE',
                    p.manzana AS 'MANZANA',
                    (SELECT ronda FROM gestoria WHERE idAltaVenta=av.id) AS 'RONDA',
                    p.calle AS 'CALLE',
                    p.nOficial AS 'N OFICIAL',
                    (SELECT nombre FROM prototipos WHERE id=p.idPrototipo) AS 'PROTOTIPO',
                    pr.fecha AS 'FECHA PROSPECCION',
                    DATE(av.created) AS 'FECHA ALTA VENTA',
                    DATE(av.fechaValidacion) AS 'FECHA GESTORIA',
                    (SELECT fechaIngreso FROM gestoria WHERE idAltaVenta=av.id) AS 'FECHA INSCRIPCION',
                    (SELECT fechaFirma FROM gestoria WHERE idAltaVenta=av.id) AS 'FECHA FIRMA',
                    (SELECT DATE(created) FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) AS 'FECHA DETONADO',
                    (SELECT fechaEntrega FROM entrega WHERE idAltaVenta=av.id LIMIT 1) AS 'FECHA ENTREGA VIVIENDA',
                    (SELECT (montoOci + subCuenta) FROM gestoria WHERE idAltaVenta=av.id) AS 'MONTO CREDITO',
                    p.precioVenta AS 'PRECIO VENTA',
                    UPPER(av.tipoCredito) AS 'TIPO CREDITO',
                    CASE UPPER(p.statusVenta ) WHEN 0 THEN 'DISPONIBLE' WHEN 1 THEN 'APARTADO/INTERESADO' WHEN 2 THEN 'PROCESO/EN TRÁMITE' WHEN 3 THEN 'VENDIDA' END AS 'ESTATUS VIVIENDA',
                    UPPER(p.statusProyecto) AS 'ESTATUS PROYECTO',
                    UPPER(av.statusValidacion2) AS 'ESTATUS',
                    (SELECT UPPER(statusGestoria) FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) AS 'ESTATUS TITULACION'";
            }

            if($total){
                $fields=" SUM(p.precioVenta) AS total ";
            }

            $query="SELECT $fields FROM proyectos AS p ,alta_venta AS av, prospectos AS pr WHERE p.id=av.idProyecto AND pr.id=av.idProspecto AND (SELECT status FROM fraccionamientos WHERE id=pr.idFraccionamiento)=1 ";

            if($estatus_vivienda != "0"){
                $estatus_vivienda=str_replace('-', ' ', $estatus_vivienda);
                $estatus_vivienda=explode('.', $estatus_vivienda);
                for ($i=0; $i < COUNT($estatus_vivienda); $i++) {
                    if($i==0){
                        $query.=" AND (av.statusValidacion2 LIKE '%".$estatus_vivienda[$i]."%'";
                    }else{
                        $query.=" OR av.statusValidacion2 LIKE '%".$estatus_vivienda[$i]."%'";
                    }
                    if($i==COUNT($estatus_vivienda) - 1){
                        $query.=" )";
                    }
                }
            }
            if($promotor != "" && $promotor != 0 && $promotor != null){
                $query.=" AND pr.idPromotor=$promotor ";
            }
            if(($fecha_inicio != '' && $fecha_inicio !=  null) && ($fecha_fin != '' && $fecha_fin !=  null)){
                $fecha_inicio=new DateTime($info[2]);
                $fecha_inicio=$fecha_inicio->format("Y-m-d");
                $fecha_fin=new DateTime($info[3]);
                $fecha_fin=$fecha_fin->format("Y-m-d");
               $query .= " AND fechaApartado BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE) ";
            }
            if($fraccionamiento != "" && $fraccionamiento != 0 && $fraccionamiento != null){
                $query.=" AND p.idFraccionamiento=$fraccionamiento ";
            }

            //validamos si se trata de calcular total validamos con group by
            if ($total && $estatus_vivienda == ''){
                $query .= " GROUP BY pr.id ";
            }

            $query=$this->db->query($query);

            if($query->num_rows() > 0){
                if(!$total){
                    return $query;
                }else{
                    $query=$query->row();
                    return "$".number_format($query->total,2);
                }
            }else{
                return 0;
            }
        }

        function getColocacion2($info, $csv=false, $total=false) {
            $info=explode("_", $info);
            $estatus_vivienda=$info[0];
            $promotor=$info[1];
            $fecha_inicio=$info[2];
            $fecha_fin=$info[3];
            $fraccionamiento=$info[4];
            $area=$info[5];

            if(!$csv){
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=p.idFraccionamiento) AS 'fraccionamiento',
                    (SELECT CONCAT(nombre,' ',apellidoP,' ',apellidoM) AS nombre FROM usuarios WHERE id=idPromotor) AS 'idPromotor',
                    CONCAT(pr.nombre,' ',pr.apellidoP,' ',pr.apellidoM) AS 'cliente',
                    pr.nss,
                    pr.telefono,
                    (SELECT titulo FROM lugares_prospeccion WHERE id=pr.idLugar) AS 'idLugar',
                    p.lote,
                    p.manzana,
                    p.calle,
                    p.nOficial,
                    (SELECT nombre FROM prototipos WHERE id=p.idPrototipo) idPrototipo,
                    pr.fecha AS 'fechaProspeccion',
                    av.created AS 'fechaAltaVenta',
                    av.fechaValidacion,
                    (SELECT created FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) AS 'fechaGestoria',
                    av.fechaVenta,
                    (SELECT fechaEntrega FROM entrega WHERE idAltaVenta=av.id LIMIT 1) AS 'fechaEntregaVivienda',
                    p.precioVenta,
                    CASE p.statusVenta WHEN 0 THEN 'Disponible' WHEN 1 THEN 'Apartado/Interesado' WHEN 2 THEN 'Proceso/En trámite' WHEN 3 THEN 'Vendida' END AS 'statusVivienda',
                    p.statusProyecto AS 'statusDtu',
                    (SELECT statusGestoria FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) AS 'estatus'";
            }else{
                $fields="
                    (SELECT titulo FROM fraccionamientos WHERE id=p.idFraccionamiento) AS 'FRACCIONAMIENTO',
                    (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) AS nombre FROM usuarios WHERE id=idPromotor) AS 'PROMOTOR',
                    UPPER(CONCAT(pr.nombre,' ',pr.apellidoP,' ',pr.apellidoM)) AS 'CLIENTE',
                    pr.nss AS 'NSS',
                    pr.telefono AS 'TELEFONO',
                    (SELECT UPPER(titulo) FROM lugares_prospeccion WHERE id=pr.idLugar) AS 'LUGAR PROSPECCION',
                    p.lote AS 'LOTE',
                    p.manzana AS 'MANZANA',
                    p.calle AS 'CALLE',
                    p.nOficial AS 'N OFICIAL',
                    (SELECT nombre FROM prototipos WHERE id=p.idPrototipo) AS 'PROTOTIPO',
                    pr.fecha AS 'FECHA PROSPECCION',
                    DATE(av.created) AS 'FECHA ALTA VENTA',
                    DATE(av.fechaValidacion) AS 'FECHA GESTORÍA',
                    (SELECT DATE(created) FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) AS 'FECHA TITULACIÓN',
                    av.fechaVenta AS 'FECHA VENTA',
                    (SELECT fechaEntrega FROM entrega WHERE idAltaVenta=av.id LIMIT 1) AS 'FECHA ENTREGA VIVIENDA',
                    p.precioVenta AS 'PRECIO VENTA',
                    CASE p.statusVenta WHEN 0 THEN 'DISPONIBLE' WHEN 1 THEN 'APARTADO/INTERESADO' WHEN 2 THEN 'PROCESO/EN TRÁMITE' WHEN 3 THEN 'VENDIDA' END AS 'statusVivienda',
                    UPPER(p.statusProyecto) AS 'ESTATUS PROYECTO',
                    (SELECT UPPER(statusGestoria) FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) AS 'ESTATUS'";
            }

            if($total){
                $fields=" SUM(p.precioVenta) AS total ";
            }

            $query="SELECT $fields FROM proyectos AS p ,alta_venta AS av, prospectos AS pr WHERE p.id=av.idProyecto AND pr.id=av.idProspecto ";

            if($estatus_vivienda != "0"){
                $estatus_vivienda=str_replace('-', ' ', $estatus_vivienda);
                $estatus_vivienda=explode('.', $estatus_vivienda);
                for ($i=0; $i < COUNT($estatus_vivienda); $i++) {
                    if(($fecha_inicio != '' && $fecha_inicio !=  null) && ($fecha_fin != '' && $fecha_fin !=  null)){
                        $fecha_inicio=new DateTime($info[2]);
                        $fecha_inicio=$fecha_inicio->format("Y-m-d");
                        $fecha_fin=new DateTime($info[3]);
                        $fecha_fin=$fecha_fin->format("Y-m-d");
                        $array1=array("espera de inscripcion","inscrito","ahorro voluntario","revision de condiciones","notaria","programado firma de escritura","firmado");
                        if($i==0){
                            if(in_array($estatus_vivienda[$i], $array1)){
                                $field="fechaProceso";
                            }else if($estatus_vivienda[$i]=="detonado"){
                                $field="fechaVenta";
                            }
                            $query.=" AND (((SELECT statusGestoria FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) LIKE '%".$estatus_vivienda[$i]."%' AND $field BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE)) ";
                        }else{
                            if(in_array($estatus_vivienda[$i], $array1)){
                                $field="fechaProceso";
                            }else if($estatus_vivienda[$i]=="detonado"){
                                $field="fechaVenta";
                            }
                            $query.=" OR ((SELECT statusGestoria FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) LIKE '%".$estatus_vivienda[$i]."%' AND $field BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE)) ";
                        }
                    }else{
                        if($i==0){
                            $query.=" AND ((SELECT statusGestoria FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) LIKE '%".$estatus_vivienda[$i]."%'";
                        }else{
                            $query.=" OR (SELECT statusGestoria FROM gestoria WHERE idAltaVenta=av.id LIMIT 1) LIKE '%".$estatus_vivienda[$i]."%'";
                        }
                    }
                    if($i==COUNT($estatus_vivienda) - 1){
                        $query.=" )";
                    }
                }
            }
            if($promotor != "" && $promotor != 0 && $promotor != null){
                $query.=" AND pr.idPromotor=$promotor ";
            }
/*            if(($fecha_inicio != '' && $fecha_inicio !=  null) && ($fecha_fin != '' && $fecha_fin !=  null)){
                $fecha_inicio=new DateTime($info[2]);
                $fecha_inicio=$fecha_inicio->format("Y-m-d");
                $fecha_fin=new DateTime($info[3]);
                $fecha_fin=$fecha_fin->format("Y-m-d");
               $query .= " AND pr.fecha BETWEEN CAST('".$fecha_inicio."' AS DATE) AND CAST('".$fecha_fin."' AS DATE) ";
            }*/
            if($fraccionamiento != "" && $fraccionamiento != 0 && $fraccionamiento != null){
                $query.=" AND p.idFraccionamiento=$fraccionamiento ";
            }

            //validamos si se trata de calcular total validamos con group by
            if ($total && $estatus_vivienda == ''){
                $query .= " GROUP BY pr.id ";
            }

            $query=$this->db->query($query);

            if($query->num_rows() > 0){
                if(!$total){
                    return $query;
                }else{
                    $query=$query->row();
                    return "$".number_format($query->total,2);
                }
            }else{
                return 0;
            }
        }

        function getAllProspectsExistAltaVenta() {
            $id=$_SESSION['viv']['id'];
            $this->db->select($this->selectProspecto,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            //$this->db->where("p.idFraccionamiento = ".$_SESSION['viv']['idFraccionamiento']);
            if ($_SESSION['viv']['rol']!=1){
                $this->db->where("p.idFraccionamiento IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=".$id.")");
            }
            $this->db->join("alta_venta av", "p.id = av.idProyecto");
            $this->db->join("prospectos pro", "pro.id = av.idProspecto");
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getGestoriaValidacionVenta(){

        }

        function getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, $subQuery = false, $nameTable = '')
        {
            $this->db->select($this->selectDefault2, FALSE);
            $arrayWhere = array($this->alias . '.idFraccionamiento' => $idFraccionamiento, $this->alias . '.idPrototipo' => $idPrototipo);
            $this->db->where($arrayWhere);
            if($subQuery == true && $nameTable != ''){
                $this->db->where($this->alias . '.id NOT IN (SELECT idProyecto FROM '. $nameTable .')');
            }
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getLoteByIdFracIdProtLtMz($idFraccionamiento, $idPrototipo, $lote, $manzana)
        {
            $this->db->select($this->selectDefault2, FALSE);
            $arrayWhere = array($this->alias . '.idFraccionamiento' => $idFraccionamiento, $this->alias . '.idPrototipo' => $idPrototipo, $this->alias . '.lote' => $lote, $this->alias . '.manzana' => $manzana);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
    }


?>