<?php

    class mprogramaobra extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "programa_obra";
            $this->alias = 'po';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idPresupuesto
            ,".$this->alias.".idProyecto
            ,".$this->alias.".semana
            ,".$this->alias.".lote
            ,".$this->alias.".manzana
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPaquete' => '',
                'idPresupuesto' => '',
                'idProyecto' => '',
                'semana' => '',
                'lote' => '',
                'manzana' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idPresupuesto'] = $r->row()->idPresupuesto;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['semana'] = $r->row()->semana;
                $array['lote'] = $r->row()->lote;
                $array['manzana'] = $r->row()->manzana;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function valInsert($idPaquete,$idPresupuesto,$idProyecto){
            $query=$this->db->query("SELECT id FROM programa_obra WHERE idPaquete=$idPaquete AND idPresupuesto=$idPresupuesto 
            AND idProyecto=$idProyecto");
            return $query;
        }

        function insertBatchRegistros($registros){
            if (is_array($registros)){
                $this->db->insert_batch($this->table, $registros);
            }
        }
    }