<?php

    class Mpresupuestomo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "presupuesto_mo";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idManoObra
            ,".$this->alias.".idActividadPrototipo
            ,".$this->alias.".precioUnitario
            ,".$this->alias.".importe
            ,".$this->alias.".pctjeActividad
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idManoObra' => '',
                'idActividadPrototipo' => '',
                'precioUnitario' => '',
                'importe' => '',
                'pctjeActividad' => '',
                'tipo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idManoObra'] = $r->row()->idManoObra;
                $array['idActividadPrototipo'] = $r->row()->idActividadPrototipo;
                $array['precioUnitario'] = $r->row()->precioUnitario;
                $array['importe'] = $r->row()->importe;
                $array['pctjeActividad'] = $r->row()->pctjeActividad;
                $array['tipo'] = $r->row()->tipo;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getSumTotalUnitario($idManoObra){
            $this->db->select_sum($this->alias.'.importe');
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra, $this->alias.'.tipo' => 1);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->row()->importe > 0){
                return $query->row()->importe;
            }else{
                return 0;
            }
        }

        function getSumTotalUnitarioAjustes($idManoObra,$idPaquete=0){
            $extras="AND IF(pmo.tipo=2,pmo.id IN (SELECT aju2.idPresupuesto FROM ajustes aju2 WHERE aju2.idPaquete=$idPaquete AND aju2.tipo=2 AND aju2.tipoPPto=2),true)";
            $query=$this->db->query("SELECT SUM(if(aju.cantidad,act.cantidad + aju.cantidad,act.cantidad) * 
            if(aju.precioUnitario,pmo.precioUnitario + aju.precioUnitario,pmo.precioUnitario)) importe
            FROM presupuesto_mo pmo
            LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo
            LEFT JOIN ajustes aju ON aju.idPresupuesto=pmo.id AND aju.idPaquete=$idPaquete AND aju.status=1 AND aju.tipoPPto=2 AND (aju.tipo=3 OR aju.tipo=4) 
            LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
            WHERE pmo.idManoObra=$idManoObra $extras GROUP BY pmo.idManoObra");

            if($query->num_rows() > 0){
                return ($query->row()->importe > 0) ? $query->row()->importe : 0;
            }else{
                return 0;
            }
        }

        function getByidManoObraIdActividadPrototipo($idManoObra, $idActProt){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra,
                $this->alias.'.idActividadPrototipo' => $idActProt);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdManoObra($idManoObra){
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias . '.idManoObra' => $idManoObra,$this->alias . '.tipo'=>1);
            $this->db->where($arrayWhere);
            $this->db->order_by('(SELECT idCategoria FROM actividadesprototipo WHERE id=idActividadPrototipo)', "ASC");
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByIdManoObraAjustes($idManoObra,$idPaquete=0){
            $extras="AND IF(pmo.tipo=2,pmo.id IN (SELECT aju2.idPresupuesto FROM ajustes aju2 WHERE aju2.idPaquete=$idPaquete AND aju2.tipo=2 AND aju2.tipoPPto=2),true)";
            $query=$this->db->query("SELECT pmo.id,pmo.idActividadPrototipo, act.idCategoria,
            if(aju.cantidad,act.cantidad + aju.cantidad,act.cantidad) cantidad, 
            if(aju.precioUnitario,pmo.precioUnitario + aju.precioUnitario,pmo.precioUnitario) precioUnitario, 
            if(aju.precioUnitario,aju.precioUnitario,'') ajustePrecio, 
            if(aju.cantidad,aju.cantidad,'') ajusteCantidad, 
            pmo.importe,
            COUNT(aju.id) nAjustes, 
            IF(aju.tipo,aju.tipo,pmo.tipo) tipo FROM presupuesto_mo pmo
            LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo 
            LEFT JOIN ajustes aju ON aju.idPresupuesto=pmo.id AND aju.idPaquete=$idPaquete AND aju.status=1 AND aju.tipoPPto=2 AND (aju.tipo=3 OR aju.tipo=4) 
            LEFT JOIN actividades_mo actmo ON actmo.id=act.idActividad
            WHERE pmo.idManoObra=$idManoObra $extras GROUP BY pmo.id, aju.idPresupuesto ORDER BY act.idCategoria ASC");

            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getSumTotalPorcentaje($idManoObra){
            $this->db->select_sum($this->alias.'.pctjeActividad');
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->row()->pctjeActividad > 0){
                return $query->row()->pctjeActividad;
            }else{
                return 0;
            }
        }

        function getSumImportexCategoriaByIdMOCat($idManoObra, $idCategoria ){
            $this->db->select('SUM('.$this->alias.'.precioUnitario * ap.cantidad) as importe');
            $this->db->join('actividadesprototipo ap', 'ap.id = '.$this->alias.'.idActividadPrototipo');
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra, 'ap.idCategoria' => $idCategoria);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->row()->importe > 0){
                return $query->row()->importe;
            }else{
                return 0;
            }
        }

        function getSumUnitarioxCategoriaByIdMOCat($idManoObra, $idCategoria){
            $this->db->select_sum($this->alias.'.precioUnitario');
            $this->db->join('actividadesprototipo ap', 'ap.id = '.$this->alias.'.idActividadPrototipo');
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra, 'ap.idCategoria' => $idCategoria);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->row()->precioUnitario > 0){
                return $query->row()->precioUnitario;
            }else{
                return 0;
            }
        }
    }