<?php
    class mordenpago extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "orden_pago";
            $this->alias = 'o';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idEstimaciones
            ,".$this->alias.".monto
            ,".$this->alias.".statusPago
            ,".$this->alias.".retencion
            ,".$this->alias.".retencionvicios
            ,".$this->alias.".retencionAnticipo
            ,".$this->alias.".fechaAplicado
            ,".$this->alias.".formaPago
            ,".$this->alias.".nota
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPaquete' => '',
                'idEstimaciones' => '',
                'monto' => '',
                'statusPago' => '',
                'retencion' => '',
                'retencionvicios' => '',
                'retencionAnticipo' => '',
                'fechaAplicado' => '',
                'formaPago' => '',
                'nota' => '',
                'status' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idEstimaciones'] = $r->row()->idEstimaciones;
                $array['monto'] = $r->row()->monto;
                $array['statusPago'] = $r->row()->statusPago;
                $array['retencion'] = $r->row()->retencion;
                $array['retencionvicios'] = $r->row()->retencionvicios;
                $array['retencionAnticipo'] = $r->row()->retencionAnticipo;
                $array['fechaAplicado'] = $r->row()->fechaAplicado;
                $array['formaPago'] = $r->row()->formaPago;
                $array['nota'] = $r->row()->nota;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getActiveByIdEstimaciones($idEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            $this->db->where('('.$this->alias.".idEstimaciones LIKE '%,$idEstimaciones,%' OR ".$this->alias.".idEstimaciones LIKE '%,$idEstimaciones' OR ".$this->alias.".idEstimaciones LIKE '$idEstimaciones,%' OR ".$this->alias.".idEstimaciones = '$idEstimaciones') AND " .$this->alias.'.statusPago != 4');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getAllByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllPagadoFracturadoByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = $this->alias . '.idPaquete = ' . $idPaquete . ' AND ' . $this->alias . '.statusPago != 4 AND ' . $this->alias.'.statusPago != 1';
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdEstimaciones($idEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            //$this->db->where('('.$this->alias.".idEstimaciones LIKE '%,$idEstimaciones,%' OR ".$this->alias.".idEstimaciones LIKE '%,$idEstimaciones' OR ".$this->alias.".idEstimaciones LIKE '$idEstimaciones,%' OR ".$this->alias.".idEstimaciones = '$idEstimaciones')");
            $this->db->where("SUBSTRING_INDEX(".$this->alias.".idEstimaciones, ',', -1)"." = '$idEstimaciones'");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getEstimacionesByPaquete($idPaquete){
            $query=$this->db->query("SELECT COUNT(id) n,SUM(monto - retencion - retencionvicios - retencionAnticipo) acumulado, SUM(retencion) retencion, (retencionAnticipo + retencionvicios) otros
             FROM orden_pago WHERE idPaquete=$idPaquete AND (statusPago=2 OR statusPago=3)");
            return $query->row();
        }

        function getResumenEstimacionesByPaquete($idPaquete){
            $query=$this->db->query("SELECT COUNT(id) n,SUM(monto) estimacion,SUM(retencion + retencionAnticipo + retencionvicios) retencion FROM orden_pago WHERE idPaquete=$idPaquete");
            return $query->row();
        }

        function getResumenEstimacionesByContratista(){
            //$query=$this->db->query("SELECT idPaquete,(SELECT idConstructor FROM paquetes WHERE id=idPaquete) idConstructor,COUNT(id) n,SUM(monto) estimacion,SUM( retencion + retencionAnticipo + retencionvicios) retencion FROM orden_pago GROUP BY (SELECT idConstructor FROM paquetes WHERE id=idPaquete)");
            $query=$this->db->query("SELECT idPaquete,(SELECT idConstructor FROM paquetes WHERE id=idPaquete) idConstructor,COUNT(id) n,SUM(monto) estimacion,
            SUM(retencion + retencionAnticipo + retencionvicios) retencion FROM orden_pago op WHERE FIND_IN_SET((SELECT id FROM estimaciones_programa esp 
            WHERE idEstimacion=(SELECT id FROM estimacion_programa enp WHERE enp.idPaquete=op.idPaquete) AND NOW() BETWEEN fecha AND DATE_ADD(fecha, INTERVAL 7 DAY)),idEstimaciones) 
            GROUP BY (SELECT idConstructor FROM paquetes paq WHERE paq.id=op.idPaquete)");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getTotalFacturadoPagadoByIdPaquete($idPaquete)
        {
            //$query = $this->db->query("SELECT SUM(monto - (retencion + retencionvicios + retencionAnticipo)) AS total FROM orden_pago WHERE idPaquete = $idPaquete AND statusPago != 4 AND statusPago != 1;");
            $query = $this->db->query("SELECT SUM(monto) AS total FROM orden_pago WHERE idPaquete = $idPaquete AND statusPago != 4 AND statusPago != 1;");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getActualOrdenPago($idPaquete=0){
            $query=$this->db->query("SELECT IF(sum(monto), sum(monto),0) estimacion, IF(sum(retencion + retencionAnticipo + retencionvicios),
            sum(retencion + retencionAnticipo + retencionvicios),0) retencion FROM orden_pago
            WHERE FIND_IN_SET((SELECT id FROM estimaciones_programa WHERE idEstimacion=(SELECT id FROM estimacion_programa WHERE idPaquete=$idPaquete) AND 
            NOW() BETWEEN fecha AND DATE_ADD(fecha, INTERVAL 7 DAY)),idEstimaciones) LIMIT 1");
            return $query->row();
        }
    }