<?php

    class mordenes_pago extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "ordenes_pago";
            $this->alias = 'mo';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idConstructor
            ,".$this->alias.".semanaAnual
            ,".$this->alias.".nActividades
            ,".$this->alias.".nLotes
            ,".$this->alias.".nPaquetes
            ,".$this->alias.".fecha
            ,".$this->alias.".importe
            ,".$this->alias.".fg
            ,".$this->alias.".monto
            ,".$this->alias.".statusPago
            ,".$this->alias.".formaPago
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idConstructor' => '',
                'semanaAnual' => '',
                'nActividades' => '',
                'nLotes' => '',
                'nPaquetes' => '',
                'fecha' => '',
                'importe' => '',
                'fg' => '',
                'monto' => '',
                'statusPago' => '',
                'formaPago' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idConstructor'] = $r->row()->idConstructor;
                $array['semanaAnual'] = $r->row()->semanaAnual;
                $array['nActividades'] = $r->row()->nActividades;
                $array['nLotes'] = $r->row()->nLotes;
                $array['nPaquetes'] = $r->row()->nPaquetes;
                $array['fecha'] = $r->row()->fecha;
                $array['importe'] = $r->row()->importe;
                $array['fg'] = $r->row()->fg;
                $array['monto'] = $r->row()->monto;
                $array['statusPago'] = $r->row()->statusPago;
                $array['formaPago'] = $r->row()->formaPago;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }
    }