<?php

    class Mordencompraviv extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "orden_compra_viv";
            $this->alias = 'o';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idMaterial
            ,".$this->alias.".idPaquete
            ,".$this->alias.".semana
            ,".$this->alias.".descripcion
            ,".$this->alias.".fecha
            ,".$this->alias.".folio
            ,".$this->alias.".id_proveedor
            ,".$this->alias.".id_almacen
            ,".$this->alias.".id_moneda
            ,".$this->alias.".importe_neto
            ,".$this->alias.".numero_articulos
            ,".$this->alias.".fecha_entrega
            ,".$this->alias.".estatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idMaterial' => '',
                'idPaquete' => '',
                'semana' => '',
                'descripcion' => '',
                'fecha' => '',
                'folio' => '',
                'id_proveedor' => '',
                'id_almacen' => '',
                'id_moneda' => '',
                'importe_neto' => '',
                'numero_articulos' => '',
                'fecha_entrega' => '',
                'estatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idMaterial'] = $r->row()->idMaterial;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['semana'] = $r->row()->semana;
                $array['descripcion'] = $r->row()->descripcion;
                $array['fecha'] = $r->row()->fecha;
                $array['folio'] = $r->row()->folio;
                $array['id_proveedor'] = $r->row()->id_proveedor;
                $array['id_almacen'] = $r->row()->id_almacen;
                $array['id_moneda'] = $r->row()->id_moneda;
                $array['importe_neto'] = $r->row()->importe_neto;
                $array['numero_articulos'] = $r->row()->numero_articulos;
                $array['fecha_entrega'] = $r->row()->fecha_entrega;
                $array['estatus'] = $r->row()->estatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            //$arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByFolio($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.folio' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getAllByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function valInsert($id){
            $query=$this->db->query("SELECT id FROM orden_compra WHERE id=$id");
            return ($query->num_rows()>0) ? false : true;
        }

        function valUpdate($id,$data){
            $search="";
            foreach ($data as $key => $val) {
                switch ($key) {
                    case 'lista_articulos':
                        break;
                    case 'id':
                        $id=$val;
                        break;
                    default:
                        $search.=' AND '.$key.'="'.$val.'"';
                }
            }
            $query=$this->db->query("SELECT id FROM orden_compra_viv WHERE id=$id $search");
            return ($query->num_rows()>0) ? false : true;
        }

        function getByIdMatPaqSemProvFol($idMaterial, $idPaquete, $semana, $idProveedor, $folio){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idMaterial' => $idMaterial, $this->alias.'.idPaquete' => $idPaquete, $this->alias.'.semana' => $semana, $this->alias.'.id_proveedor' => $idProveedor, $this->alias.'.folio' => $folio);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }
    }