<?php

    class Mordencompra extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "orden_compra";
            $this->alias = 'o';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idMaterial
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".idPaquete
            ,".$this->alias.".semana
            ,".$this->alias.".descripcion
            ,".$this->alias.".fecha
            ,".$this->alias.".folio
            ,".$this->alias.".id_proveedor
            ,".$this->alias.".id_almacen
            ,".$this->alias.".id_moneda
            ,".$this->alias.".importe_neto
            ,".$this->alias.".numero_articulos
            ,".$this->alias.".fecha_entrega
            ,".$this->alias.".estatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idMaterial' => '',
                'idEmpresa' => '',
                'idPaquete' => '',
                'semana' => '',
                'descripcion' => '',
                'fecha' => '',
                'folio' => '',
                'id_proveedor' => '',
                'id_almacen' => '',
                'id_moneda' => '',
                'importe_neto' => '',
                'numero_articulos' => '',
                'fecha_entrega' => '',
                'estatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idMaterial'] = $r->row()->idMaterial;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['semana'] = $r->row()->semana;
                $array['descripcion'] = $r->row()->descripcion;
                $array['fecha'] = $r->row()->fecha;
                $array['folio'] = $r->row()->folio;
                $array['id_proveedor'] = $r->row()->id_proveedor;
                $array['id_almacen'] = $r->row()->id_almacen;
                $array['id_moneda'] = $r->row()->id_moneda;
                $array['importe_neto'] = $r->row()->importe_neto;
                $array['numero_articulos'] = $r->row()->numero_articulos;
                $array['fecha_entrega'] = $r->row()->fecha_entrega;
                $array['estatus'] = $r->row()->estatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            //$arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllExcelRows(){
            $query=$this->db->query("
            SELECT  (SELECT titulo FROM paquetes WHERE id = idPaquete limit 1),
                    `folio`,
                    `fecha`,
                    `fecha_entrega`,
                    (select nombre from proveedores where id = id_proveedor limit 1),
                    `importe_neto`,
                    `semana`
            FROM `orden_compra`
            ORDER BY id DESC
            ");
             
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getAllByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function valInsert($id,$idEmpresa){
            $query=$this->db->query("SELECT id FROM orden_compra WHERE id=$id AND idEmpresa=$idEmpresa");
            return ($query->num_rows()>0) ? false : true;
        }

        function getProveedor($idPaquete){
            $query=$this->db->query("
                SELECT (SELECT nombre FROM proveedores WHERE id=idProveedor) proveedor FROM presupuesto_mat WHERE idMaterial=(SELECT id FROM material WHERE idPaquete = $idPaquete LIMIT 1) AND idProveedor>0 GROUP BY idProveedor
            ");

             if($query->num_rows()>0){
                return $query->result();
            }else{
                return 0;
            }
        }

        function valUpdate($id,$data){
            $search="";
            foreach ($data as $key => $val) {
                switch ($key) {
                    case 'lista_articulos':
                        break;
                    case 'id':
                        $id=$val;
                        break;
                    default:
                        $search.=' AND '.$key.'="'.$val.'"';
                }
            }
            $query=$this->db->query("SELECT id FROM orden_compra WHERE id=$id $search");
            return ($query->num_rows()>0) ? false : true;
        }

        function actualiza($data,$id){
            $idEmpresa=$data["idEmpresa"];
            $data['updated'] = date("Y-m-d H:i:s");
            $this->db->update($this->table, $data," id = $id AND idEmpresa=$idEmpresa ");
            return true;
        }

        function getByIdPaqIdMatSemIdProv($idPaquete, $idMaterial, $semana, $idProveedor){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.idMaterial' => $idMaterial, $this->alias.'.semana' => $semana, $this->alias.'.id_proveedor' => $idProveedor);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }
        
        function getAllByEstatusEmpresa($estatus, $idEmpresa){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.estatus' => $estatus, $this->alias.'.idEmpresa' => $idEmpresa, $this->alias.'.idPaquete >' => 0);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllExist($idEmpresa){
            //$query=$this->db->query("SELECT * FROM orden_compra WHERE idPaquete > 0 AND idEmpresa=$idEmpresa");
            $query=$this->db->query("SELECT * FROM orden_compra WHERE idEmpresa=$idEmpresa AND id_almacen IN 
            (SELECT id FROM almacenes WHERE idEmpresa=$idEmpresa AND idPaquete>0)");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllExistTest($idEmpresa){
            $query=$this->db->query("SELECT * FROM orden_compra WHERE idEmpresa=$idEmpresa AND id_almacen IN 
            (SELECT id FROM almacenes WHERE idEmpresa=$idEmpresa AND idPaquete>0)");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        var $column_order = array(null, 'idPaquete','folio','fecha','fecha_entrega','id_proveedor','importe_neto','semana'); //set column field database for datatable orderable
        var $column_search = array('idPaquete','folio','fecha','fecha_entrega','id_proveedor','importe_neto','semana'); //set column field database for datatable searchable
        var $order = array('id' => 'desc'); // default order

     


            private function _get_datatables_query()
            {

            $this->db->from($this->table);

            
            if($_SESSION["viv"]["idEmpresa"] > 0){
                 $id=$_SESSION["viv"]["idEmpresa"];
                 $arrayWhere = array('idEmpresa' => $id);
                 $this->db->where($arrayWhere);
            }

            $i = 0;

            foreach ($this->column_search as $item) // loop column
            {
                if($_POST['search']['value']) // if datatable send POST for search
                {

                    if($i===0) // first loop
                    {
                        $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                        $this->db->like($item, $_POST['search']['value']);
                    }
                    else
                    {
                        $this->db->or_like($item, $_POST['search']['value']);
                    }

                    if(count($this->column_search) - 1 == $i) //last loop
                        $this->db->group_end(); //close bracket
                }
                $i++;
            }

            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }

         function get_datatables()
        {
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }

        function count_filtered()
        {
            $this->_get_datatables_query();
            $query = $this->db->get();
            return $query->num_rows();
        }

        public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }

        public function getImporteBypaq($idPaquete=0){
            $query=$this->db->query("SELECT SUM(importe_neto * 1.16) total FROM compra WHERE idPaquete=$idPaquete AND id");
            if($query->num_rows()>0){
                return $query->row();
            }else{
                return 0;
            }
        }

        public function updateIdByFolio($idEmpresa,$id,$folio){
            $status=false;
            $oc=$this->db->query("SELECT id FROM orden_compra WHERE folio='$folio' AND idEmpresa=$idEmpresa");
            if($oc->num_rows() > 0){
                $oc=$oc->row();
                if($oc->id != $id){
                    $this->db->query("UPDATE orden_compra SET id=$id,updated=NOW() WHERE folio='$folio' AND idEmpresa=$idEmpresa");
                    $status=true;
                }
            }
            return $status;
        }

    }