<?php

    class mmovimientos extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "movimientos";
            $this->alias = 'mo';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idOrdenPago
            ,".$this->alias.".semanaAnual
            ,".$this->alias.".fecha
            ,".$this->alias.".tipo
            ,".$this->alias.".monto
            ,".$this->alias.".saldo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idOrdenPago' => '',
                'semanaAnual' => '',
                'fecha' => '',
                'tipo' => '',
                'monto' => '',
                'saldo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idOrdenPago'] = $r->row()->idOrdenPago;
                $array['semanaAnual'] = $r->row()->semanaAnual;
                $array['fecha'] = $r->row()->fecha;
                $array['tipo'] = $r->row()->tipo;
                $array['monto'] = $r->row()->monto;
                $array['saldo'] = $r->row()->saldo;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdAndTipo($idOp,$tipo,$corte){
            $filter=($tipo>0) ? "AND tipo=$tipo" : "";
            $query=$this->db->query("SELECT mov.id,mov.monto,mov.tipo FROM movimientos mov
            LEFT JOIN ordenes_pago op ON op.id=mov.idOrdenPago
            WHERE mov.semanaAnual=$corte->semana AND YEAR(mov.fecha)=$corte->ano
            AND op.id=$idOp $filter GROUP BY mov.id");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdConstructorAndTipo($idConstructor,$ano,$semana,$tipo=0){
            $filter=($tipo>0) ? "AND tipo=$tipo" : "";
            $query=$this->db->query("SELECT mov.id,mov.monto,mov.tipo FROM movimientos mov
            LEFT JOIN ordenes_pago op ON op.id=mov.idOrdenPago
            WHERE mov.semanaAnual=$semana AND YEAR(mov.fecha)=$ano 
            AND op.idConstructor=$idConstructor $filter GROUP BY mov.id");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }