<?php

    class mlugaresprospeccion extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "lugares_prospeccion";
            $this->alias = 'lp';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".titulo
            ,".$this->alias.".statusProspecto
            ,".$this->alias.".statusPublicidad
            ,".$this->alias.".statusCaptacion
            ,".$this->alias.".statusDescripcion
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'titulo' => '',
                'statusProspecto' => '',
                'statusPublicidad' => '',
                'statusCaptacion' => '',
                'statusDescripcion' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['titulo'] = $r->row()->titulo;
                $array['status'] = $r->row()->status;
                $array['statusProspecto'] = $r->row()->statusProspecto;
                $array['statusPublicidad'] = $r->row()->statusPublicidad;
                $array['statusCaptacion'] = $r->row()->statusCaptacion;
                $array['statusDescripcion'] = $r->row()->statusDescripcion;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByModulo($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            switch ($id){
                case '1':
                    $this->db->where($this->alias.'.statusProspecto =', true);
                    break;

                case '2':
                    $this->db->where($this->alias.'.statusPublicidad =', true);
                    break;

                case '3':
                    $this->db->where($this->alias.'.statusCaptacion =', true);
                    break;
                
                default:
                    break;
            }
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }