<?php

    class Mlogsws extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "logs_ws";
            $this->alias = 'lws';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".nombreTabla
            ,".$this->alias.".funcion
            ,".$this->alias.".http_code
            ,".$this->alias.".insertados
            ,".$this->alias.".actualizados
            ,".$this->alias.".totalRegistros
            ,".$this->alias.".json
            ,".$this->alias.".time
            ,".$this->alias.".status
            ,".$this->alias.".created_by
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idEmpresa' => '',
                'nombreTabla' => '',
                'funcion' => '',
                'http_code' => '',
                'insertados' => '',
                'actualizados' => '',
                'totalRegistros' => '',
                'json' => '',
                'time' => '',
                'status' => '',
                'created_by' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['nombreTabla'] = $r->row()->nombreTabla;
                $array['funcion'] = $r->row()->funcion;
                $array['http_code'] = $r->row()->http_code;
                $array['insertados'] = $r->row()->insertados;
                $array['actualizados'] = $r->row()->actualizados;
                $array['totalRegistros'] = $r->row()->totalRegistros;
                $array['json'] = $r->row()->json;
                $array['time'] = $r->row()->time;
                $array['status'] = $r->row()->status;
                $array['created_by'] = $r->row()->created_by;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getByIdEmpresa($id){
            $this->db->select($this->selectDefault,FALSE);
             $arrayWhere = array($this->alias.'.idEmpresa' => $id);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }       



        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdEmpresaTabla($idEmpresa, $nombreTabla){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idEmpresa' => $idEmpresa, $this->alias.'.nombreTabla' => $nombreTabla);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $this->db->limit(1);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }