<?php

    class Mlogscomisiones extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "logs_comisiones";
            $this->alias = 'lc';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idComision
            ,".$this->alias.".comisionAnterior
            ,".$this->alias.".comisionNueva
            ,".$this->alias.".status
            ,".$this->alias.".created_by
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idComision' => '',
                'comisionAnterior' => '',
                'comisionNueva' => '',
                'status' => '',
                'created_by' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idComision'] = $r->row()->idComision;
                $array['comisionAnterior'] = $r->row()->comisionAnterior;
                $array['comisionNueva'] = $r->row()->comisionNueva;
                $array['status'] = $r->row()->status;
                $array['created_by'] = $r->row()->created_by;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }       



        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }