<?php

    class mincidente extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "incidente";
            $this->alias = 'i';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPostventa
            ,".$this->alias.".instElectricas
            ,".$this->alias.".descInstElectricas
            ,".$this->alias.".instHidraulicas
            ,".$this->alias.".descInstHidraulicas
            ,".$this->alias.".instSanitarias
            ,".$this->alias.".descInstSanitarias
            ,".$this->alias.".instGas
            ,".$this->alias.".descInstGas
            ,".$this->alias.".canceleria
            ,".$this->alias.".descCanceleria
            ,".$this->alias.".impermeabilizacion
            ,".$this->alias.".descImpermeabilizacion
            ,".$this->alias.".acabados
            ,".$this->alias.".descAcabados
            ,".$this->alias.".estructural
            ,".$this->alias.".descEstructural
            ,".$this->alias.".accesorios
            ,".$this->alias.".descAccesorios
            ,".$this->alias.".calentadorAgua
            ,".$this->alias.".fechaCierre
            ,".$this->alias.".descCalentadorAgua
            ,".$this->alias.".created
            ,".$this->alias.".created_by
            ,(SELECT g.ronda FROM gestoria g WHERE g.idAltaVenta=(SELECT idAltaVenta FROM postventa p WHERE p.id=i.idPostventa)) ronda
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPostventa' => '',
                'instElectricas' => '',
                'descInstElectricas' => '',
                'instHidraulicas' => '',
                'descInstHidraulicas' => '',
                'instSanitarias' => '',
                'descInstSanitarias' => '',
                'instGas' => '',
                'descInstGas' => '',
                'canceleria' => '',
                'descCanceleria' => '',
                'impermeabilizacion' => '',
                'descImpermeabilizacion' => '',
                'acabados' => '',
                'descAcabados' => '',
                'estructural' => '',
                'descEstructural' => '',
                'accesorios' => '',
                'descAccesorios' => '',
                'calentadorAgua' => '',
                'descCalentadorAgua' => '',
                'fechaCierre' => '',
                'created' => '',
                'created_by' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPostventa'] = $r->row()->idPostventa;
                $array['instElectricas'] = $r->row()->instElectricas;
                $array['descInstElectricas'] = $r->row()->descInstElectricas;
                $array['instHidraulicas'] = $r->row()->instHidraulicas;
                $array['descInstHidraulicas'] = $r->row()->descInstHidraulicas;
                $array['instSanitarias'] = $r->row()->instSanitarias;
                $array['descInstSanitarias'] = $r->row()->descInstSanitarias;
                $array['instGas'] = $r->row()->instGas;
                $array['descInstGas'] = $r->row()->descInstGas;
                $array['canceleria'] = $r->row()->canceleria;
                $array['descCanceleria'] = $r->row()->descCanceleria;
                $array['impermeabilizacion'] = $r->row()->impermeabilizacion;
                $array['descImpermeabilizacion'] = $r->row()->descImpermeabilizacion;
                $array['acabados'] = $r->row()->acabados;
                $array['descAcabados'] = $r->row()->descAcabados;
                $array['estructural'] = $r->row()->estructural;
                $array['descEstructural'] = $r->row()->descEstructural;
                $array['accesorios'] = $r->row()->accesorios;
                $array['descAccesorios'] = $r->row()->descAccesorios;
                $array['calentadorAgua'] = $r->row()->calentadorAgua;
                $array['fechaCierre'] = $r->row()->fechaCierre;
                $array['descCalentadorAgua'] = $r->row()->descCalentadorAgua;
                $array['created'] = $r->row()->created;
                $array['created_by'] = $r->row()->created_by;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll($status=1){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true,$this->alias.'.statusIncidencia' => $status);
            $this->db->where($arrayWhere);
            $this->db->where(' (SELECT status FROM fraccionamientos WHERE id=(SELECT idFraccionamiento FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id=(SELECT idAltaVenta FROM postventa WHERE id=idPostventa ) ) ) )=1');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPostventa($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPostventa' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getLastRowByIdPostventa($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPostventa' => $id);
            $this->db->where($arrayWhere);
            $this->db->order_by("id", "desc");
            $this->db->limit(1);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
                // return $query;
            }
            else{
                return 0;
            }
        }

        function getConstructorByIdProyecto($idProyecto=0){
            $query="SELECT CONCAT(nombre,' ',apellidoP,' ',apellidoM) nombre FROM constructores WHERE id=(SELECT idConstructor FROM paquetes WHERE id=(SELECT idPaquete FROM detalle_paquete WHERE idProyecto=$idProyecto)) ";
            $query=$this->db->query($query);
            if($query->num_rows()>0){
                $query=$query->row();
                return $query->nombre;
            }else{
                return 0;
            }
        }

    }
?>