<?php

    class mfoliosavaluo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "folios_avaluo";
            $this->alias = 'fa';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".titulo
            ,".$this->alias.".status
            ,".$this->alias.".created
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'titulo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['titulo'] = $r->row()->titulo;
                $array['status'] = $r->row()->status;
                $array['created'] = $r->row()->created;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll($id = 0, $all=false){
            $this->db->select($this->selectDefault,FALSE);//.",(SELECT count(idAvaluo) FROM avaluos_proyectos WHERE id = avaluos_proyectos.idAvaluo HAVING count(idAvaluo)<4) AS totAv"
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            if($all==false){
                $this->db->where($this->alias.'.disponible=', 1);
            }
            if ($id > 0){
                $this->db->or_where($this->alias.'.id=',$id);
            }
            //$this->db->where("fa.id IN (SELECT count(idAvaluo) FROM avaluos_proyectos HAVING count(idAvaluo)<4)");
            //$this->db->join("avaluos_proyectos ap","fa.id=ap.idAvaluo","left");
            $this->db->order_by($this->alias.'.id', "desc");
            $this->db->group_by($this->alias.'.id');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByFolio($folio = ''){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.folio' => $folio);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getCSVFolios(){
        $query = $this->db->query("SELECT
                                    (SELECT titulo FROM folios_avaluo WHERE id=idAvaluo) 'FOLIO',
                                    (SELECT titulo FROM fraccionamientos WHERE id=(SELECT idFraccionamiento FROM proyectos WHERE id=idProyecto)) AS 'FRACCIONAMIENTO',
                                    (SELECT lote FROM proyectos WHERE id=idProyecto) AS 'LOTE',
                                    (SELECT manzana FROM proyectos WHERE id=idProyecto) AS 'MANZANA',
                                    (SELECT UPPER(CONCAT(nombre,' ',apellidoP)) FROM prospectos WHERE id=idProspecto) AS 'CLIENTE',
                                    fechaAsignacion AS 'FECHA ASIGNACION',
                                    fechaDesasignacion AS 'FECHA DES/ASIGNACION',
                                    IF(statusAsignacion = 1,'ACTIVO','INACTIVO') AS 'ESTATUS'
                                    FROM `avaluos_proyectos`

                                    UNION ALL

                                   SELECT
                                    titulo 'FOLIO',
                                    '' AS 'FRACCIONAMIENTO',
                                    '' AS 'LOTE',
                                    '' AS 'MANZANA',
                                    '' AS 'CLIENTE',
                                    '' AS 'FECHA ASIGNACION',
                                    '' AS 'FECHA DES/ASIGNACION',
                                    'PENDIENTE DE ASIGNAR' AS 'ESTATUS'
                                    FROM `folios_avaluo` WHERE id NOT IN (SELECT idAvaluo FROM avaluos_proyectos)
                                     ");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }