<?php
    class mempresas extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "empresas";
            $this->alias = 'e';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".abrev
            ,".$this->alias.".titulo
            ,".$this->alias.".bdServer
            ,".$this->alias.".foto
            ,".$this->alias.".thumbnail            
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectResult = "".
                $this->alias.".id
            ,CONCAT(".$this->alias.".area,' ',".$this->alias.".apellidoP) AS titulo";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'abrev' => '',
                'titulo' => '',
                'bdServer' => '',
                'foto' => '',
                'thumbnail' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['abrev'] = $r->row()->abrev;
                $array['titulo'] = $r->row()->titulo;
                $array['bdServer'] = $r->row()->bdServer;
                $array['foto'] = $r->row()->foto;
                $array['thumbnail'] = $r->row()->thumbnail;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }


        function getAllExcelRows(){
            
            $query=$this->db->query("
            SELECT `abrev`,`titulo`,`bdServer`
            FROM `empresas`
            WHERE status = 1 ORDER BY  id  DESC
            ");
             
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }
        function getByIdUnidad($idUnidad){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idUnidad' => $idUnidad);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        var $column_order = array(null,'abrev','titulo','bdServer','imagen'); //set column field database for datatable orderable
        var $column_search = array('abrev','titulo','bdServer','imagen'); //set column field database for datatable searchable
        var $order = array('id' => 'desc'); // default order

            private function _get_datatables_query()
            {

            $this->db->from($this->table);

            $i = 0;

            foreach ($this->column_search as $item) // loop column
            {
                if($_POST['search']['value']) // if datatable send POST for search
                {

                    if($i===0) // first loop
                    {
                        $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                        $this->db->like($item, $_POST['search']['value']);
                    }
                    else
                    {
                        $this->db->or_like($item, $_POST['search']['value']);
                    }

                    if(count($this->column_search) - 1 == $i) //last loop
                        $this->db->group_end(); //close bracket
                }
                $i++;
            }

            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }
        }

         function get_datatables()
        {
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }

             function count_filtered()
        {
            $this->_get_datatables_query();
            $query = $this->db->get();
            return $query->num_rows();
        }

        public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }


}