<?php

    class Mdetallepaquete extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "detalle_paquete";
            $this->alias = 'd';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idProyecto
            ,".$this->alias.".idResidente
            ,".$this->alias.".idInspector
            ,".$this->alias.".idCoordinador
            ,".$this->alias.".rango_lotes
            ,".$this->alias.".statusAsignado
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectDefault2 = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idProyecto
            ,(SELECT CONCAT(lote, ' (', manzana, ')') FROM proyectos WHERE id = ".$this->alias.".idProyecto) AS titulo
            ,".$this->alias.".idResidente
            ,".$this->alias.".idInspector
            ,".$this->alias.".idCoordinador
            ,".$this->alias.".rango_lotes
            ,".$this->alias.".statusAsignado
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPaquete' => '',
                'idProyecto' => '',
                'idResidente' => '',
                'idInspector' => '',
                'idCoordinador' => '',
                'rango_lotes' => '',
                'statusAsignado' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idResidente'] = $r->row()->idResidente;
                $array['idInspector'] = $r->row()->idInspector;
                $array['idCoordinador'] = $r->row()->idCoordinador;
                $array['rango_lotes'] = $r->row()->rango_lotes;
                $array['statusAsignado'] = $r->row()->statusAsignado;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPaqueteIdProyecto($idPaquete, $idProyecto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.idProyecto' => $idProyecto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getByAsignado($idPaquete, $where_in = false, $idResidente = array()){
            $this->db->select($this->selectDefault2,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.statusAsignado' => 0);
            $this->db->where($arrayWhere);
            if($where_in){
                $this->db->or_where_in($this->alias.'.idResidente', $idResidente);
            }
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getByIdResidente($idPaquete, $idResidente){
            $this->db->select($this->selectDefault2,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.idResidente' => $idResidente);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getByIdProyecto($idProyecto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idProyecto' => $idProyecto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getResidentesByIdPaquete($idPaquete){
            $this->db->select($this->alias.'.idResidente',FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $this->db->group_by("idResidente");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getProyectosByPaquete($idPaquete){
            $query="SELECT idProyecto id,(SELECT lote FROM proyectos WHERE id=idProyecto) lote,(SELECT manzana FROM proyectos WHERE id=idProyecto) manzana,
             (SELECT CONCAT(lote, ' (', manzana, ')') FROM proyectos WHERE id=idProyecto) titulo
             FROM detalle_paquete WHERE idPaquete=$idPaquete ORDER BY idProyecto";

            $query=$this->db->query($query);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByFraccMza($idFraccionamiento,$manzana){
            $query=$this->db->query("SELECT dp.id,dp.idResidente,dp.idInspector,dp.idCoordinador,dp.idCoordinadorC,arr.estatus_arranque, pro.lote,pro.manzana FROM detalle_paquete dp 
            LEFT JOIN arranque arr ON FIND_IN_SET(dp.idPaquete,arr.idPaquetes) 
            LEFT JOIN proyectos pro ON pro.id=dp.idProyecto 
            LEFT JOIN fraccionamientos fra ON fra.id=pro.idFraccionamiento 
            WHERE arr.estatus_arranque < 3 AND pro.idFraccionamiento=$idFraccionamiento
            AND pro.manzana = '$manzana' GROUP BY pro.id ORDER BY pro.lote+1 ASC");
            return $query;
        }
    }