<?php
    class mdetalleop extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "detalle_op";
            $this->alias = 'd';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idOrdenPago
            ,".$this->alias.".idPresupuesto
            ,".$this->alias.".lotes
            ,".$this->alias.".precioUnitario
            ,".$this->alias.".monto
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idOrdenPago' => '',
                'idPresupuesto' => '',
                'lotes' => '',
                'precioUnitario' => '',
                'monto' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idOrdenPago'] = $r->row()->idOrdenPago;
                $array['idPresupuesto'] = $r->row()->idPresupuesto;
                $array['lotes'] = $r->row()->lotes;
                $array['precioUnitario'] = $r->row()->precioUnitario;
                $array['monto'] = $r->row()->monto;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByIdOrdenPIdPresupuesto($idOrdenPago, $idPresupuesto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idOrdenPago' => $idOrdenPago, $this->alias.'.idPresupuesto' => $idPresupuesto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        //Es por si desmarcan lotes/actividades en el avance
        function getIdsByIdOrdenPago($idOrdenPago){
            $this->db->select($this->alias.'.id',FALSE);
            $arrayWhere = array($this->alias.'.idOrdenPago' => $idOrdenPago);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            return 0;
        }

        function getAllByIdOrdenPago($idOrdenPago){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idOrdenPago' => $idOrdenPago);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            return 0;
        }

        
        function existeByIdPresupuesto($idPresupuesto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPresupuesto' => $idPresupuesto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return true;
            }
            return 0;
        }
    }