<?php

    class mcreator extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "creator";
            $this->alias = 'cre';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idArranque
            ,".$this->alias.".titulo
            ,".$this->alias.".idPaquetes
            ,".$this->alias.".json
            ,".$this->alias.".estatus
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r){
            $array = array(
                'id' => '',
                'idEmpresa' => '',
                'idFraccionamiento' => '',
                'idArranque' => '',
                'titulo' => '',
                'idPaquetes' => '',
                'json' => '',
                'estatus' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idArranque'] = $r->row()->idArranque;
                $array['titulo'] = $r->row()->titulo;
                $array['idPaquetes'] = $r->row()->idPaquetes;
                $array['json'] = $r->row()->json;
                $array['estatus'] = $r->row()->estatus;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getLteByMza($idFraccionamiento,$manzana){
            //AND ges.statusGestoria='detonado'
            $query=$this->db->query("SELECT av.idProyecto, pro.manzana,pro.lote,pro.idPrototipo, dp.id, prot.nombre FROM alta_venta av
            LEFT JOIN proyectos pro ON pro.id=av.idProyecto
            LEFT JOIN prototipos prot ON prot.id=pro.idPrototipo
            LEFT OUTER JOIN detalle_paquete dp ON dp.idProyecto=pro.id
            WHERE pro.idFraccionamiento=$idFraccionamiento AND dp.id IS NULL 
            AND pro.manzana='$manzana' AND av.status=1
            ORDER BY pro.idPrototipo");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getManzanas($idFraccionamiento){
            //AND ges.statusGestoria='detonado'
            $query=$this->db->query("SELECT pro.manzana FROM gestoria ges 
            LEFT JOIN alta_venta av ON av.id=ges.idAltaVenta AND av.status=1
            LEFT JOIN proyectos pro ON pro.id=av.idProyecto
            LEFT OUTER JOIN detalle_paquete dp ON dp.idProyecto=pro.id
            WHERE pro.idFraccionamiento=$idFraccionamiento
            GROUP BY pro.manzana
            ORDER BY pro.manzana+1 ASC");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    
        function getPaquetes($idEmpresa,$idFraccionamiento,$lotes){
            //AND ges.statusGestoria='detonado'
            $query=$this->db->query("SELECT $idEmpresa idEmpresa,pro.idFraccionamiento,pro.idPrototipo,prot.nombre,GROUP_CONCAT(pro.id) lotes, 
            ppto.id idPresupuesto,0 rondas, COUNT(pro.id) nLotes,ppto.idPmo, ppto.idPmat 
            FROM alta_venta av
            LEFT JOIN proyectos pro ON pro.id=av.idProyecto
            LEFT JOIN prototipos prot ON prot.id=pro.idPrototipo
            LEFT JOIN presupuestos ppto ON ppto.idPrototipo=pro.idPrototipo AND ppto.idFraccionamiento=$idFraccionamiento AND ppto.idEmpresa=$idEmpresa
            WHERE pro.idFraccionamiento=$idFraccionamiento AND FIND_IN_SET(pro.id,'$lotes') AND av.status=1 
            GROUP BY pro.idPrototipo ORDER BY pro.idPrototipo+1 ASC");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getRangoLotes($lotes){
            foreach($lotes as $lote){
                $existe = $this->mproyecto->getById($lote);
                if(!is_numeric($existe)){
                    $lt = $existe['lote'];
                    $manzana = $existe['manzana'];
                    $lotesProyecto = $this->mdetallepaquete->getByIdProyecto($lote);
                    if( (is_numeric($lotesProyecto) ) ){
                        $arrMZ[$manzana][] = $lt;
                    }else{
                        echo "<p> EL LT $lt DE LA MZA $manzana PERTENECE A OTRO PAQUETE </p>";
                    }
                }
            }
            $txtRango = '';
            foreach($arrMZ as $manz => $lot){
                sort($lot);
                $arrMZ[$manz] = $lot;
                $ini = 0;
                $fin = 0;
                $con = 0;
                $txtM = '';
                foreach($lot as $lot2){
                    if($ini == 0){
                        $ini = $lot2;
                        $fin = $lot2;
                    }
                    else {
                        if($fin == $ini){
                            $con = $lot2;
                            if( ($con - $fin) == 1 ){
                                $fin = $lot2;
                            }
                            else{
                                $txtM = $txtM . $ini . ',';
                                $ini = $con;
                                $fin = $con;
                            }
                        }
                        else{
                            $con = $lot2;
                            if( ($con - $fin) == 1 ){
                                $fin = $lot2;
                            }
                            else{
                                $txtM = $txtM . $ini . '-' . $fin . ',';
                                $ini = $con;
                                $fin = $con;
                            }
                        }
                    }
                }
                if($ini > 0 && $ini == $fin){
                    $txtM = $txtM . $ini . ',';
                }
                if($ini > 0 && $ini != $fin){
                    $txtM = $txtM . $ini . '-' . $fin . ',';
                }
                $txtM = substr($txtM, 0, -1);
                $txtRango = $txtRango . $txtM . '_' . $manz . ' ';
            }
            return substr($txtRango, 0, -1);
        }
    }