<?php

    class mcortes extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "cortes";
            $this->alias = 'c';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".semana
            ,".$this->alias.".importe
            ,".$this->alias.".retenciones    
            ,".$this->alias.".total
            ,".$this->alias.".statusCorte
            ,".$this->alias.".fechaCorte
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'semana' => '',
                'importe' => '',
                'retenciones' => '',
                'total' => '',
                'statusCorte' => '',
                'fechaCorte' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['semana'] = $r->row()->semana;
                $array['importe'] = $r->row()->importe;
                $array['retenciones'] = $r->row()->retenciones;
                $array['total'] = $r->row()->total;
                $array['statusCorte'] = $r->row()->statusCorte;
                $array['fechaCorte'] = $r->row()->fechaCorte;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function valCorteActual($id=0){
            $query=$this->db->query("SELECT *,YEAR(fechaCorte) ano FROM cortes cor WHERE 
            IF($id=0, semana=WEEK(NOW(),7) AND YEAR(NOW())=YEAR(cor.fechaCorte), cor.id=$id)");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getCorteActual(){
            $query=$this->db->query("SELECT WEEK(NOW(),7) semana, NOW() fechaCorte");
            if($query->num_rows()>0){
                return $query->row();
            }else{
                return 0;
            }
        }
    }